<?php $__env->startSection('title', 'Register'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-md mx-auto px-3 sm:px-4">
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8">
        <h1 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center">Create an Account</h1>

        <?php if(isset($userRegistrationEnabled) && !$userRegistrationEnabled): ?>
            <div class="bg-red-50 border-2 border-red-200 rounded-lg p-4 sm:p-6 text-center">
                <i class="fas fa-exclamation-circle text-red-500 text-3xl sm:text-4xl mb-2 sm:mb-3"></i>
                <h2 class="text-lg sm:text-xl font-bold text-red-800 mb-2">Registration Disabled</h2>
                <p class="text-red-700 mb-3 sm:mb-4 text-sm sm:text-base">User registration is currently disabled by the administrator.</p>
                <?php if(isset($vendorRegistrationEnabled) && $vendorRegistrationEnabled): ?>
                    <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base">However, vendor registration is still available.</p>
                    <a href="<?php echo e(route('vendor.register')); ?>" class="inline-block bg-primary text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-sm sm:text-base">
                        Register as Vendor
                    </a>
                <?php endif; ?>
                <div class="mt-3 sm:mt-4">
                    <a href="<?php echo e(route('login')); ?>" class="text-primary hover:underline text-sm sm:text-base">
                        Back to Login
                    </a>
                </div>
            </div>
        <?php else: ?>
        <form method="POST" action="<?php echo e(route('register')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Full Name</label>
                <input type="text" name="name" value="<?php echo e(old('name')); ?>" required
                    class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Email</label>
                <input type="email" name="email" value="<?php echo e(old('email')); ?>" required
                    class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Phone Number</label>
                <input type="tel" name="phone" value="<?php echo e(old('phone')); ?>" 
                    placeholder="+234..." required
                    class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Password</label>
                <div class="relative">
                    <input type="password" id="password" name="password" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 pr-10 sm:pr-12 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <button type="button" onclick="togglePassword('password', 'toggleIcon1')" 
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700 p-1">
                        <i id="toggleIcon1" class="fas fa-eye text-sm sm:text-base"></i>
                    </button>
                </div>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Confirm Password</label>
                <div class="relative">
                    <input type="password" id="password_confirmation" name="password_confirmation" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 pr-10 sm:pr-12 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    <button type="button" onclick="togglePassword('password_confirmation', 'toggleIcon2')" 
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700 p-1">
                        <i id="toggleIcon2" class="fas fa-eye text-sm sm:text-base"></i>
                    </button>
                </div>
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="flex items-start">
                    <input type="checkbox" name="terms" required class="mr-2 mt-1 flex-shrink-0">
                    <span class="text-xs sm:text-sm">I agree to the 
                        <a href="<?php echo e(route('terms')); ?>" class="text-primary hover:underline" target="_blank">
                            Terms & Conditions
                        </a>
                    </span>
                </label>
            </div>

            <!-- CAPTCHA -->
            <div class="mb-4 sm:mb-6">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Security Verification</label>
                <div class="bg-gray-50 border-2 border-gray-200 rounded-lg p-3 sm:p-4">
                    <div class="flex flex-col sm:flex-row items-center gap-3 sm:gap-4 mb-3">
                        <img id="captcha-image" src="" alt="CAPTCHA" class="border-2 border-gray-300 rounded w-full sm:w-auto max-w-[200px]">
                        <button type="button" onclick="refreshCaptcha()" 
                            class="w-full sm:w-auto bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark transition text-sm sm:text-base whitespace-nowrap">
                            <i class="fas fa-sync-alt"></i> Refresh
                        </button>
                    </div>
                    <input type="text" name="captcha" required placeholder="Enter the code above"
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <button type="submit" 
                class="w-full bg-primary text-white py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-sm sm:text-base">
                Register
            </button>
        </form>

        <div class="mt-4 sm:mt-6 text-center">
            <p class="text-gray-600 text-sm sm:text-base">Already have an account?</p>
            <a href="<?php echo e(route('login')); ?>" class="text-primary hover:underline text-sm sm:text-base">
                Login here
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function togglePassword(inputId, iconId) {
    const input = document.getElementById(inputId);
    const icon = document.getElementById(iconId);
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// CAPTCHA Functions
function refreshCaptcha() {
    fetch('<?php echo e(route('captcha.generate')); ?>')
        .then(response => response.json())
        .then(data => {
            document.getElementById('captcha-image').src = data.image;
        })
        .catch(error => console.error('Error loading CAPTCHA:', error));
}

// Load CAPTCHA on page load
document.addEventListener('DOMContentLoaded', function() {
    refreshCaptcha();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/auth/register.blade.php ENDPATH**/ ?>