<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-4 md:py-8">
    <div class="max-w-6xl mx-auto">
        <!-- Header -->
        <div class="mb-6 md:mb-8">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-2xl md:text-3xl font-bold text-secondary mb-1 md:mb-2">My Transactions</h1>
                    <p class="text-sm md:text-base text-gray-600">View all your bookings and refunds</p>
                </div>
                <a href="<?php echo e(route('bookings.index')); ?>" class="bg-gray-600 text-white px-4 md:px-6 py-2 md:py-3 rounded-lg hover:bg-gray-700 transition font-semibold text-sm md:text-base text-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to My Bookings
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl shadow-md p-4 md:p-6 mb-4 md:mb-6">
            <form method="GET" action="<?php echo e(route('transactions.index')); ?>">
                <select name="type" class="w-full border-gray-300 rounded-lg text-sm md:text-base" onchange="this.form.submit()">
                    <option value="all" <?php echo e($type === 'all' ? 'selected' : ''); ?>>All Transactions</option>
                    <option value="bookings" <?php echo e($type === 'bookings' ? 'selected' : ''); ?>>Bookings Only</option>
                    <option value="refunds" <?php echo e($type === 'refunds' ? 'selected' : ''); ?>>Refunds Only</option>
                </select>
            </form>
        </div>

        <!-- Transactions List -->
        <?php if($transactions->count() > 0): ?>
            <div class="space-y-3 md:space-y-4">
                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white rounded-xl shadow-md p-4 md:p-6 hover:shadow-lg transition">
                        <!-- Mobile Layout -->
                        <div class="flex flex-col gap-3">
                            <!-- Badges Row -->
                            <div class="flex flex-wrap items-center gap-2">
                                <?php if($transaction['type'] === 'booking'): ?>
                                    <span class="px-2 md:px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-shopping-cart mr-1"></i>Booking
                                    </span>
                                <?php else: ?>
                                    <span class="px-2 md:px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-money-bill-wave mr-1"></i>Refund
                                    </span>
                                <?php endif; ?>
                                
                                <?php if($transaction['service'] === 'property'): ?>
                                    <span class="px-2 md:px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-home mr-1"></i>Property
                                    </span>
                                <?php else: ?>
                                    <span class="px-2 md:px-3 py-1 bg-orange-100 text-orange-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-car mr-1"></i>Car
                                    </span>
                                <?php endif; ?>

                                <span class="px-2 md:px-3 py-1 
                                    <?php if($transaction['status'] === 'paid'): ?> bg-green-100 text-green-800
                                    <?php elseif($transaction['status'] === 'requested'): ?> bg-blue-100 text-blue-800
                                    <?php elseif($transaction['status'] === 'processing'): ?> bg-yellow-100 text-yellow-800
                                    <?php else: ?> bg-gray-100 text-gray-800
                                    <?php endif; ?> rounded-full text-xs font-semibold">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $transaction['status']))); ?>

                                </span>
                            </div>

                            <!-- Title and Reference -->
                            <div>
                                <h3 class="font-bold text-base md:text-lg text-gray-800 mb-1"><?php echo e($transaction['description']); ?></h3>
                                <p class="text-xs md:text-sm text-gray-600">Reference: #<?php echo e($transaction['reference']); ?></p>
                            </div>

                            <!-- Details -->
                            <?php if($transaction['type'] === 'booking'): ?>
                                <div class="text-xs md:text-sm text-gray-600">
                                    <?php if(isset($transaction['details']['check_in'])): ?>
                                        <p class="flex items-start gap-2">
                                            <i class="fas fa-calendar mt-0.5 flex-shrink-0"></i>
                                            <span><?php echo e($transaction['details']['check_in']->format('M d, Y')); ?> - <?php echo e($transaction['details']['check_out']->format('M d, Y')); ?> (<?php echo e($transaction['details']['nights']); ?> nights)</span>
                                        </p>
                                    <?php elseif(isset($transaction['details']['pickup_date'])): ?>
                                        <p class="flex items-start gap-2">
                                            <i class="fas fa-calendar mt-0.5 flex-shrink-0"></i>
                                            <span><?php echo e($transaction['details']['pickup_date']->format('M d, Y')); ?> - <?php echo e($transaction['details']['return_date']->format('M d, Y')); ?> (<?php echo e($transaction['details']['days']); ?> days)</span>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="text-xs md:text-sm">
                                    <?php if(isset($transaction['details']['payout_status'])): ?>
                                        <span class="
                                            <?php if($transaction['details']['payout_status'] === 'paid'): ?> text-green-600
                                            <?php elseif($transaction['details']['payout_status'] === 'requested'): ?> text-blue-600
                                            <?php elseif($transaction['details']['payout_status'] === 'processing'): ?> text-yellow-600
                                            <?php else: ?> text-gray-600
                                            <?php endif; ?> font-semibold">
                                            <i class="fas fa-circle text-xs mr-1"></i><?php echo e(ucfirst(str_replace('_', ' ', $transaction['details']['payout_status']))); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <!-- Amount and Date Row -->
                            <div class="flex items-center justify-between pt-2 border-t border-gray-100">
                                <div>
                                    <p class="font-bold text-xl md:text-2xl 
                                        <?php if($transaction['type'] === 'booking'): ?> text-red-600
                                        <?php else: ?> text-green-600
                                        <?php endif; ?>">
                                        <?php if($transaction['type'] === 'booking'): ?>-<?php else: ?>+<?php endif; ?>₦<?php echo e(number_format($transaction['amount'])); ?>

                                    </p>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <?php echo e($transaction['date'] ? $transaction['date']->format('M d, Y') : 'N/A'); ?>

                                    </p>
                                </div>
                                
                                <?php if($transaction['type'] === 'booking' && $transaction['status'] === 'paid' && $transaction['service'] === 'property'): ?>
                                    <a href="<?php echo e(route('bookings.receipt', $transaction['id'])); ?>" 
                                       target="_blank"
                                       class="px-3 md:px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition text-xs font-semibold whitespace-nowrap">
                                        <i class="fas fa-file-invoice mr-1"></i><span class="hidden sm:inline">View </span>Receipt
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="bg-white rounded-xl shadow-md p-8 md:p-12 text-center">
                <i class="fas fa-receipt text-4xl md:text-6xl text-gray-300 mb-3 md:mb-4"></i>
                <h3 class="text-lg md:text-xl font-bold text-gray-700 mb-2">No Transactions Found</h3>
                <p class="text-sm md:text-base text-gray-600">You don't have any transactions yet.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/user/transactions/index.blade.php ENDPATH**/ ?>