<?php $__env->startSection('title', 'Rent a Car'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white py-8 sm:py-12 md:py-16">
        <div class="container mx-auto px-3 sm:px-4">
            <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-2 sm:mb-4">
                <i class="fas fa-car mr-2 sm:mr-3"></i>Rent a Car
            </h1>
            <p class="text-base sm:text-lg md:text-xl text-primary-light">Find the perfect vehicle for your journey</p>
        </div>
    </div>

    <div class="container mx-auto px-3 sm:px-4 py-4 sm:py-8">
        <div class="flex flex-col lg:flex-row gap-4 sm:gap-6 lg:gap-8">
            <!-- Filters Sidebar -->
            <div class="lg:w-1/4">
                <!-- Mobile Filter Toggle Button -->
                <button onclick="toggleFilters()" class="lg:hidden w-full bg-white rounded-lg shadow-md p-4 mb-4 flex items-center justify-between font-semibold">
                    <span><i class="fas fa-filter text-primary mr-2"></i>Filters</span>
                    <i class="fas fa-chevron-down" id="filter-chevron"></i>
                </button>

                <div id="filters-panel" class="hidden lg:block bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 lg:sticky lg:top-4">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-4 sm:mb-6 flex items-center">
                        <i class="fas fa-filter text-primary mr-2"></i>Filters
                    </h2>

                    <form method="GET" action="<?php echo e(route('cars.index')); ?>" id="filter-form">
                        <!-- Category -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2 sm:mb-3">Category</label>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <label class="flex items-center cursor-pointer p-2 hover:bg-gray-50 rounded">
                                        <input type="radio" name="category" value="<?php echo e($category->id); ?>" 
                                            <?php echo e(request('category') == $category->id ? 'checked' : ''); ?>

                                            class="w-4 h-4 text-primary flex-shrink-0" onchange="this.form.submit()">
                                        <span class="ml-2 text-xs sm:text-sm text-gray-700">
                                            <i class="fas <?php echo e($category->icon); ?> mr-1"></i><?php echo e($category->name); ?>

                                        </span>
                                    </label>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if(request('category')): ?>
                                    <button type="button" onclick="clearFilter('category')" 
                                        class="text-xs text-red-600 hover:text-red-800 ml-6">
                                        <i class="fas fa-times mr-1"></i>Clear
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Location -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">State</label>
                            <select name="state" class="w-full border-2 border-gray-300 rounded-lg px-3 py-2 text-xs sm:text-sm" onchange="this.form.submit()">
                                <option value="">All States</option>
                                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($state); ?>" <?php echo e(request('state') == $state ? 'selected' : ''); ?>>
                                        <?php echo e($state); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">City</label>
                            <input type="text" name="city" value="<?php echo e(request('city')); ?>" 
                                placeholder="Enter city"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 py-2 text-xs sm:text-sm">
                        </div>

                        <!-- Price Range -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Price Per Day (₦)</label>
                            <div class="grid grid-cols-2 gap-2">
                                <input type="number" name="min_price" value="<?php echo e(request('min_price')); ?>" 
                                    placeholder="Min" class="border-2 border-gray-300 rounded-lg px-3 py-2 text-xs sm:text-sm">
                                <input type="number" name="max_price" value="<?php echo e(request('max_price')); ?>" 
                                    placeholder="Max" class="border-2 border-gray-300 rounded-lg px-3 py-2 text-xs sm:text-sm">
                            </div>
                        </div>

                        <!-- Transmission -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2 sm:mb-3">Transmission</label>
                            <div class="space-y-2">
                                <label class="flex items-center cursor-pointer">
                                    <input type="radio" name="transmission" value="automatic" 
                                        <?php echo e(request('transmission') == 'automatic' ? 'checked' : ''); ?>

                                        class="w-4 h-4 text-primary flex-shrink-0" onchange="this.form.submit()">
                                    <span class="ml-2 text-xs sm:text-sm text-gray-700">Automatic</span>
                                </label>
                                <label class="flex items-center cursor-pointer">
                                    <input type="radio" name="transmission" value="manual" 
                                        <?php echo e(request('transmission') == 'manual' ? 'checked' : ''); ?>

                                        class="w-4 h-4 text-primary flex-shrink-0" onchange="this.form.submit()">
                                    <span class="ml-2 text-xs sm:text-sm text-gray-700">Manual</span>
                                </label>
                            </div>
                        </div>

                        <!-- Fuel Type -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2 sm:mb-3">Fuel Type</label>
                            <div class="space-y-2">
                                <?php $__currentLoopData = ['petrol' => 'Petrol', 'diesel' => 'Diesel', 'electric' => 'Electric', 'hybrid' => 'Hybrid']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <label class="flex items-center cursor-pointer">
                                        <input type="radio" name="fuel_type" value="<?php echo e($value); ?>" 
                                            <?php echo e(request('fuel_type') == $value ? 'checked' : ''); ?>

                                            class="w-4 h-4 text-primary flex-shrink-0" onchange="this.form.submit()">
                                        <span class="ml-2 text-xs sm:text-sm text-gray-700"><?php echo e($label); ?></span>
                                    </label>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <!-- Seats -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Minimum Seats</label>
                            <select name="seats" class="w-full border-2 border-gray-300 rounded-lg px-3 py-2 text-xs sm:text-sm" onchange="this.form.submit()">
                                <option value="">Any</option>
                                <?php for($i = 2; $i <= 8; $i++): ?>
                                    <option value="<?php echo e($i); ?>" <?php echo e(request('seats') == $i ? 'selected' : ''); ?>>
                                        <?php echo e($i); ?>+ Seats
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>

                        <div class="flex gap-2">
                            <button type="submit" class="flex-1 bg-primary text-white px-3 sm:px-4 py-2 rounded-lg hover:bg-primary-dark transition text-xs sm:text-sm font-semibold">
                                <i class="fas fa-search mr-2"></i>Apply
                            </button>
                            <a href="<?php echo e(route('cars.index')); ?>" class="flex-1 bg-gray-200 text-gray-700 px-3 sm:px-4 py-2 rounded-lg hover:bg-gray-300 transition text-xs sm:text-sm font-semibold text-center">
                                <i class="fas fa-redo mr-2"></i>Reset
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Cars Grid -->
            <div class="lg:w-3/4">
                <!-- Sort & Results Count -->
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-3 sm:p-4 mb-4 sm:mb-6 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                    <p class="text-gray-700 font-semibold text-sm sm:text-base">
                        <i class="fas fa-car text-primary mr-2"></i>
                        <?php echo e($cars->total()); ?> <?php echo e(Str::plural('car', $cars->total())); ?> available
                    </p>
                    <form method="GET" action="<?php echo e(route('cars.index')); ?>" class="flex items-center gap-2 w-full sm:w-auto">
                        <?php $__currentLoopData = request()->except('sort'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <label class="text-xs sm:text-sm text-gray-600">Sort:</label>
                        <select name="sort" onchange="this.form.submit()" 
                            class="flex-1 sm:flex-initial border-2 border-gray-300 rounded-lg px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm">
                            <option value="latest" <?php echo e(request('sort') == 'latest' ? 'selected' : ''); ?>>Latest</option>
                            <option value="price_low" <?php echo e(request('sort') == 'price_low' ? 'selected' : ''); ?>>Price: Low to High</option>
                            <option value="price_high" <?php echo e(request('sort') == 'price_high' ? 'selected' : ''); ?>>Price: High to Low</option>
                            <option value="popular" <?php echo e(request('sort') == 'popular' ? 'selected' : ''); ?>>Most Popular</option>
                            <option value="rating" <?php echo e(request('sort') == 'rating' ? 'selected' : ''); ?>>Highest Rated</option>
                        </select>
                    </form>
                </div>

                <!-- Cars Grid -->
                <?php if($cars->count() > 0): ?>
                    <div class="grid sm:grid-cols-2 xl:grid-cols-3 gap-4 sm:gap-6">
                        <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition transform hover:-translate-y-1">
                                <!-- Car Image -->
                                <div class="relative h-40 sm:h-48 bg-gray-200">
                                    <?php if($car->main_photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $car->main_photo)); ?>" 
                                            alt="<?php echo e($car->full_name); ?>"
                                            class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <div class="w-full h-full flex items-center justify-center">
                                            <i class="fas fa-car text-gray-400 text-4xl sm:text-6xl"></i>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <!-- Category Badge -->
                                    <div class="absolute top-2 sm:top-3 left-2 sm:left-3 bg-white/90 backdrop-blur-sm px-2 sm:px-3 py-1 rounded-full text-xs font-semibold text-gray-800">
                                        <i class="fas <?php echo e($car->category->icon); ?> mr-1"></i><?php echo e($car->category->name); ?>

                                    </div>

                                    <!-- Rating Badge -->
                                    <?php if($car->average_rating > 0): ?>
                                        <div class="absolute top-2 sm:top-3 right-2 sm:right-3 bg-yellow-500 text-white px-2 sm:px-3 py-1 rounded-full text-xs font-bold">
                                            <i class="fas fa-star mr-1"></i><?php echo e(number_format($car->average_rating, 1)); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Car Details -->
                                <div class="p-3 sm:p-5">
                                    <h3 class="text-base sm:text-lg md:text-xl font-bold text-gray-800 mb-2"><?php echo e($car->full_name); ?></h3>
                                    
                                    <!-- Location -->
                                    <p class="text-xs sm:text-sm text-gray-600 mb-2 sm:mb-3">
                                        <i class="fas fa-map-marker-alt text-primary mr-1"></i>
                                        <?php echo e($car->city); ?>, <?php echo e($car->state); ?>

                                    </p>

                                    <!-- Specs -->
                                    <div class="grid grid-cols-3 gap-1 sm:gap-2 mb-3 sm:mb-4 text-xs text-gray-600">
                                        <div class="flex items-center">
                                            <i class="fas fa-users text-primary mr-1 text-xs"></i>
                                            <span class="text-xs"><?php echo e($car->seats); ?></span>
                                        </div>
                                        <div class="flex items-center">
                                            <i class="fas fa-cog text-primary mr-1 text-xs"></i>
                                            <span class="text-xs"><?php echo e(ucfirst($car->transmission)); ?></span>
                                        </div>
                                        <div class="flex items-center">
                                            <i class="fas fa-gas-pump text-primary mr-1 text-xs"></i>
                                            <span class="text-xs"><?php echo e(ucfirst($car->fuel_type)); ?></span>
                                        </div>
                                    </div>

                                    <!-- Price & CTA -->
                                    <div class="flex items-center justify-between pt-3 sm:pt-4 border-t border-gray-200">
                                        <div>
                                            <p class="text-lg sm:text-xl md:text-2xl font-bold text-primary">₦<?php echo e(number_format($car->price_per_day)); ?></p>
                                            <p class="text-xs text-gray-500">per day</p>
                                        </div>
                                        <a href="<?php echo e(route('cars.show', $car)); ?>" 
                                            class="bg-gradient-to-r from-primary to-primary-dark text-white px-3 sm:px-4 md:px-6 py-2 sm:py-2.5 md:py-3 rounded-lg hover:shadow-lg transition font-semibold text-xs sm:text-sm">
                                            View Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-6 sm:mt-8">
                        <?php echo e($cars->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-8 sm:p-12 text-center">
                        <div class="bg-gray-100 w-20 h-20 sm:w-24 sm:h-24 rounded-full flex items-center justify-center mx-auto mb-4 sm:mb-6">
                            <i class="fas fa-car text-gray-400 text-3xl sm:text-4xl"></i>
                        </div>
                        <h3 class="text-xl sm:text-2xl font-bold text-gray-800 mb-2 sm:mb-3">No Cars Found</h3>
                        <p class="text-gray-600 mb-4 sm:mb-6 text-sm sm:text-base">Try adjusting your filters to see more results</p>
                        <a href="<?php echo e(route('cars.index')); ?>" 
                            class="inline-block bg-primary text-white px-6 sm:px-8 py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark transition font-semibold text-sm sm:text-base">
                            <i class="fas fa-redo mr-2"></i>Clear All Filters
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function clearFilter(filterName) {
    const form = document.getElementById('filter-form');
    const input = form.querySelector(`[name="${filterName}"]`);
    if (input) {
        if (input.type === 'radio') {
            form.querySelectorAll(`[name="${filterName}"]`).forEach(radio => radio.checked = false);
        } else {
            input.value = '';
        }
        form.submit();
    }
}

function toggleFilters() {
    const panel = document.getElementById('filters-panel');
    const chevron = document.getElementById('filter-chevron');
    panel.classList.toggle('hidden');
    chevron.classList.toggle('fa-chevron-down');
    chevron.classList.toggle('fa-chevron-up');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/cars/index.blade.php ENDPATH**/ ?>