<?php $__env->startSection('title', 'Add Popular Destination'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-4 py-8 max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center mb-4">
            <a href="<?php echo e(route('admin.destinations.index')); ?>" 
                class="text-gray-600 hover:text-gray-800 mr-4">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h1 class="text-3xl font-bold text-gray-800">
                <i class="fas fa-map-marked-alt text-purple-600 mr-3"></i>Add Popular Destination
            </h1>
        </div>
        <p class="text-gray-600">Create a new featured destination for the homepage</p>
    </div>

    <!-- Form -->
    <form method="POST" action="<?php echo e(route('admin.destinations.store')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="bg-white rounded-xl shadow-lg p-8">
            <!-- Type Selection -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-3">
                    <i class="fas fa-tag text-purple-600 mr-2"></i>Destination Type *
                </label>
                <div class="grid grid-cols-2 gap-4">
                    <label class="relative cursor-pointer">
                        <input type="radio" name="type" value="state" 
                            <?php echo e(old('type') === 'state' ? 'checked' : ''); ?>

                            class="peer sr-only" required
                            onchange="toggleStateField()">
                        <div class="border-2 rounded-lg p-4 peer-checked:border-purple-600 peer-checked:bg-purple-50 transition">
                            <div class="flex items-center justify-center mb-2">
                                <i class="fas fa-flag text-3xl text-purple-600"></i>
                            </div>
                            <div class="text-center font-semibold">State</div>
                            <div class="text-center text-sm text-gray-600">Entire state</div>
                        </div>
                    </label>
                    <label class="relative cursor-pointer">
                        <input type="radio" name="type" value="city" 
                            <?php echo e(old('type') === 'city' ? 'checked' : ''); ?>

                            class="peer sr-only" required
                            onchange="toggleStateField()">
                        <div class="border-2 rounded-lg p-4 peer-checked:border-purple-600 peer-checked:bg-purple-50 transition">
                            <div class="flex items-center justify-center mb-2">
                                <i class="fas fa-city text-3xl text-purple-600"></i>
                            </div>
                            <div class="text-center font-semibold">City</div>
                            <div class="text-center text-sm text-gray-600">Specific city</div>
                        </div>
                    </label>
                </div>
                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Name -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-map-marker-alt text-purple-600 mr-2"></i>
                    <span id="nameLabel">Name</span> *
                </label>
                <input type="text" 
                    name="name" 
                    value="<?php echo e(old('name')); ?>" 
                    placeholder="e.g., Lagos, Abuja, Port Harcourt"
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-purple-600 focus:outline-none transition <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                    required>
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- State (for cities only) -->
            <div class="mb-6" id="stateField" style="display: none;">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-flag text-purple-600 mr-2"></i>State *
                </label>
                <select name="state" 
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-purple-600 focus:outline-none transition <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">Select State</option>
                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($state); ?>" <?php echo e(old('state') === $state ? 'selected' : ''); ?>>
                            <?php echo e($state); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Image Upload -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-image text-purple-600 mr-2"></i>Destination Image *
                </label>
                <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-purple-600 transition">
                    <input type="file" 
                        name="image" 
                        id="imageInput"
                        accept="image/*"
                        class="hidden"
                        onchange="previewImage(event)"
                        required>
                    <label for="imageInput" class="cursor-pointer">
                        <div id="imagePreview" class="mb-4">
                            <i class="fas fa-cloud-upload-alt text-6xl text-gray-400"></i>
                        </div>
                        <p class="text-gray-600 mb-2">Click to upload destination image</p>
                        <p class="text-sm text-gray-500">Recommended: 1200x800px, Max 5MB (JPG, PNG, WebP)</p>
                    </label>
                </div>
                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Description -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-align-left text-purple-600 mr-2"></i>Description (Optional)
                </label>
                <textarea name="description" 
                    rows="3" 
                    maxlength="500"
                    placeholder="Brief description of the destination..."
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-purple-600 focus:outline-none transition <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('description')); ?></textarea>
                <p class="text-sm text-gray-500 mt-1">Maximum 500 characters</p>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Display Order -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-sort-numeric-down text-purple-600 mr-2"></i>Display Order
                </label>
                <input type="number" 
                    name="display_order" 
                    value="<?php echo e(old('display_order', 0)); ?>" 
                    min="0"
                    placeholder="0"
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-purple-600 focus:outline-none transition <?php $__errorArgs = ['display_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <p class="text-sm text-gray-500 mt-1">Lower numbers appear first (0 = highest priority)</p>
                <?php $__errorArgs = ['display_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Active Status -->
            <div class="mb-6">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" 
                        name="active" 
                        value="1"
                        <?php echo e(old('active', true) ? 'checked' : ''); ?>

                        class="w-5 h-5 text-purple-600 border-gray-300 rounded focus:ring-purple-500">
                    <span class="ml-3 text-gray-700 font-semibold">
                        <i class="fas fa-eye text-purple-600 mr-2"></i>Show on Homepage
                    </span>
                </label>
            </div>

            <!-- Submit Buttons -->
            <div class="flex items-center justify-end space-x-4 pt-6 border-t">
                <a href="<?php echo e(route('admin.destinations.index')); ?>" 
                    class="px-6 py-3 border-2 border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 font-semibold transition">
                    Cancel
                </a>
                <button type="submit" 
                    class="px-8 py-3 bg-gradient-to-r from-purple-600 to-purple-800 text-white rounded-lg hover:shadow-lg font-semibold transition transform hover:scale-105">
                    <i class="fas fa-save mr-2"></i>Create Destination
                </button>
            </div>
        </div>
    </form>
</div>

<script>
function toggleStateField() {
    const type = document.querySelector('input[name="type"]:checked')?.value;
    const stateField = document.getElementById('stateField');
    const stateInput = document.querySelector('select[name="state"]');
    const nameLabel = document.getElementById('nameLabel');
    
    if (type === 'city') {
        stateField.style.display = 'block';
        stateInput.required = true;
        nameLabel.textContent = 'City Name';
    } else {
        stateField.style.display = 'none';
        stateInput.required = false;
        stateInput.value = '';
        nameLabel.textContent = 'State Name';
    }
}

function previewImage(event) {
    const preview = document.getElementById('imagePreview');
    const file = event.target.files[0];
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.innerHTML = `<img src="${e.target.result}" class="max-w-full h-64 object-cover rounded-lg mx-auto">`;
        }
        reader.readAsDataURL(file);
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleStateField();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/destinations/create.blade.php ENDPATH**/ ?>