<!-- Specifications Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-cogs mr-3"></i>Specifications
        </h2>
    </div>
    <div class="p-6">
        <div class="grid md:grid-cols-3 gap-6">
            <!-- Transmission -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-cog text-blue-600 mr-2"></i>Transmission *
                </label>
                <select name="transmission" required
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition <?php $__errorArgs = ['transmission'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">Select</option>
                    <option value="automatic" <?php echo e(old('transmission', $car->transmission ?? '') == 'automatic' ? 'selected' : ''); ?>>Automatic</option>
                    <option value="manual" <?php echo e(old('transmission', $car->transmission ?? '') == 'manual' ? 'selected' : ''); ?>>Manual</option>
                </select>
                <?php $__errorArgs = ['transmission'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Fuel Type -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-gas-pump text-blue-600 mr-2"></i>Fuel Type *
                </label>
                <select name="fuel_type" required
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition <?php $__errorArgs = ['fuel_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <option value="">Select</option>
                    <option value="petrol" <?php echo e(old('fuel_type', $car->fuel_type ?? '') == 'petrol' ? 'selected' : ''); ?>>Petrol</option>
                    <option value="diesel" <?php echo e(old('fuel_type', $car->fuel_type ?? '') == 'diesel' ? 'selected' : ''); ?>>Diesel</option>
                    <option value="electric" <?php echo e(old('fuel_type', $car->fuel_type ?? '') == 'electric' ? 'selected' : ''); ?>>Electric</option>
                    <option value="hybrid" <?php echo e(old('fuel_type', $car->fuel_type ?? '') == 'hybrid' ? 'selected' : ''); ?>>Hybrid</option>
                </select>
                <?php $__errorArgs = ['fuel_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Seats -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-users text-blue-600 mr-2"></i>Seats *
                </label>
                <input type="number" name="seats" value="<?php echo e(old('seats', $car->seats ?? 5)); ?>" required
                    min="1" max="50"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition <?php $__errorArgs = ['seats'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['seats'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Doors -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-door-open text-blue-600 mr-2"></i>Doors *
                </label>
                <input type="number" name="doors" value="<?php echo e(old('doors', $car->doors ?? 4)); ?>" required
                    min="2" max="10"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition <?php $__errorArgs = ['doors'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['doors'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Luggage Capacity -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-suitcase text-blue-600 mr-2"></i>Luggage Capacity *
                </label>
                <input type="number" name="luggage_capacity" value="<?php echo e(old('luggage_capacity', $car->luggage_capacity ?? 2)); ?>" required
                    min="0" max="20" placeholder="Number of large bags"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition <?php $__errorArgs = ['luggage_capacity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['luggage_capacity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Air Conditioning -->
            <div class="flex items-center pt-8">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="air_conditioning" value="1" 
                        <?php echo e(old('air_conditioning', $car->air_conditioning ?? true) ? 'checked' : ''); ?>

                        class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                    <span class="ml-3 text-sm font-semibold text-gray-700">
                        <i class="fas fa-snowflake text-blue-600 mr-2"></i>Air Conditioning
                    </span>
                </label>
            </div>
        </div>

        <!-- Features -->
        <div class="mt-6">
            <label class="block text-sm font-semibold text-gray-700 mb-3">
                <i class="fas fa-star text-blue-600 mr-2"></i>Additional Features
            </label>
            <div class="grid md:grid-cols-4 gap-4">
                <?php
                    $features = ['GPS Navigation', 'Bluetooth', 'USB Port', 'Backup Camera', 'Parking Sensors', 'Sunroof', 'Leather Seats', 'Heated Seats', 'Cruise Control', 'Keyless Entry', 'Child Seat Available', 'Aux Input'];
                    $selectedFeatures = old('features', $car->features ?? []);
                ?>
                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="flex items-center cursor-pointer p-3 bg-gray-50 rounded-lg hover:bg-blue-50 transition">
                        <input type="checkbox" name="features[]" value="<?php echo e($feature); ?>" 
                            <?php echo e(in_array($feature, $selectedFeatures) ? 'checked' : ''); ?>

                            class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <span class="ml-2 text-sm text-gray-700"><?php echo e($feature); ?></span>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/cars/_form_specs.blade.php ENDPATH**/ ?>