<?php $__env->startSection('title', 'Browse Properties - ShortStayNG'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .filter-card {
        transition: all 0.3s ease;
    }
    .filter-card:hover {
        transform: translateY(-2px);
    }
    .property-card {
        transition: all 0.3s ease;
    }
    .property-card:hover {
        transform: translateY(-8px);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Header -->
<div class="bg-gradient-to-r from-primary to-primary text-white py-8 sm:py-12 -mx-4 mb-6 sm:mb-8 rounded-xl sm:rounded-2xl">
    <div class="container mx-auto px-4">
        <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-extrabold mb-2 sm:mb-3">Explore Our Properties</h1>
        <p class="text-sm sm:text-base md:text-lg lg:text-xl opacity-90">Find your perfect stay from <?php echo e($properties->total()); ?> amazing properties</p>
    </div>
</div>

<!-- Advanced Filters -->
<div class="mb-6 sm:mb-8">
    <form method="GET" class="filter-card bg-white p-4 sm:p-6 md:p-8 rounded-xl sm:rounded-2xl shadow-xl border border-gray-100">
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4 md:gap-6 mb-4 sm:mb-6">
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-map-marker-alt text-primary mr-1 sm:mr-2"></i>State
                </label>
                <select name="state" class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
                    <option value="">All States</option>
                    <option value="Lagos" <?php echo e(request('state') === 'Lagos' ? 'selected' : ''); ?>>Lagos</option>
                    <option value="Abuja" <?php echo e(request('state') === 'Abuja' ? 'selected' : ''); ?>>Abuja (FCT)</option>
                    <option value="Rivers" <?php echo e(request('state') === 'Rivers' ? 'selected' : ''); ?>>Rivers</option>
                    <option value="Oyo" <?php echo e(request('state') === 'Oyo' ? 'selected' : ''); ?>>Oyo</option>
                    <option value="Kano" <?php echo e(request('state') === 'Kano' ? 'selected' : ''); ?>>Kano</option>
                    <option value="Kaduna" <?php echo e(request('state') === 'Kaduna' ? 'selected' : ''); ?>>Kaduna</option>
                    <option value="Ogun" <?php echo e(request('state') === 'Ogun' ? 'selected' : ''); ?>>Ogun</option>
                    <option value="Enugu" <?php echo e(request('state') === 'Enugu' ? 'selected' : ''); ?>>Enugu</option>
                    <option value="Delta" <?php echo e(request('state') === 'Delta' ? 'selected' : ''); ?>>Delta</option>
                    <option value="Edo" <?php echo e(request('state') === 'Edo' ? 'selected' : ''); ?>>Edo</option>
                    <option value="Anambra" <?php echo e(request('state') === 'Anambra' ? 'selected' : ''); ?>>Anambra</option>
                    <option value="Akwa Ibom" <?php echo e(request('state') === 'Akwa Ibom' ? 'selected' : ''); ?>>Akwa Ibom</option>
                    <option value="Cross River" <?php echo e(request('state') === 'Cross River' ? 'selected' : ''); ?>>Cross River</option>
                    <option value="Imo" <?php echo e(request('state') === 'Imo' ? 'selected' : ''); ?>>Imo</option>
                    <option value="Abia" <?php echo e(request('state') === 'Abia' ? 'selected' : ''); ?>>Abia</option>
                    <option value="Ondo" <?php echo e(request('state') === 'Ondo' ? 'selected' : ''); ?>>Ondo</option>
                    <option value="Osun" <?php echo e(request('state') === 'Osun' ? 'selected' : ''); ?>>Osun</option>
                    <option value="Ekiti" <?php echo e(request('state') === 'Ekiti' ? 'selected' : ''); ?>>Ekiti</option>
                    <option value="Kwara" <?php echo e(request('state') === 'Kwara' ? 'selected' : ''); ?>>Kwara</option>
                    <option value="Plateau" <?php echo e(request('state') === 'Plateau' ? 'selected' : ''); ?>>Plateau</option>
                    <option value="Benue" <?php echo e(request('state') === 'Benue' ? 'selected' : ''); ?>>Benue</option>
                    <option value="Niger" <?php echo e(request('state') === 'Niger' ? 'selected' : ''); ?>>Niger</option>
                    <option value="Kogi" <?php echo e(request('state') === 'Kogi' ? 'selected' : ''); ?>>Kogi</option>
                    <option value="Bauchi" <?php echo e(request('state') === 'Bauchi' ? 'selected' : ''); ?>>Bauchi</option>
                    <option value="Borno" <?php echo e(request('state') === 'Borno' ? 'selected' : ''); ?>>Borno</option>
                    <option value="Adamawa" <?php echo e(request('state') === 'Adamawa' ? 'selected' : ''); ?>>Adamawa</option>
                    <option value="Gombe" <?php echo e(request('state') === 'Gombe' ? 'selected' : ''); ?>>Gombe</option>
                    <option value="Taraba" <?php echo e(request('state') === 'Taraba' ? 'selected' : ''); ?>>Taraba</option>
                    <option value="Yobe" <?php echo e(request('state') === 'Yobe' ? 'selected' : ''); ?>>Yobe</option>
                    <option value="Jigawa" <?php echo e(request('state') === 'Jigawa' ? 'selected' : ''); ?>>Jigawa</option>
                    <option value="Katsina" <?php echo e(request('state') === 'Katsina' ? 'selected' : ''); ?>>Katsina</option>
                    <option value="Sokoto" <?php echo e(request('state') === 'Sokoto' ? 'selected' : ''); ?>>Sokoto</option>
                    <option value="Kebbi" <?php echo e(request('state') === 'Kebbi' ? 'selected' : ''); ?>>Kebbi</option>
                    <option value="Zamfara" <?php echo e(request('state') === 'Zamfara' ? 'selected' : ''); ?>>Zamfara</option>
                    <option value="Bayelsa" <?php echo e(request('state') === 'Bayelsa' ? 'selected' : ''); ?>>Bayelsa</option>
                    <option value="Ebonyi" <?php echo e(request('state') === 'Ebonyi' ? 'selected' : ''); ?>>Ebonyi</option>
                    <option value="Nasarawa" <?php echo e(request('state') === 'Nasarawa' ? 'selected' : ''); ?>>Nasarawa</option>
                </select>
            </div>
            
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-city text-primary mr-1 sm:mr-2"></i>City
                </label>
                <input type="text" name="city" placeholder="Enter city name" value="<?php echo e(request('city')); ?>" 
                    class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
            </div>
            
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-users text-primary mr-1 sm:mr-2"></i>Guests
                </label>
                <input type="number" name="guests" placeholder="Number of guests" value="<?php echo e(request('guests')); ?>" 
                    class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-bed text-primary mr-1 sm:mr-2"></i>Bedrooms
                </label>
                <select name="bedrooms" class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
                    <option value="">Any</option>
                    <option value="1" <?php echo e(request('bedrooms') == '1' ? 'selected' : ''); ?>>1+</option>
                    <option value="2" <?php echo e(request('bedrooms') == '2' ? 'selected' : ''); ?>>2+</option>
                    <option value="3" <?php echo e(request('bedrooms') == '3' ? 'selected' : ''); ?>>3+</option>
                    <option value="4" <?php echo e(request('bedrooms') == '4' ? 'selected' : ''); ?>>4+</option>
                </select>
            </div>
        </div>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4 md:gap-6">
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-money-bill-wave text-primary mr-1 sm:mr-2"></i>Min Price (₦)
                </label>
                <input type="number" name="min_price" placeholder="0" value="<?php echo e(request('min_price')); ?>" 
                    class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-money-bill-wave text-primary mr-1 sm:mr-2"></i>Max Price (₦)
                </label>
                <input type="number" name="max_price" placeholder="1,000,000" value="<?php echo e(request('max_price')); ?>" 
                    class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-filter text-primary mr-1 sm:mr-2"></i>Property Type
                </label>
                <select name="house_type" class="w-full border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
                    <option value="">All Types</option>
                    <option value="Apartment" <?php echo e(request('house_type') == 'Apartment' ? 'selected' : ''); ?>>Apartment</option>
                    <option value="House" <?php echo e(request('house_type') == 'House' ? 'selected' : ''); ?>>House</option>
                    <option value="Villa" <?php echo e(request('house_type') == 'Villa' ? 'selected' : ''); ?>>Villa</option>
                    <option value="Studio" <?php echo e(request('house_type') == 'Studio' ? 'selected' : ''); ?>>Studio</option>
                </select>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2 sm:invisible">&nbsp;</label>
                <button type="submit" class="w-full bg-gradient-to-r from-primary to-primary text-white rounded-lg px-4 sm:px-6 py-2 sm:py-3 text-sm sm:text-base hover:from-primary-dark hover:to-primary-dark font-bold shadow-lg transform hover:scale-105 transition">
                    <i class="fas fa-search mr-2"></i> Search Properties
                </button>
            </div>
        </div>

        <!-- Quick Filters -->
        <div class="mt-4 sm:mt-6 pt-4 sm:pt-6 border-t border-gray-200">
            <p class="text-xs sm:text-sm font-semibold text-gray-700 mb-2 sm:mb-3">Quick Filters:</p>
            <div class="flex flex-wrap gap-2 sm:gap-3">
                <a href="<?php echo e(route('properties.index')); ?>" 
                    class="px-3 sm:px-4 py-1.5 sm:py-2 <?php echo e(!request()->hasAny(['state', 'city', 'guests', 'min_price', 'max_price']) ? 'bg-primary text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'); ?> rounded-full text-xs sm:text-sm font-semibold transition">
                    All Properties
                </a>
                <a href="<?php echo e(route('properties.index', ['allow_parties' => '1'])); ?>" 
                    class="px-3 sm:px-4 py-1.5 sm:py-2 bg-gray-100 text-gray-700 hover:bg-primary/10 hover:text-primary-dark rounded-full text-xs sm:text-sm font-semibold transition">
                    <i class="fas fa-glass-cheers mr-1"></i> Party Friendly
                </a>
                <a href="<?php echo e(route('properties.index', ['max_price' => '50000'])); ?>" 
                    class="px-3 sm:px-4 py-1.5 sm:py-2 bg-gray-100 text-gray-700 hover:bg-primary/10 hover:text-primary-dark rounded-full text-xs sm:text-sm font-semibold transition">
                    <i class="fas fa-tag mr-1"></i> Under ₦50k
                </a>
                <a href="<?php echo e(route('properties.index', ['bedrooms' => '3'])); ?>" 
                    class="px-3 sm:px-4 py-1.5 sm:py-2 bg-gray-100 text-gray-700 hover:bg-primary/10 hover:text-primary-dark rounded-full text-xs sm:text-sm font-semibold transition">
                    <i class="fas fa-home mr-1"></i> 3+ Bedrooms
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Results Header -->
<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
    <div>
        <h2 class="text-xl sm:text-2xl font-bold text-secondary"><?php echo e($properties->total()); ?> Properties Found</h2>
        <p class="text-xs sm:text-sm text-gray-600">Showing <?php echo e($properties->firstItem()); ?> - <?php echo e($properties->lastItem()); ?> of <?php echo e($properties->total()); ?> results</p>
    </div>
    <div class="w-full sm:w-auto">
        <form method="GET" class="inline w-full sm:w-auto">
            <?php $__currentLoopData = request()->except('sort'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <select name="sort" onchange="this.form.submit()" class="w-full sm:w-auto border-2 border-gray-200 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none cursor-pointer">
                <option value="featured" <?php echo e(request('sort') == 'featured' || !request('sort') ? 'selected' : ''); ?>>Sort by: Recommended</option>
                <option value="price_low" <?php echo e(request('sort') == 'price_low' ? 'selected' : ''); ?>>Price: Low to High</option>
                <option value="price_high" <?php echo e(request('sort') == 'price_high' ? 'selected' : ''); ?>>Price: High to Low</option>
                <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>>Newest First</option>
                <option value="rating" <?php echo e(request('sort') == 'rating' ? 'selected' : ''); ?>>Highest Rated</option>
            </select>
        </form>
    </div>
</div>

<!-- Properties Grid -->
<div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 sm:gap-6 md:gap-8">
    <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="property-card bg-white rounded-xl sm:rounded-2xl shadow-lg overflow-hidden">
            <div class="relative">
                <img src="<?php echo e(isset($property->photos[0]) ? asset('storage/' . $property->photos[0]) : '/images/placeholder.jpg'); ?>" 
                    alt="<?php echo e($property->title); ?>" 
                    class="w-full h-48 sm:h-56 md:h-64 object-cover">
                
                <?php if($property->isFeatured()): ?>
                    <div class="absolute top-2 sm:top-3 left-2 sm:left-3 bg-gradient-to-r from-yellow-400 to-orange-500 text-white px-2 sm:px-3 py-1 rounded-full text-xs font-bold shadow-lg">
                        <i class="fas fa-star mr-1"></i> FEATURED
                    </div>
                <?php endif; ?>

                <?php if($property->allow_parties): ?>
                    <div class="absolute top-2 sm:top-3 right-2 sm:right-3 bg-primary text-white px-2 sm:px-3 py-1 rounded-full text-xs font-bold">
                        <i class="fas fa-glass-cheers mr-1"></i> Party OK
                    </div>
                <?php endif; ?>

                <!-- Favorite Button -->
                <?php if(auth()->guard()->check()): ?>
                    <button onclick="toggleFavorite(<?php echo e($property->id); ?>, this)" 
                        class="absolute bottom-2 sm:bottom-3 right-2 sm:right-3 w-9 h-9 sm:w-10 sm:h-10 bg-white rounded-full flex items-center justify-center shadow-lg hover:scale-110 transition">
                        <i class="fas fa-heart text-sm sm:text-base <?php echo e(auth()->user()->hasFavorited($property->id) ? 'text-red-500' : 'text-gray-400'); ?>"></i>
                    </button>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" 
                        class="absolute bottom-2 sm:bottom-3 right-2 sm:right-3 w-9 h-9 sm:w-10 sm:h-10 bg-white rounded-full flex items-center justify-center shadow-lg hover:scale-110 transition">
                        <i class="fas fa-heart text-sm sm:text-base text-gray-400"></i>
                    </a>
                <?php endif; ?>
            </div>
            
            <div class="p-4 sm:p-5">
                <h3 class="font-bold text-base sm:text-lg md:text-xl mb-2 line-clamp-1"><?php echo e($property->title); ?></h3>
                <p class="text-gray-600 text-xs sm:text-sm mb-3 flex items-center">
                    <i class="fas fa-map-marker-alt mr-1 sm:mr-2 text-primary"></i>
                    <?php echo e($property->city); ?>, <?php echo e($property->state); ?>

                </p>
                
                <?php if($avgRating = $property->averageRating()): ?>
                    <div class="flex items-center mb-3">
                        <div class="flex text-yellow-500 text-xs sm:text-sm">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <i class="fas fa-star<?php echo e($i <= $avgRating ? '' : ' text-gray-300'); ?>"></i>
                            <?php endfor; ?>
                        </div>
                        <span class="ml-2 text-xs sm:text-sm text-gray-600 font-semibold"><?php echo e(number_format($avgRating, 1)); ?></span>
                        <span class="ml-1 text-xs sm:text-sm text-gray-500">(<?php echo e($property->reviews->count()); ?>)</span>
                    </div>
                <?php endif; ?>
                
                <div class="flex items-center gap-3 sm:gap-4 mb-3 sm:mb-4 text-xs sm:text-sm text-gray-600">
                    <span class="flex items-center">
                        <i class="fas fa-bed mr-1 text-primary"></i> <?php echo e($property->bedrooms); ?>

                    </span>
                    <span class="flex items-center">
                        <i class="fas fa-bath mr-1 text-primary"></i> <?php echo e($property->bathrooms); ?>

                    </span>
                    <span class="flex items-center">
                        <i class="fas fa-users mr-1 text-primary"></i> <?php echo e($property->max_guests); ?>

                    </span>
                </div>

                <!-- Amenities Preview -->
                <?php
                    $amenities = is_array($property->amenities) ? $property->amenities : (is_string($property->amenities) ? json_decode($property->amenities, true) : []);
                    
                    // Flatten nested amenities array
                    $flatAmenities = [];
                    if (is_array($amenities)) {
                        foreach ($amenities as $category => $items) {
                            if (is_array($items)) {
                                $flatAmenities = array_merge($flatAmenities, $items);
                            } else {
                                $flatAmenities[] = $items;
                            }
                        }
                    }
                ?>
                <?php if($flatAmenities && count($flatAmenities) > 0): ?>
                    <div class="flex flex-wrap gap-1.5 sm:gap-2 mb-3 sm:mb-4">
                        <?php $__currentLoopData = array_slice($flatAmenities, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $amenityName = is_string($amenity) ? $amenity : (is_array($amenity) ? ($amenity['name'] ?? '') : '');
                                $amenityLower = strtolower($amenityName);
                                
                                // Determine icon based on amenity name
                                $icon = 'fa-check-circle';
                                if (str_contains($amenityLower, 'wifi') || str_contains($amenityLower, 'wi-fi') || str_contains($amenityLower, 'internet')) {
                                    $icon = 'fa-wifi';
                                } elseif (str_contains($amenityLower, 'pool') || str_contains($amenityLower, 'swimming')) {
                                    $icon = 'fa-swimming-pool';
                                } elseif (str_contains($amenityLower, 'parking') || str_contains($amenityLower, 'garage')) {
                                    $icon = 'fa-parking';
                                } elseif (str_contains($amenityLower, 'kitchen') || str_contains($amenityLower, 'cooking')) {
                                    $icon = 'fa-utensils';
                                } elseif (str_contains($amenityLower, 'air') || str_contains($amenityLower, 'conditioning') || str_contains($amenityLower, 'a/c') || preg_match('/\bac\b/', $amenityLower)) {
                                    $icon = 'fa-snowflake';
                                } elseif (str_contains($amenityLower, 'tv') || str_contains($amenityLower, 'television') || str_contains($amenityLower, 'cable')) {
                                    $icon = 'fa-tv';
                                } elseif (str_contains($amenityLower, 'gym') || str_contains($amenityLower, 'fitness') || str_contains($amenityLower, 'exercise')) {
                                    $icon = 'fa-dumbbell';
                                } elseif (str_contains($amenityLower, 'laundry') || str_contains($amenityLower, 'washing') || str_contains($amenityLower, 'washer')) {
                                    $icon = 'fa-tshirt';
                                } elseif (str_contains($amenityLower, 'security') || str_contains($amenityLower, 'guard')) {
                                    $icon = 'fa-shield-alt';
                                } elseif (str_contains($amenityLower, 'generator') || str_contains($amenityLower, 'backup') || str_contains($amenityLower, 'power')) {
                                    $icon = 'fa-bolt';
                                }
                            ?>
                            <span class="text-xs bg-primary/5 text-primary-dark px-2 py-0.5 sm:py-1 rounded-full flex items-center gap-1">
                                <i class="fas <?php echo e($icon); ?> text-xs"></i>
                                <span class="hidden sm:inline"><?php echo e($amenityName); ?></span>
                                <span class="sm:hidden"><?php echo e(Str::limit($amenityName, 8)); ?></span>
                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(count($flatAmenities) > 3): ?>
                            <span class="text-xs bg-gray-100 text-gray-600 px-2 py-0.5 sm:py-1 rounded-full">
                                +<?php echo e(count($flatAmenities) - 3); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <div class="border-t pt-3 sm:pt-4 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
                    <div>
                        <span class="text-2xl sm:text-2xl md:text-3xl font-bold text-primary">₦<?php echo e(number_format($property->price_per_night)); ?></span>
                        <span class="text-gray-500 text-xs sm:text-sm">/night</span>
                    </div>
                    <a href="<?php echo e(route('properties.show', $property)); ?>" 
                        class="w-full sm:w-auto text-center bg-gradient-to-r from-primary to-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:from-primary-dark hover:to-primary-dark font-semibold text-xs sm:text-sm shadow-md transform hover:scale-105 transition">
                        View Details
                    </a>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-span-full text-center py-12">
            <i class="fas fa-home text-gray-300 text-5xl mb-4"></i>
            <p class="text-gray-600 text-sm sm:text-base">No properties found. Try adjusting your filters.</p>
        </div>
    <?php endif; ?>
</div>

<!-- Pagination -->
<div class="mt-6 sm:mt-8">
    <?php echo e($properties->links()); ?>

</div>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleFavorite(propertyId, button) {
    fetch(`/favorites/toggle/${propertyId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const icon = button.querySelector('i');
            if (data.favorited) {
                icon.classList.remove('text-gray-400');
                icon.classList.add('text-red-500');
            } else {
                icon.classList.remove('text-red-500');
                icon.classList.add('text-gray-400');
            }
        }
    })
    .catch(error => console.error('Error:', error));
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/properties/index.blade.php ENDPATH**/ ?>