<?php $__env->startSection('title', 'Car Booking Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <a href="<?php echo e(route('admin.car-bookings.index')); ?>" class="text-primary hover:text-primary-dark font-semibold mb-4 inline-block">
            <i class="fas fa-arrow-left mr-2"></i>Back to Car Bookings
        </a>
        <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-xl shadow-lg p-6">
            <div class="flex justify-between items-start">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-car mr-3"></i>Car Booking Details
                    </h1>
                    <p class="text-green-100">Booking Reference: <span class="font-mono font-bold"><?php echo e($booking->booking_reference); ?></span></p>
                </div>
                <span class="px-4 py-2 rounded-full text-sm font-bold
                    <?php if($booking->status === 'confirmed'): ?> bg-green-200 text-green-900
                    <?php elseif($booking->status === 'pending'): ?> bg-yellow-200 text-yellow-900
                    <?php elseif($booking->status === 'active'): ?> bg-blue-200 text-blue-900
                    <?php elseif($booking->status === 'completed'): ?> bg-gray-200 text-gray-900
                    <?php elseif($booking->status === 'cancelled'): ?> bg-red-200 text-red-900
                    <?php else: ?> bg-white text-gray-900
                    <?php endif; ?>">
                    <?php echo e(ucfirst($booking->status)); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="grid lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Car Details -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-car text-green-600 mr-2"></i>Car Details
                </h2>
                
                <div class="flex flex-col md:flex-row gap-6">
                    <?php if($booking->car->main_photo): ?>
                        <img src="<?php echo e(asset('storage/' . $booking->car->main_photo)); ?>" 
                            alt="<?php echo e($booking->car->full_name); ?>"
                            class="w-full md:w-64 h-48 object-cover rounded-lg">
                    <?php endif; ?>
                    
                    <div class="flex-1">
                        <h3 class="text-2xl font-bold text-gray-800 mb-2"><?php echo e($booking->car->full_name); ?></h3>
                        <p class="text-gray-600 mb-3"><?php echo e($booking->car->category->name); ?></p>
                        
                        <div class="grid grid-cols-2 gap-3 text-sm">
                            <div>
                                <p class="text-gray-600">Transmission</p>
                                <p class="font-semibold"><?php echo e(ucfirst($booking->car->transmission)); ?></p>
                            </div>
                            <div>
                                <p class="text-gray-600">Fuel Type</p>
                                <p class="font-semibold"><?php echo e(ucfirst($booking->car->fuel_type)); ?></p>
                            </div>
                            <div>
                                <p class="text-gray-600">Seats</p>
                                <p class="font-semibold"><?php echo e($booking->car->seats); ?> Passengers</p>
                            </div>
                            <div>
                                <p class="text-gray-600">Location</p>
                                <p class="font-semibold"><?php echo e($booking->car->city); ?>, <?php echo e($booking->car->state); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Rental Period -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-calendar text-green-600 mr-2"></i>Rental Period
                </h2>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="bg-green-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Pickup</p>
                        <p class="text-lg font-bold text-gray-800"><?php echo e(\Carbon\Carbon::parse($booking->pickup_date)->format('l, M d, Y')); ?></p>
                        <p class="text-gray-600"><?php echo e(\Carbon\Carbon::parse($booking->pickup_time, 'UTC')->format('h:i A')); ?></p>
                    </div>
                    
                    <div class="bg-red-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Return</p>
                        <p class="text-lg font-bold text-gray-800"><?php echo e(\Carbon\Carbon::parse($booking->return_date)->format('l, M d, Y')); ?></p>
                        <p class="text-gray-600"><?php echo e(\Carbon\Carbon::parse($booking->return_time, 'UTC')->format('h:i A')); ?></p>
                    </div>
                </div>
                
                <div class="mt-4 p-4 bg-blue-50 rounded-lg">
                    <p class="text-center text-gray-700">
                        <span class="font-bold text-2xl text-blue-600"><?php echo e($booking->total_days); ?></span>
                        <span class="text-gray-600 ml-2"><?php echo e(Str::plural('day', $booking->total_days)); ?> rental</span>
                    </p>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-user text-green-600 mr-2"></i>Customer Information
                </h2>
                
                <div class="grid md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <p class="text-sm text-gray-600">Name</p>
                        <p class="font-semibold"><?php echo e($booking->user->name); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Email</p>
                        <p class="font-semibold"><?php echo e($booking->user->email); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Phone</p>
                        <p class="font-semibold"><?php echo e($booking->user->phone); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">User ID</p>
                        <p class="font-semibold">#<?php echo e($booking->user->id); ?></p>
                    </div>
                </div>
            </div>

            <!-- Driver Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-id-card text-green-600 mr-2"></i>Driver Information
                </h2>
                
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Driver Name</p>
                        <p class="font-semibold"><?php echo e($booking->driver_name); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Phone</p>
                        <p class="font-semibold"><?php echo e($booking->driver_phone); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Email</p>
                        <p class="font-semibold"><?php echo e($booking->driver_email); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Age</p>
                        <p class="font-semibold"><?php echo e($booking->driver_age); ?> years</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">License Number</p>
                        <p class="font-semibold"><?php echo e($booking->driver_license_number); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">License Expiry</p>
                        <p class="font-semibold"><?php echo e(\Carbon\Carbon::parse($booking->driver_license_expiry)->format('M d, Y')); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Driving Experience</p>
                        <p class="font-semibold"><?php echo e($booking->driver_experience_years); ?> years</p>
                    </div>
                    <?php if($booking->driver_license_photo): ?>
                        <div class="col-span-2">
                            <p class="text-sm text-gray-600 mb-2">License Photo</p>
                            <img src="<?php echo e(asset('storage/' . $booking->driver_license_photo)); ?>" 
                                alt="Driver License" 
                                class="w-64 h-auto rounded-lg border cursor-pointer"
                                onclick="window.open('<?php echo e(asset('storage/' . $booking->driver_license_photo)); ?>', '_blank')">
                        </div>
                    <?php endif; ?>
                </div>
                
                <?php if($booking->special_requests): ?>
                    <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Special Requests</p>
                        <p class="text-gray-800"><?php echo e($booking->special_requests); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Payment Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-credit-card text-green-600 mr-2"></i>Payment Information
                </h2>
                
                <div class="grid md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <p class="text-sm text-gray-600">Payment Status</p>
                        <span class="inline-block px-3 py-1 rounded-full text-sm font-semibold mt-1
                            <?php if($booking->payment_status === 'paid'): ?> bg-green-100 text-green-800
                            <?php elseif($booking->payment_status === 'pending_verification'): ?> bg-yellow-100 text-yellow-800
                            <?php else: ?> bg-gray-100 text-gray-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $booking->payment_status))); ?>

                        </span>
                    </div>
                    <?php if($booking->payment_method): ?>
                        <div>
                            <p class="text-sm text-gray-600">Payment Method</p>
                            <p class="font-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $booking->payment_method))); ?></p>
                        </div>
                    <?php endif; ?>
                    <?php if($booking->payment_reference): ?>
                        <div>
                            <p class="text-sm text-gray-600">Payment Reference</p>
                            <p class="font-mono font-semibold"><?php echo e($booking->payment_reference); ?></p>
                        </div>
                    <?php endif; ?>
                    <?php if($booking->paid_at): ?>
                        <div>
                            <p class="text-sm text-gray-600">Paid At</p>
                            <p class="font-semibold"><?php echo e($booking->paid_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($booking->payment_proof): ?>
                    <div class="mt-4">
                        <p class="text-sm text-gray-600 mb-2">Payment Proof</p>
                        <img src="<?php echo e(asset('storage/' . $booking->payment_proof)); ?>" 
                            alt="Payment Proof" 
                            class="w-64 h-auto rounded-lg border cursor-pointer"
                            onclick="window.open('<?php echo e(asset('storage/' . $booking->payment_proof)); ?>', '_blank')">
                    </div>
                <?php endif; ?>

                <?php if($booking->payment_status === 'pending_verification' && $booking->payment_proof): ?>
                    <form method="POST" action="<?php echo e(route('admin.car-bookings.verify-payment', $booking)); ?>" class="mt-4">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 font-semibold">
                            <i class="fas fa-check-circle mr-2"></i>Verify Payment
                        </button>
                    </form>
                <?php endif; ?>
            </div>

            <!-- Vendor Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-store text-green-600 mr-2"></i>Vendor Information
                </h2>
                
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Business Name</p>
                        <p class="font-semibold"><?php echo e($booking->vendor->business_name); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Contact Person</p>
                        <p class="font-semibold"><?php echo e($booking->vendor->user->name); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Email</p>
                        <p class="font-semibold"><?php echo e($booking->vendor->user->email); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Phone</p>
                        <p class="font-semibold"><?php echo e($booking->vendor->user->phone); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <!-- Cost Breakdown -->
            <div class="bg-white rounded-xl shadow-lg p-6 mb-6 sticky top-4">
                <h3 class="font-bold text-lg text-gray-800 mb-4">Cost Breakdown</h3>
                
                <div class="space-y-3 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Rental Cost</span>
                        <span class="font-semibold">₦<?php echo e(number_format($booking->rental_cost)); ?></span>
                    </div>
                    
                    <?php if($booking->insurance_cost > 0): ?>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Insurance</span>
                            <span class="font-semibold">₦<?php echo e(number_format($booking->insurance_cost)); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($booking->security_deposit > 0): ?>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Security Deposit <span class="text-xs text-gray-500">(Refundable)</span></span>
                            <span class="font-semibold text-yellow-600">₦<?php echo e(number_format($booking->security_deposit)); ?></span>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($booking->extra_charges > 0): ?>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Extra Charges</span>
                            <span class="font-semibold">₦<?php echo e(number_format($booking->extra_charges)); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="border-t pt-3 mb-3">
                    <div class="flex justify-between items-center">
                        <span class="font-bold text-gray-800">Total Amount</span>
                        <span class="font-bold text-2xl text-green-600">₦<?php echo e(number_format($booking->total_amount)); ?></span>
                    </div>
                </div>

                <div class="border-t pt-3 mt-3">
                    <p class="text-xs text-gray-600 mb-2">Commission breakdown:</p>
                    <div class="flex justify-between text-sm bg-primary/5 p-2 rounded">
                        <span>Platform (<?php echo e($booking->commission_rate); ?>%)</span>
                        <span class="font-semibold">₦<?php echo e(number_format($booking->commission_amount)); ?></span>
                    </div>
                    <div class="flex justify-between text-sm bg-green-50 p-2 rounded mt-1">
                        <span>Vendor Payout</span>
                        <span class="font-semibold">₦<?php echo e(number_format($booking->vendor_payout_amount)); ?></span>
                    </div>
                </div>
            </div>

            <!-- Update Status -->
            <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                <h3 class="font-bold text-lg text-gray-800 mb-4">Update Status</h3>
                
                <form method="POST" action="<?php echo e(route('admin.car-bookings.update-status', $booking)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Booking Status</label>
                        <select name="status" class="w-full border-2 border-gray-300 rounded-lg px-4 py-2 focus:border-green-600 focus:outline-none">
                            <option value="pending" <?php echo e($booking->status === 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="confirmed" <?php echo e($booking->status === 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                            <option value="active" <?php echo e($booking->status === 'active' ? 'selected' : ''); ?>>Active</option>
                            <option value="completed" <?php echo e($booking->status === 'completed' ? 'selected' : ''); ?>>Completed</option>
                            <option value="cancelled" <?php echo e($booking->status === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        </select>
                    </div>
                    
                    <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold">
                        <i class="fas fa-save mr-2"></i>Update Status
                    </button>
                </form>
            </div>

            <!-- Booking Timeline -->
            <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                <h3 class="font-bold text-lg text-gray-800 mb-4">Booking Timeline</h3>
                
                <div class="space-y-4">
                    <div class="flex items-start">
                        <div class="bg-green-100 rounded-full p-2 mr-3">
                            <i class="fas fa-plus text-green-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Booking Created</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->created_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                    
                    <?php if($booking->confirmed_at): ?>
                        <div class="flex items-start">
                            <div class="bg-blue-100 rounded-full p-2 mr-3">
                                <i class="fas fa-check text-blue-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Confirmed</p>
                                <p class="text-xs text-gray-600"><?php echo e($booking->confirmed_at->format('M d, Y h:i A')); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($booking->paid_at): ?>
                        <div class="flex items-start">
                            <div class="bg-green-100 rounded-full p-2 mr-3">
                                <i class="fas fa-money-bill text-green-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Payment Received</p>
                                <p class="text-xs text-gray-600"><?php echo e($booking->paid_at->format('M d, Y h:i A')); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($booking->pickup_at): ?>
                        <div class="flex items-start">
                            <div class="bg-purple-100 rounded-full p-2 mr-3">
                                <i class="fas fa-car text-purple-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Vehicle Picked Up</p>
                                <p class="text-xs text-gray-600"><?php echo e($booking->pickup_at->format('M d, Y h:i A')); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($booking->returned_at): ?>
                        <div class="flex items-start">
                            <div class="bg-gray-100 rounded-full p-2 mr-3">
                                <i class="fas fa-flag-checkered text-gray-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Vehicle Returned</p>
                                <p class="text-xs text-gray-600"><?php echo e($booking->returned_at->format('M d, Y h:i A')); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Pending Review -->
            <?php if($booking->review && !$booking->review->is_approved): ?>
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-star text-yellow-500 mr-2"></i>Pending Review Approval
                    </h3>

                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 mb-4">
                        <p class="font-semibold text-yellow-800 mb-2">Customer has submitted a review</p>
                        <p class="text-sm text-yellow-700">Please review and approve or reject this feedback.</p>
                    </div>

                    <div class="mb-4">
                        <div class="flex items-center gap-3 mb-3">
                            <div>
                                <p class="font-bold text-gray-800"><?php echo e($booking->user->name); ?></p>
                                <p class="text-sm text-gray-500"><?php echo e($booking->review->created_at->format('M d, Y h:i A')); ?></p>
                            </div>
                            <div class="flex text-yellow-400 ml-auto">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <i class="fas fa-star <?php echo e($i <= $booking->review->overall_rating ? '' : 'text-gray-300'); ?> text-xl"></i>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <p class="text-gray-700"><?php echo e($booking->review->comment); ?></p>
                        </div>
                    </div>

                    <div class="flex gap-3">
                        <form method="POST" action="<?php echo e(route('admin.car-reviews.approve', $booking->review)); ?>" class="flex-1">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                <i class="fas fa-check-circle mr-2"></i>Approve Review
                            </button>
                        </form>
                        <form method="POST" action="<?php echo e(route('admin.car-reviews.reject', $booking->review)); ?>" class="flex-1"
                            onsubmit="return confirm('Are you sure you want to reject and delete this review?')">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="w-full bg-red-600 text-white py-3 rounded-lg hover:bg-red-700 font-semibold transition">
                                <i class="fas fa-times-circle mr-2"></i>Reject Review
                            </button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Security Deposit Management (Full Width) -->
    <?php if($booking->returned_at || in_array($booking->status, ['completed', 'pending_inspection'])): ?>
        <div class="mt-6">
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-shield-alt text-green-600 mr-3"></i> Security Deposit Management
                </h2>
                
                <!-- Current Status -->
                <div class="mb-6 p-4 bg-light-bg rounded-lg">
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Security Deposit Amount</p>
                            <p class="font-bold text-2xl text-gray-800">₦<?php echo e(number_format($booking->security_deposit ?? 0)); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Current Status</p>
                            <p class="font-bold text-xl
                                <?php if($booking->deposit_status === 'refunded'): ?> text-green-600
                                <?php elseif($booking->deposit_status === 'deducted' || $booking->deposit_status === 'partially_deducted'): ?> text-orange-600
                                <?php elseif($booking->deposit_status === 'dispute_pending'): ?> text-yellow-600
                                <?php else: ?> text-gray-600
                                <?php endif; ?>">
                                <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst(str_replace('_', ' ', $booking->deposit_status ?? 'pending_inspection'))); ?>

                            </p>
                        </div>
                    </div>
                </div>

                <!-- Deposit Dispute Resolution -->
                <?php if($booking->deposit_status === 'dispute_pending' && $booking->deposit_deduction_amount): ?>
                    <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-exclamation-triangle text-red-600 mr-2"></i>Security Deposit Dispute
                        </h3>

                        <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
                            <p class="font-semibold text-red-800 mb-2">Vendor has reported damage</p>
                            <p class="text-sm text-red-700">
                                The vendor is requesting to deduct ₦<?php echo e(number_format($booking->deposit_deduction_amount)); ?> 
                                from the security deposit of ₦<?php echo e(number_format($booking->security_deposit)); ?>.
                            </p>
                        </div>

                        <div class="mb-6">
                            <h4 class="font-bold text-gray-800 mb-2">Damage Report:</h4>
                            <p class="text-gray-700 bg-gray-50 p-4 rounded-lg"><?php echo e($booking->damage_report); ?></p>
                        </div>

                        <?php if($booking->return_photos && count($booking->return_photos) > 0): ?>
                            <div class="mb-6">
                                <h4 class="font-bold text-gray-800 mb-2">Damage Photos:</h4>
                                <div class="grid grid-cols-3 gap-4">
                                    <?php $__currentLoopData = $booking->return_photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <img src="<?php echo e(asset('storage/' . $photo)); ?>" 
                                            alt="Damage photo" 
                                            class="w-full h-32 object-cover rounded-lg cursor-pointer hover:opacity-75"
                                            onclick="window.open('<?php echo e(asset('storage/' . $photo)); ?>', '_blank')">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('admin.car-bookings.resolve-deposit', $booking)); ?>">
                            <?php echo csrf_field(); ?>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Admin Decision
                                </label>
                                <select name="decision" id="depositDecision" required class="w-full border-gray-300 rounded-lg">
                                    <option value="">Select decision...</option>
                                    <option value="approve_deduction">Approve Full Deduction</option>
                                    <option value="partial_deduction">Approve Partial Deduction</option>
                                    <option value="reject_deduction">Reject Deduction - Full Refund</option>
                                </select>
                            </div>

                            <div id="partialDepositAmount" class="mb-4 hidden">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Approved Deduction Amount (₦)
                                </label>
                                <input type="number" name="approved_amount" 
                                    min="0" max="<?php echo e($booking->security_deposit); ?>"
                                    class="w-full border-gray-300 rounded-lg"
                                    placeholder="Enter approved amount">
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Admin Notes
                                </label>
                                <textarea name="admin_notes" rows="3" required
                                    class="w-full border-gray-300 rounded-lg"
                                    placeholder="Explain your decision..."></textarea>
                            </div>

                            <button type="submit" 
                                class="w-full bg-primary text-white py-3 rounded-lg hover:bg-primary-dark font-semibold transition">
                                <i class="fas fa-gavel mr-2"></i>Submit Decision
                            </button>
                        </form>

                        <script>
                            document.getElementById('depositDecision').addEventListener('change', function() {
                                const partialAmount = document.getElementById('partialDepositAmount');
                                if (this.value === 'partial_deduction') {
                                    partialAmount.classList.remove('hidden');
                                    partialAmount.querySelector('input').required = true;
                                } else {
                                    partialAmount.classList.add('hidden');
                                    partialAmount.querySelector('input').required = false;
                                }
                            });
                        </script>
                    </div>
                <?php elseif(!$booking->deposit_status || in_array($booking->deposit_status, ['pending', 'pending_inspection', 'held'])): ?>
                    <div class="p-4 bg-blue-50 border-l-4 border-blue-500 rounded">
                        <p class="text-blue-800">
                            <i class="fas fa-info-circle mr-2"></i>
                            Waiting for vendor to decide on security deposit refund. Vendor can either refund in full or report damages.
                        </p>
                    </div>
                <?php endif; ?>

                <!-- User Refund Payout Request -->
                <?php if($booking->refund_payout_status === 'requested' && $booking->deposit_refund_amount > 0): ?>
                    <div class="mt-6 bg-white rounded-xl shadow-lg p-6">
                        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-hand-holding-usd text-green-600 mr-2"></i>User Refund Payout Request
                        </h3>

                        <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 mb-6">
                            <p class="font-semibold text-yellow-800 mb-2">Action Required - User Requesting Refund</p>
                            <p class="text-sm text-yellow-700">
                                The user has requested payout of their security deposit refund of ₦<?php echo e(number_format($booking->deposit_refund_amount)); ?>.
                            </p>
                            <p class="text-xs text-yellow-600 mt-2">
                                Requested on: <?php echo e($booking->refund_requested_at->format('M d, Y h:i A')); ?>

                            </p>
                        </div>

                        <!-- User Bank Details -->
                        <div class="mb-6 bg-gray-50 rounded-lg p-4">
                            <h4 class="font-bold text-gray-800 mb-3">User Bank Details:</h4>
                            <?php if($booking->user->bank_name && $booking->user->account_number): ?>
                                <div class="grid md:grid-cols-3 gap-4">
                                    <div>
                                        <p class="text-xs text-gray-600">Bank Name</p>
                                        <p class="font-semibold"><?php echo e($booking->user->bank_name); ?></p>
                                    </div>
                                    <div>
                                        <p class="text-xs text-gray-600">Account Number</p>
                                        <p class="font-semibold"><?php echo e($booking->user->account_number); ?></p>
                                    </div>
                                    <div>
                                        <p class="text-xs text-gray-600">Account Name</p>
                                        <p class="font-semibold"><?php echo e($booking->user->account_name ?? 'N/A'); ?></p>
                                    </div>
                                </div>
                            <?php else: ?>
                                <p class="text-red-600 text-sm">
                                    <i class="fas fa-exclamation-triangle mr-2"></i>User has not provided bank details. Please contact user.
                                </p>
                            <?php endif; ?>
                        </div>

                        <!-- Process Refund Form -->
                        <form method="POST" action="<?php echo e(route('admin.car-bookings.process-refund', $booking)); ?>">
                            <?php echo csrf_field(); ?>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Payment Method
                                </label>
                                <select name="payment_method" required class="w-full border-gray-300 rounded-lg">
                                    <option value="">Select payment method...</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="cash">Cash</option>
                                    <option value="cheque">Cheque</option>
                                    <option value="mobile_money">Mobile Money</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Payment Reference/Notes
                                </label>
                                <textarea name="payment_details" rows="3" required
                                    class="w-full border-gray-300 rounded-lg"
                                    placeholder="Enter transaction reference or payment notes..."></textarea>
                            </div>

                            <button type="submit" 
                                class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                <i class="fas fa-check-circle mr-2"></i>Mark as Paid (₦<?php echo e(number_format($booking->deposit_refund_amount)); ?>)
                            </button>
                        </form>
                    </div>
                <?php elseif($booking->refund_payout_status === 'processing'): ?>
                    <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-500 rounded">
                        <p class="text-yellow-800">
                            <i class="fas fa-spinner fa-spin mr-2"></i>
                            Refund is being processed. Mark as paid when complete.
                        </p>
                    </div>
                <?php elseif($booking->refund_payout_status === 'paid'): ?>
                    <div class="mt-6 bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                        <p class="font-semibold text-green-800 mb-2">
                            <i class="fas fa-check-circle mr-2"></i>Refund Paid
                        </p>
                        <div class="grid md:grid-cols-2 gap-4 mt-3 text-sm">
                            <div>
                                <p class="text-gray-600">Amount Paid</p>
                                <p class="font-bold">₦<?php echo e(number_format($booking->deposit_refund_amount)); ?></p>
                            </div>
                            <div>
                                <p class="text-gray-600">Payment Date</p>
                                <p class="font-bold"><?php echo e($booking->refund_paid_at->format('M d, Y h:i A')); ?></p>
                            </div>
                            <?php if($booking->refund_payment_method): ?>
                                <div>
                                    <p class="text-gray-600">Payment Method</p>
                                    <p class="font-bold"><?php echo e(ucfirst(str_replace('_', ' ', $booking->refund_payment_method))); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if($booking->refund_payment_details): ?>
                                <div class="md:col-span-2">
                                    <p class="text-gray-600">Payment Details</p>
                                    <p class="font-bold"><?php echo e($booking->refund_payment_details); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Deposit Status Summary -->
                <?php if(in_array($booking->deposit_status, ['refunded', 'deducted', 'partially_deducted'])): ?>
                    <div class="mt-6 p-4 rounded-lg
                        <?php if($booking->deposit_status === 'refunded'): ?> bg-green-50 border-l-4 border-green-500
                        <?php elseif($booking->deposit_status === 'deducted'): ?> bg-red-50 border-l-4 border-red-500
                        <?php else: ?> bg-orange-50 border-l-4 border-orange-500
                        <?php endif; ?>">
                        <h4 class="font-bold mb-3
                            <?php if($booking->deposit_status === 'refunded'): ?> text-green-800
                            <?php elseif($booking->deposit_status === 'deducted'): ?> text-red-800
                            <?php else: ?> text-orange-800
                            <?php endif; ?>">
                            Deposit Decision Summary
                        </h4>
                        <div class="grid md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <p class="text-gray-600">Original Deposit</p>
                                <p class="font-bold">₦<?php echo e(number_format($booking->security_deposit)); ?></p>
                            </div>
                            <?php if($booking->deposit_deduction_amount > 0): ?>
                                <div>
                                    <p class="text-gray-600">Deduction</p>
                                    <p class="font-bold text-red-600">-₦<?php echo e(number_format($booking->deposit_deduction_amount)); ?></p>
                                </div>
                            <?php endif; ?>
                            <div>
                                <p class="text-gray-600">Refund to Customer</p>
                                <p class="font-bold text-green-600">₦<?php echo e(number_format($booking->deposit_refund_amount ?? 0)); ?></p>
                            </div>
                        </div>
                        <?php if($booking->deposit_deduction_reason): ?>
                            <div class="mt-3 pt-3 border-t">
                                <p class="text-xs text-gray-600">Reason:</p>
                                <p class="text-sm"><?php echo e($booking->deposit_deduction_reason); ?></p>
                            </div>
                        <?php endif; ?>
                        <?php if($booking->admin_notes): ?>
                            <div class="mt-3 pt-3 border-t">
                                <p class="text-xs text-gray-600">Admin Notes:</p>
                                <p class="text-sm"><?php echo e($booking->admin_notes); ?></p>
                            </div>
                        <?php endif; ?>
                        <?php if($booking->deposit_refunded_at): ?>
                            <div class="mt-3 pt-3 border-t">
                                <p class="text-xs text-gray-600">Decided on: <?php echo e($booking->deposit_refunded_at->format('M d, Y h:i A')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/car-bookings/show.blade.php ENDPATH**/ ?>