<?php $__env->startSection('title', 'Bank Transfer Instructions'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow-md p-8">
        <div class="text-center mb-6">
            <div class="bg-green-100 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-university text-green-600 text-4xl"></i>
            </div>
            <h1 class="text-3xl font-bold mb-2">Complete Your Bank Transfer</h1>
            <p class="text-gray-600">Follow the instructions below to complete your payment</p>
        </div>

        <?php
            $bankTransferMethod = \App\Models\PaymentMethod::where('slug', 'bank_transfer')->first();
            $settings = $bankTransferMethod->settings ?? [];
        ?>

        <!-- Bank Details -->
        <div class="bg-primary/5 border-2 border-blue-200 rounded-lg p-6 mb-6">
            <h2 class="font-bold text-xl mb-4 text-blue-900">Transfer to this Account:</h2>
            
            <div class="space-y-3">
                <div>
                    <p class="text-sm text-gray-600">Bank Name</p>
                    <p class="font-bold text-lg"><?php echo e($settings['bank_name'] ?? 'N/A'); ?></p>
                </div>
                
                <div>
                    <p class="text-sm text-gray-600">Account Name</p>
                    <p class="font-bold text-lg"><?php echo e($settings['account_name'] ?? 'N/A'); ?></p>
                </div>
                
                <div class="bg-white p-4 rounded border-2 border-blue-300">
                    <p class="text-sm text-gray-600 mb-1">Account Number</p>
                    <div class="flex items-center justify-between">
                        <p class="font-bold text-2xl text-primary"><?php echo e($settings['account_number'] ?? 'N/A'); ?></p>
                        <button type="button" 
                            onclick="copyAccountNumber('<?php echo e($settings['account_number'] ?? ''); ?>')"
                            class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark transition">
                            <i class="fas fa-copy mr-1"></i> Copy
                        </button>
                    </div>
                </div>
                
                <div class="bg-yellow-50 border border-yellow-300 rounded p-3">
                    <p class="text-sm"><strong>Amount to Transfer:</strong></p>
                    <p class="text-2xl font-bold text-yellow-800">₦<?php echo e(number_format($booking->total_amount, 2)); ?></p>
                </div>
            </div>
        </div>

        <!-- Instructions -->
        <div class="mb-6">
            <h3 class="font-bold text-lg mb-3">Instructions:</h3>
            <ol class="list-decimal list-inside space-y-2 text-gray-700">
                <li>Transfer the exact amount shown above to the account details provided</li>
                <li>Use <strong><?php echo e($booking->payment_reference); ?></strong> as your transfer reference/narration</li>
                <li>After completing the transfer, upload proof of payment below</li>
                <li>Your booking will be confirmed once payment is verified by our team</li>
            </ol>
        </div>

        <!-- Upload Proof Form -->
        <div class="border-t pt-6">
            <h3 class="font-bold text-lg mb-4">Upload Proof of Payment</h3>
            
            <form method="POST" action="<?php echo e(route('bookings.upload-payment-proof', $booking)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Payment Proof (Receipt/Screenshot) *</label>
                    <input type="file" name="payment_proof" accept="image/*,.pdf" required
                        class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <p class="text-sm text-gray-600 mt-1">Upload a clear image or PDF of your transfer receipt</p>
                    <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Additional Notes (Optional)</label>
                    <textarea name="payment_notes" rows="3" 
                        class="w-full border rounded px-4 py-2"
                        placeholder="Any additional information about your transfer..."></textarea>
                </div>

                <div class="flex gap-4">
                    <button type="submit" 
                        class="flex-1 bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold">
                        <i class="fas fa-upload mr-2"></i> Submit Payment Proof
                    </button>
                    <a href="<?php echo e(route('bookings.show', $booking)); ?>" 
                        class="flex-1 bg-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-400 text-center font-semibold">
                        I'll Upload Later
                    </a>
                </div>
            </form>
        </div>

        <!-- Reference Info -->
        <div class="mt-6 p-4 bg-light-bg rounded text-sm text-gray-600">
            <p><strong>Booking Reference:</strong> <?php echo e($booking->payment_reference); ?></p>
            <p><strong>Property:</strong> <?php echo e($booking->property->title); ?></p>
            <p class="mt-2 text-xs">
                <i class="fas fa-info-circle"></i> Keep this reference for your records. You can also upload proof later from your bookings page.
            </p>
        </div>
    </div>
</div>

<script>
function copyAccountNumber(accountNumber) {
    const tempInput = document.createElement('input');
    tempInput.value = accountNumber;
    document.body.appendChild(tempInput);
    tempInput.select();
    
    try {
        document.execCommand('copy');
        
        const button = event.target.closest('button');
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check mr-1"></i> Copied!';
        button.classList.remove('bg-primary', 'hover:bg-primary-dark');
        button.classList.add('bg-green-600');
        
        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('bg-green-600');
            button.classList.add('bg-primary', 'hover:bg-primary-dark');
        }, 2000);
    } catch (err) {
        alert('Failed to copy. Please copy manually: ' + accountNumber);
    }
    
    document.body.removeChild(tempInput);
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/bookings/bank-transfer.blade.php ENDPATH**/ ?>