<?php $__env->startSection('title', 'Add New Car'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-plus-circle mr-3"></i>Add New Car
                    </h1>
                    <p class="text-primary-light">Fill in the details to list your vehicle</p>
                </div>
                <a href="<?php echo e(route('vendor.cars.index')); ?>" 
                    class="bg-white/20 backdrop-blur-sm text-white px-6 py-3 rounded-lg hover:bg-white/30 transition">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Cars
                </a>
            </div>
        </div>
    </div>

    <form method="POST" action="<?php echo e(route('vendor.cars.store')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <?php echo $__env->make('vendor.cars._form_basic', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('vendor.cars._form_specs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('vendor.cars._form_location', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('vendor.cars._form_pricing', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('vendor.cars._form_requirements', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('vendor.cars._form_photos', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('vendor.cars._form_description', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Submit Button -->
        <div class="flex items-center justify-between bg-gradient-to-r from-gray-50 to-gray-100 p-6 rounded-xl shadow-lg">
            <div class="flex items-center">
                <div class="bg-primary/10 p-3 rounded-lg mr-4">
                    <i class="fas fa-info-circle text-primary text-2xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-gray-800">Ready to list your car?</p>
                    <p class="text-sm text-gray-600">Your car will be reviewed by management before going live</p>
                </div>
            </div>
            <button type="submit" 
                class="bg-gradient-to-r from-primary to-primary-dark text-white px-8 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold flex items-center">
                <i class="fas fa-check-circle mr-2"></i>Add Car
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/cars/create.blade.php ENDPATH**/ ?>