<?php $__env->startSection('title', 'Manage Bookings'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h1 class="text-3xl font-bold mb-6">Manage Bookings</h1>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <form method="GET" class="grid md:grid-cols-4 gap-4">
            <input type="text" 
                name="search" 
                placeholder="Search by guest name/email" 
                value="<?php echo e(request('search')); ?>"
                class="border rounded px-4 py-2">

            <select name="status" class="border rounded px-4 py-2">
                <option value="">All Statuses</option>
                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="confirmed" <?php echo e(request('status') === 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
            </select>

            <select name="payment_status" class="border rounded px-4 py-2">
                <option value="">All Payment Status</option>
                <option value="pending" <?php echo e(request('payment_status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="paid" <?php echo e(request('payment_status') === 'paid' ? 'selected' : ''); ?>>Paid</option>
                <option value="refunded" <?php echo e(request('payment_status') === 'refunded' ? 'selected' : ''); ?>>Refunded</option>
            </select>

            <button type="submit" class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                Filter
            </button>
        </form>
    </div>

    <!-- Bookings Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="w-full">
            <thead class="bg-light-bg">
                <tr>
                    <th class="px-4 py-3 text-left">ID</th>
                    <th class="px-4 py-3 text-left">Guest</th>
                    <th class="px-4 py-3 text-left">Property</th>
                    <th class="px-4 py-3 text-left">Vendor</th>
                    <th class="px-4 py-3 text-left">Check-in</th>
                    <th class="px-4 py-3 text-left">Amount</th>
                    <th class="px-4 py-3 text-left">Payment</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b hover:bg-light-bg">
                        <td class="px-4 py-3">#<?php echo e($booking->id); ?></td>
                        <td class="px-4 py-3">
                            <p class="font-semibold"><?php echo e($booking->user->name); ?></p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->user->email); ?></p>
                        </td>
                        <td class="px-4 py-3"><?php echo e(Str::limit($booking->property->title, 30)); ?></td>
                        <td class="px-4 py-3"><?php echo e($booking->vendor->company_name); ?></td>
                        <td class="px-4 py-3"><?php echo e($booking->start_date->format('M d, Y')); ?></td>
                        <td class="px-4 py-3">₦<?php echo e(number_format($booking->total_amount)); ?></td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs
                                <?php echo e($booking->payment_status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                                <?php echo e(ucfirst($booking->payment_status)); ?>

                            </span>
                            <?php if($booking->payment_status === 'paid' && !$booking->admin_verified): ?>
                                <span class="block mt-1 text-xs text-red-600">⚠ Needs verification</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs
                                <?php if($booking->booking_status === 'confirmed'): ?> bg-green-100 text-green-800
                                <?php elseif($booking->booking_status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif($booking->booking_status === 'cancelled'): ?> bg-red-100 text-red-800
                                <?php else: ?> bg-primary/10 text-blue-800
                                <?php endif; ?>">
                                <?php echo e(ucfirst($booking->booking_status)); ?>

                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <a href="<?php echo e(route('admin.bookings.show', $booking)); ?>" 
                                class="text-primary hover:underline">View</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center py-8 text-gray-600">No bookings found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        <?php echo e($bookings->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/bookings/index.blade.php ENDPATH**/ ?>