<?php $__env->startSection('title', 'Terms & Conditions'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-3 sm:px-4">
    <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold mb-4 sm:mb-6">Terms & Conditions</h1>

    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8">
        <p class="text-xs sm:text-sm text-gray-600 mb-4 sm:mb-6">Last updated: <?php echo e(date('F d, Y')); ?></p>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">1. Acceptance of Terms</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                By accessing and using ShortStayNG, you accept and agree to be bound by the terms and 
                provision of this agreement. If you do not agree to these terms, please do not use our services.
            </p>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">2. User Accounts</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                You are responsible for maintaining the confidentiality of your account and password. 
                You agree to accept responsibility for all activities that occur under your account.
            </p>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">3. Booking and Payment</h2>
            <ul class="list-disc list-inside text-gray-700 space-y-2 text-sm sm:text-base leading-relaxed">
                <li>All bookings are subject to availability and confirmation</li>
                <li>Payment must be made through our secure payment gateway</li>
                <li>Caution fees are refundable subject to property condition</li>
                <li>Commission rates are applied as stated during vendor onboarding</li>
                <li>Cancellation policies vary by property</li>
            </ul>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">4. Vendor Responsibilities</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                Vendors must provide accurate property information, maintain property standards, 
                respond promptly to booking requests, and comply with all applicable laws and regulations.
            </p>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">5. User Conduct</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                Users agree to respect properties, follow house rules, and treat vendors with respect. 
                Violation of property rules may result in forfeiture of caution fees.
            </p>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">6. Limitation of Liability</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                ShortStayNG acts as an intermediary between users and vendors. We are not responsible 
                for the condition, safety, or legality of properties listed on our platform.
            </p>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">7. Privacy</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                Your privacy is important to us. We collect and use personal information only as 
                described in our Privacy Policy. We do not share your information with third parties 
                except as necessary to provide our services.
            </p>
        </section>

        <section class="mb-6 sm:mb-8">
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">8. Dispute Resolution</h2>
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base leading-relaxed">
                Any disputes arising from bookings should first be addressed with the vendor. 
                If unresolved, contact our support team for mediation.
            </p>
        </section>

        <section>
            <h2 class="text-lg sm:text-xl md:text-2xl font-bold mb-3 sm:mb-4">9. Contact Information</h2>
            <p class="text-gray-700 text-sm sm:text-base leading-relaxed">
                For questions about these terms, please contact us at: 
                <a href="mailto:legal@shortstayng.com" class="text-primary hover:underline break-all">legal@shortstayng.com</a>
            </p>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/pages/terms.blade.php ENDPATH**/ ?>