<?php $__env->startSection('title', 'Edit Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-3 sm:px-4 py-4 sm:py-8">
    <!-- Header -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
            <i class="fas fa-user-edit mr-2 sm:mr-3"></i>Edit Profile
        </h1>
        <p class="text-primary-light text-sm sm:text-base">Manage your account settings and preferences</p>
    </div>

    <div class="grid lg:grid-cols-3 gap-4 sm:gap-6">
        <!-- Left Column - Profile Photo -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-camera text-primary mr-2 sm:mr-3"></i> Profile Photo
                </h2>
                
                <form method="POST" action="<?php echo e(route('profile.update')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="text-center mb-3 sm:mb-4">
                        <?php if(auth()->user()->profile_photo): ?>
                            <img src="<?php echo e(asset('storage/' . auth()->user()->profile_photo)); ?>" 
                                alt="<?php echo e(auth()->user()->name); ?>"
                                class="w-24 h-24 sm:w-32 sm:h-32 rounded-full object-cover mx-auto mb-3 sm:mb-4 border-4 border-primary shadow-lg"
                                onerror="this.src='https://ui-avatars.com/api/?name=<?php echo e(urlencode(auth()->user()->name)); ?>&background=136D73&color=fff&size=128'">
                        <?php else: ?>
                            <div class="w-24 h-24 sm:w-32 sm:h-32 rounded-full bg-primary flex items-center justify-center text-white text-3xl sm:text-4xl font-bold mx-auto mb-3 sm:mb-4 shadow-lg">
                                <?php echo e(substr(auth()->user()->name, 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-3 sm:mb-4">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-upload text-primary mr-2"></i>Upload New Photo
                        </label>
                        <input type="file" name="profile_photo" accept="image/*" 
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm">
                        <p class="text-xs text-gray-500 mt-2">JPG, PNG or GIF (Max 2MB)</p>
                    </div>
                    
                    <button type="submit" class="w-full bg-primary text-white py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold transition text-sm sm:text-base">
                        <i class="fas fa-save mr-2"></i> Update Photo
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Right Column - Forms -->
        <div class="lg:col-span-2 space-y-4 sm:space-y-6">
            <!-- Personal Information -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                    <i class="fas fa-user text-primary mr-2 sm:mr-3"></i> Personal Information
                </h2>

                <form method="POST" action="<?php echo e(route('profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-user-circle text-primary mr-2"></i>Full Name
                        </label>
                        <input type="text" name="name" value="<?php echo e(old('name', auth()->user()->name)); ?>" required
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-envelope text-primary mr-2"></i>Email Address
                        </label>
                        <input type="email" value="<?php echo e(auth()->user()->email); ?>" disabled
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 bg-gray-100 cursor-not-allowed text-sm sm:text-base">
                        <p class="text-xs text-gray-500 mt-2"><i class="fas fa-lock mr-1"></i>Email cannot be changed</p>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-phone text-primary mr-2"></i>Phone Number
                        </label>
                        <input type="tel" name="phone" value="<?php echo e(old('phone', auth()->user()->phone)); ?>" required
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <button type="submit" class="w-full bg-primary text-white py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold transition text-sm sm:text-base">
                        <i class="fas fa-save mr-2"></i> Update Profile
                    </button>
                </form>
            </div>

            <!-- Bank Details -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-university text-primary mr-2 sm:mr-3"></i> Bank Details
                </h2>
                <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                    <p class="text-xs sm:text-sm text-blue-800">
                        <i class="fas fa-info-circle mr-2"></i>
                        Required for caution fee refunds
                    </p>
                </div>

                <form method="POST" action="<?php echo e(route('profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-building text-primary mr-2"></i>Bank Name
                        </label>
                        <input type="text" name="bank_name" 
                            value="<?php echo e(old('bank_name', auth()->user()->bank_name)); ?>"
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base">
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-hashtag text-primary mr-2"></i>Account Number
                        </label>
                        <input type="text" name="account_number" 
                            value="<?php echo e(old('account_number', auth()->user()->account_number)); ?>"
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base">
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-user-tag text-primary mr-2"></i>Account Name
                        </label>
                        <input type="text" name="account_name" 
                            value="<?php echo e(old('account_name', auth()->user()->account_name)); ?>"
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base">
                    </div>

                    <button type="submit" class="w-full bg-green-600 text-white py-2.5 sm:py-3 rounded-lg hover:bg-green-700 font-semibold transition text-sm sm:text-base">
                        <i class="fas fa-save mr-2"></i> Save Bank Details
                    </button>
                </form>
            </div>

            <!-- Change Password -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-lock text-primary mr-2 sm:mr-3"></i> Change Password
                </h2>
                <div class="bg-yellow-50 border-l-4 border-yellow-500 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                    <p class="text-xs sm:text-sm text-yellow-800">
                        <i class="fas fa-shield-alt mr-2"></i>
                        Choose a strong password to keep your account secure
                    </p>
                </div>

                <form method="POST" action="<?php echo e(route('profile.password.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-key text-primary mr-2"></i>Current Password
                        </label>
                        <input type="password" name="current_password" required
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-lock text-primary mr-2"></i>New Password
                        </label>
                        <input type="password" name="password" required
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-check-circle text-primary mr-2"></i>Confirm New Password
                        </label>
                        <input type="password" name="password_confirmation" required
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base">
                    </div>

                    <button type="submit" class="w-full bg-red-600 text-white py-2.5 sm:py-3 rounded-lg hover:bg-red-700 font-semibold transition text-sm sm:text-base">
                        <i class="fas fa-key mr-2"></i> Change Password
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/user/profile/edit.blade.php ENDPATH**/ ?>