<?php $__env->startSection('title', 'Review Your Car Rental'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4 max-w-3xl">
        <!-- Header -->
        <div class="mb-8">
            <a href="<?php echo e(route('bookings.index')); ?>" class="text-primary hover:text-primary-dark font-semibold mb-4 inline-block">
                <i class="fas fa-arrow-left mr-2"></i>Back to Bookings
            </a>
            <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-xl shadow-lg p-6">
                <h1 class="text-3xl font-bold mb-2">
                    <i class="fas fa-star mr-3"></i>Review Your Car Rental
                </h1>
                <p class="text-green-100">Share your experience with <?php echo e($booking->car->full_name); ?></p>
            </div>
        </div>

        <!-- Car Details -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
            <div class="flex flex-col md:flex-row gap-6">
                <?php if($booking->car->main_photo): ?>
                    <img src="<?php echo e(asset('storage/' . $booking->car->main_photo)); ?>" 
                        alt="<?php echo e($booking->car->full_name); ?>"
                        class="w-full md:w-48 h-32 object-cover rounded-lg">
                <?php endif; ?>
                
                <div class="flex-1">
                    <h2 class="text-xl font-bold text-gray-800 mb-2"><?php echo e($booking->car->full_name); ?></h2>
                    <p class="text-gray-600 mb-1">
                        <i class="fas fa-building text-primary mr-2"></i><?php echo e($booking->car->vendor->business_name); ?>

                    </p>
                    <p class="text-gray-600">
                        <i class="fas fa-calendar text-primary mr-2"></i>
                        <?php echo e(\Carbon\Carbon::parse($booking->pickup_date)->format('M d, Y')); ?> - 
                        <?php echo e(\Carbon\Carbon::parse($booking->return_date)->format('M d, Y')); ?>

                    </p>
                </div>
            </div>
        </div>

        <!-- Review Form -->
        <div class="bg-white rounded-xl shadow-lg p-6">
            <form method="POST" action="<?php echo e(route('cars.reviews.store', $booking)); ?>">
                <?php echo csrf_field(); ?>
                
                <!-- Rating -->
                <div class="mb-6">
                    <label class="block text-sm font-semibold text-gray-700 mb-3">
                        Overall Rating <span class="text-red-500">*</span>
                    </label>
                    <div class="flex gap-2" id="star-rating">
                        <?php for($i = 1; $i <= 5; $i++): ?>
                            <button type="button" 
                                class="star text-4xl text-gray-300 hover:text-yellow-400 transition"
                                data-rating="<?php echo e($i); ?>">
                                <i class="fas fa-star"></i>
                            </button>
                        <?php endfor; ?>
                    </div>
                    <input type="hidden" name="rating" id="rating-input" value="<?php echo e(old('rating')); ?>" required>
                    <?php $__errorArgs = ['rating'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Comment -->
                <div class="mb-6">
                    <label for="comment" class="block text-sm font-semibold text-gray-700 mb-2">
                        Your Review <span class="text-red-500">*</span>
                    </label>
                    <textarea name="comment" id="comment" rows="6" required
                        class="w-full border-gray-300 rounded-lg focus:ring-primary focus:border-primary"
                        placeholder="Share your experience with this car rental..."><?php echo e(old('comment')); ?></textarea>
                    <p class="text-sm text-gray-500 mt-1">Minimum 10 characters</p>
                    <?php $__errorArgs = ['comment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Submit Button -->
                <div class="flex gap-4">
                    <button type="submit" 
                        class="flex-1 bg-gradient-to-r from-green-600 to-teal-600 text-white py-3 rounded-lg hover:shadow-xl transition font-bold">
                        <i class="fas fa-paper-plane mr-2"></i>Submit Review
                    </button>
                    <a href="<?php echo e(route('bookings.index')); ?>" 
                        class="flex-1 bg-gray-200 text-gray-700 text-center py-3 rounded-lg hover:bg-gray-300 transition font-bold">
                        <i class="fas fa-times mr-2"></i>Cancel
                    </a>
                </div>
            </form>
        </div>

        <!-- Info Notice -->
        <div class="mt-6 bg-blue-50 border-l-4 border-blue-500 rounded-lg p-4 text-sm">
            <p class="text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                Your review will be published after admin approval. Thank you for helping others make informed decisions!
            </p>
        </div>
    </div>
</div>

<script>
    // Star rating functionality
    const stars = document.querySelectorAll('.star');
    const ratingInput = document.getElementById('rating-input');
    let selectedRating = <?php echo e(old('rating', 0)); ?>;

    // Set initial rating if exists
    if (selectedRating > 0) {
        updateStars(selectedRating);
    }

    stars.forEach(star => {
        star.addEventListener('click', function() {
            selectedRating = parseInt(this.dataset.rating);
            ratingInput.value = selectedRating;
            updateStars(selectedRating);
        });

        star.addEventListener('mouseenter', function() {
            const hoverRating = parseInt(this.dataset.rating);
            updateStars(hoverRating);
        });
    });

    document.getElementById('star-rating').addEventListener('mouseleave', function() {
        updateStars(selectedRating);
    });

    function updateStars(rating) {
        stars.forEach((star, index) => {
            if (index < rating) {
                star.classList.remove('text-gray-300');
                star.classList.add('text-yellow-400');
            } else {
                star.classList.remove('text-yellow-400');
                star.classList.add('text-gray-300');
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/cars/reviews/create.blade.php ENDPATH**/ ?>