<?php $__env->startSection('title', 'Edit Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-3 sm:px-4 py-4 sm:py-8">
    <!-- Header -->
    <div class="mb-4 sm:mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                <div>
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                        <i class="fas fa-user-cog mr-2 sm:mr-3"></i>Profile Settings
                    </h1>
                    <p class="text-primary-light text-sm sm:text-base">Manage your account information and preferences</p>
                </div>
                <?php if($vendor->kyc_status === 'approved'): ?>
                    <div class="bg-green-500 text-white px-3 sm:px-4 py-1.5 sm:py-2 rounded-lg text-sm sm:text-base whitespace-nowrap">
                        <i class="fas fa-check-circle mr-2"></i>KYC Verified
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="grid lg:grid-cols-3 gap-4 sm:gap-6">
        <!-- Company Information -->
        <div class="lg:col-span-2 space-y-4 sm:space-y-6">
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-primary/10 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4 flex-shrink-0">
                        <i class="fas fa-building text-primary text-xl sm:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl text-gray-800">Company Information</h2>
                        <p class="text-xs sm:text-sm text-gray-600">Update your business details</p>
                    </div>
                </div>

                <form method="POST" action="<?php echo e(route('vendor.profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="grid md:grid-cols-2 gap-3 sm:gap-4">
                        <div class="mb-3 sm:mb-4">
                            <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                                <i class="fas fa-briefcase text-primary mr-2"></i>Company Name *
                            </label>
                            <input type="text" name="company_name" value="<?php echo e(old('company_name', $vendor->company_name)); ?>" 
                                <?php echo e($vendor->kyc_status === 'approved' ? 'readonly' : 'required'); ?>

                                class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php echo e($vendor->kyc_status === 'approved' ? 'bg-gray-100 cursor-not-allowed' : ''); ?> <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php if($vendor->kyc_status === 'approved'): ?>
                                <p class="text-xs text-gray-600 bg-gray-50 rounded px-2 py-1 mt-2">
                                    <i class="fas fa-lock mr-1"></i>Locked after KYC approval
                                </p>
                            <?php endif; ?>
                            <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3 sm:mb-4">
                            <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                                <i class="fas fa-envelope text-primary mr-2"></i>Email Address
                            </label>
                            <input type="email" value="<?php echo e(auth()->user()->email); ?>" disabled
                                class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 bg-gray-100 cursor-not-allowed text-sm sm:text-base">
                            <p class="text-xs text-gray-600 mt-1">Email cannot be changed</p>
                        </div>

                        <div class="mb-3 sm:mb-4">
                            <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                                <i class="fas fa-phone text-primary mr-2"></i>Phone Number
                            </label>
                            <input type="tel" name="phone" value="<?php echo e(old('phone', auth()->user()->phone)); ?>"
                                placeholder="+234 800 000 0000"
                                class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3 sm:mb-4">
                            <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                                <i class="fab fa-whatsapp text-green-600 mr-2"></i>WhatsApp Number
                            </label>
                            <input type="tel" name="whatsapp_number" 
                                value="<?php echo e(old('whatsapp_number', $vendor->whatsapp_number)); ?>"
                                placeholder="+234 800 000 0000"
                                class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['whatsapp_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <p class="text-xs text-gray-600 mt-1">
                                <i class="fas fa-info-circle mr-1"></i>Customers can contact you after booking
                            </p>
                            <?php $__errorArgs = ['whatsapp_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <button type="submit" class="w-full sm:w-auto bg-gradient-to-r from-primary to-primary-dark text-white px-6 sm:px-8 py-2.5 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                        <i class="fas fa-save mr-2"></i>Update Profile
                    </button>
                </form>
            </div>

            <!-- Bank Details -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-green-100 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4 flex-shrink-0">
                        <i class="fas fa-university text-green-600 text-xl sm:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl text-gray-800">Bank Details</h2>
                        <p class="text-xs sm:text-sm text-gray-600">For receiving payouts</p>
                    </div>
                </div>

                <form method="POST" action="<?php echo e(route('vendor.profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <?php
                        // Pre-fill with car rental bank details if available and main bank details are empty
                        $bankName = old('bank_name', $vendor->bank_name ?: ($vendor->offersCarRentals() ? $vendor->car_rental_bank_name : null));
                        $accountNumber = old('account_number', $vendor->account_number ?: ($vendor->offersCarRentals() ? $vendor->car_rental_account_number : null));
                        $accountName = old('account_name', $vendor->account_name ?: ($vendor->offersCarRentals() ? $vendor->car_rental_account_name : null));
                    ?>

                    <?php if($vendor->offersCarRentals() && !$vendor->bank_name && $vendor->car_rental_bank_name): ?>
                        <div class="bg-blue-50 border-l-4 border-blue-500 p-3 sm:p-4 mb-3 sm:mb-4 rounded">
                            <p class="text-xs sm:text-sm text-blue-800">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Auto-filled:</strong> Bank details from your car rental KYC submission
                            </p>
                        </div>
                    <?php endif; ?>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-landmark text-green-600 mr-2"></i>Bank Name *
                        </label>
                        <input type="text" name="bank_name" 
                            value="<?php echo e($bankName); ?>"
                            placeholder="e.g. Access Bank, GTBank"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-green-500 focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['bank_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['bank_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-hashtag text-green-600 mr-2"></i>Account Number *
                        </label>
                        <input type="text" name="account_number" 
                            value="<?php echo e($accountNumber); ?>"
                            placeholder="0123456789"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-green-500 focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-user-check text-green-600 mr-2"></i>Account Name *
                        </label>
                        <input type="text" name="account_name" 
                            value="<?php echo e($accountName); ?>"
                            placeholder="Account holder name"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-green-500 focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-2 sm:p-3 mt-2 rounded">
                            <p class="text-xs text-yellow-800">
                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                <strong>Important:</strong> Must match your legal/business name on KYC documents
                            </p>
                        </div>
                        <?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <button type="submit" class="w-full bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-2.5 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                        <i class="fas fa-save mr-2"></i>Update Bank Details
                    </button>
                </form>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-4 sm:space-y-6">
            <!-- Account Summary -->
            <div class="bg-gradient-to-br from-primary to-primary-dark rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 text-white">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-chart-line mr-2"></i>Account Summary
                </h3>
                <div class="space-y-2 sm:space-y-3">
                    <div class="flex justify-between items-center pb-2 sm:pb-3 border-b border-white/20">
                        <span class="text-xs sm:text-sm opacity-90">Total Properties</span>
                        <span class="font-bold text-lg sm:text-xl"><?php echo e($vendor->properties()->count()); ?></span>
                    </div>
                    <div class="flex justify-between items-center pb-2 sm:pb-3 border-b border-white/20">
                        <span class="text-xs sm:text-sm opacity-90">Total Earnings</span>
                        <span class="font-bold text-lg sm:text-xl">₦<?php echo e(number_format($vendor->total_earned)); ?></span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs sm:text-sm opacity-90">KYC Status</span>
                        <span class="px-2 sm:px-3 py-1 rounded-full text-xs font-bold
                            <?php echo e($vendor->kyc_status === 'approved' ? 'bg-green-500' : 
                               ($vendor->kyc_status === 'pending' ? 'bg-yellow-500' : 'bg-gray-500')); ?>">
                            <?php echo e(ucfirst($vendor->kyc_status ?? 'Not Submitted')); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Transaction PIN -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-primary/10 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4 flex-shrink-0">
                        <i class="fas fa-shield-alt text-primary text-xl sm:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl text-gray-800">Transaction PIN</h2>
                        <p class="text-xs sm:text-sm text-gray-600"><?php echo e($vendor->transaction_pin ? 'Change' : 'Set'); ?> your 4-digit PIN</p>
                    </div>
                </div>

                <?php if($vendor->transaction_pin): ?>
                    <div class="bg-green-50 border-l-4 border-green-400 p-3 sm:p-4 mb-3 sm:mb-4 rounded">
                        <p class="text-xs sm:text-sm text-green-800">
                            <i class="fas fa-check-circle mr-2"></i>
                            PIN set on <?php echo e($vendor->pin_set_at->format('M d, Y')); ?>

                        </p>
                    </div>
                <?php else: ?>
                    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-3 sm:p-4 mb-3 sm:mb-4 rounded">
                        <p class="text-xs sm:text-sm text-yellow-800">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            <strong>Important:</strong> Set a PIN to secure your payout transactions
                        </p>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('vendor.profile.pin.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <?php if($vendor->transaction_pin): ?>
                        <div class="mb-3 sm:mb-4">
                            <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                                <i class="fas fa-lock text-primary mr-2"></i>Current PIN *
                            </label>
                            <input type="password" name="current_pin" required maxlength="4" pattern="\d{4}"
                                placeholder="Enter current 4-digit PIN"
                                class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['current_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['current_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-key text-primary mr-2"></i><?php echo e($vendor->transaction_pin ? 'New' : ''); ?> PIN *
                        </label>
                        <input type="password" name="transaction_pin" required maxlength="4" pattern="\d{4}"
                            placeholder="Enter 4-digit PIN"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['transaction_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <p class="text-xs text-gray-600 mt-1">Must be exactly 4 digits (0-9)</p>
                        <?php $__errorArgs = ['transaction_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-key text-primary mr-2"></i>Confirm PIN *
                        </label>
                        <input type="password" name="transaction_pin_confirmation" required maxlength="4" pattern="\d{4}"
                            placeholder="Confirm 4-digit PIN"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base">
                    </div>

                    <div class="bg-blue-50 border-l-4 border-blue-400 p-2 sm:p-3 mb-3 sm:mb-4 rounded">
                        <p class="text-xs text-blue-800">
                            <i class="fas fa-info-circle mr-1"></i>
                            If you forget your PIN, contact customer support for a reset
                        </p>
                    </div>

                    <button type="submit" class="w-full bg-gradient-to-r from-primary to-primary-dark text-white px-6 py-2.5 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                        <i class="fas fa-save mr-2"></i><?php echo e($vendor->transaction_pin ? 'Change' : 'Set'); ?> PIN
                    </button>
                </form>
            </div>

            <!-- Change Password -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-red-100 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4 flex-shrink-0">
                        <i class="fas fa-key text-red-600 text-xl sm:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl text-gray-800">Password</h2>
                        <p class="text-xs sm:text-sm text-gray-600">Change your account password</p>
                    </div>
                </div>

                <form method="POST" action="<?php echo e(route('vendor.profile.password.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-lock text-red-600 mr-2"></i>Current Password *
                        </label>
                        <input type="password" name="current_password" required
                            placeholder="Enter current password"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-red-500 focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-lock text-red-600 mr-2"></i>New Password *
                        </label>
                        <input type="password" name="password" required
                            placeholder="Enter new password"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-red-500 focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-lock text-red-600 mr-2"></i>Confirm New Password *
                        </label>
                        <input type="password" name="password_confirmation" required
                            placeholder="Confirm new password"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-red-500 focus:outline-none transition text-sm sm:text-base">
                    </div>

                    <button type="submit" class="w-full bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-2.5 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                        <i class="fas fa-shield-alt mr-2"></i>Change Password
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/profile/edit.blade.php ENDPATH**/ ?>