<?php $__env->startSection('title', 'Bank Transfer Instructions - Car Booking'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-4 sm:py-8">
    <div class="container mx-auto px-3 sm:px-4 max-w-4xl">
        <!-- Header -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 md:p-8 mb-4 sm:mb-6">
            <div class="text-center mb-4 sm:mb-6">
                <div class="bg-green-100 rounded-full w-16 h-16 sm:w-20 sm:h-20 flex items-center justify-center mx-auto mb-3 sm:mb-4">
                    <i class="fas fa-university text-green-600 text-3xl sm:text-4xl"></i>
                </div>
                <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-2 text-gray-800">Complete Your Bank Transfer</h1>
                <p class="text-gray-600 text-sm sm:text-base">Follow the instructions below to complete your car rental payment</p>
            </div>

            <?php
                $bankTransferMethod = \App\Models\PaymentMethod::where('slug', 'bank_transfer')->first();
                $settings = $bankTransferMethod->settings ?? [];
            ?>

            <!-- Bank Details -->
            <div class="bg-gradient-to-br from-green-50 to-teal-50 border-2 border-green-200 rounded-lg sm:rounded-xl p-4 sm:p-6 mb-4 sm:mb-6">
                <h2 class="font-bold text-lg sm:text-xl mb-3 sm:mb-4 text-green-900 flex items-center">
                    <i class="fas fa-building mr-2"></i>Transfer to this Account:
                </h2>
                
                <div class="space-y-3 sm:space-y-4">
                    <div class="bg-white rounded-lg p-3 sm:p-4">
                        <p class="text-xs sm:text-sm text-gray-600 mb-1">Bank Name</p>
                        <p class="font-bold text-base sm:text-lg text-gray-800"><?php echo e($settings['bank_name'] ?? 'N/A'); ?></p>
                    </div>
                    
                    <div class="bg-white rounded-lg p-3 sm:p-4">
                        <p class="text-xs sm:text-sm text-gray-600 mb-1">Account Name</p>
                        <p class="font-bold text-base sm:text-lg text-gray-800 break-words"><?php echo e($settings['account_name'] ?? 'N/A'); ?></p>
                    </div>
                    
                    <div class="bg-white p-3 sm:p-4 rounded-lg border-2 border-green-400 shadow-sm">
                        <p class="text-xs sm:text-sm text-gray-600 mb-2">Account Number</p>
                        <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                            <p class="font-bold text-2xl sm:text-3xl text-green-600 break-all"><?php echo e($settings['account_number'] ?? 'N/A'); ?></p>
                            <button type="button" 
                                onclick="copyAccountNumber('<?php echo e($settings['account_number'] ?? ''); ?>')"
                                class="w-full sm:w-auto bg-green-600 text-white px-4 sm:px-5 py-2 sm:py-3 rounded-lg hover:bg-green-700 transition transform hover:scale-105 text-sm sm:text-base whitespace-nowrap">
                                <i class="fas fa-copy mr-2"></i> Copy
                            </button>
                        </div>
                    </div>
                    
                    <div class="bg-yellow-50 border-2 border-yellow-400 rounded-lg p-3 sm:p-4">
                        <p class="text-xs sm:text-sm text-yellow-800 mb-1"><strong>Amount to Transfer:</strong></p>
                        <p class="text-2xl sm:text-3xl font-bold text-yellow-800">₦<?php echo e(number_format($booking->total_amount, 2)); ?></p>
                    </div>
                </div>
            </div>

            <!-- Car Booking Details -->
            <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                <h3 class="font-bold text-base sm:text-lg text-blue-900 mb-2 sm:mb-3 flex items-center">
                    <i class="fas fa-car mr-2"></i>Booking Details
                </h3>
                <div class="grid md:grid-cols-2 gap-2 sm:gap-3 text-xs sm:text-sm">
                    <div>
                        <p class="text-blue-700"><strong>Car:</strong> <?php echo e($booking->car->full_name); ?></p>
                        <p class="text-blue-700"><strong>Category:</strong> <?php echo e($booking->car->category->name); ?></p>
                    </div>
                    <div>
                        <p class="text-blue-700"><strong>Pickup:</strong> <?php echo e(\Carbon\Carbon::parse($booking->pickup_date)->format('M d, Y')); ?></p>
                        <p class="text-blue-700"><strong>Return:</strong> <?php echo e(\Carbon\Carbon::parse($booking->return_date)->format('M d, Y')); ?></p>
                    </div>
                </div>
            </div>

            <!-- Instructions -->
            <div class="mb-4 sm:mb-6">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4 text-gray-800 flex items-center">
                    <i class="fas fa-list-ol text-green-600 mr-2"></i>Instructions:
                </h3>
                <ol class="list-decimal list-inside space-y-2 sm:space-y-3 text-gray-700 text-sm sm:text-base">
                    <li class="pl-2">Transfer the <strong>exact amount</strong> shown above to the account details provided</li>
                    <li class="pl-2">Use <code class="bg-gray-100 px-2 py-1 rounded font-mono text-xs sm:text-sm break-all"><?php echo e($booking->payment_reference); ?></code> as your transfer reference/narration</li>
                    <li class="pl-2">After completing the transfer, upload proof of payment below</li>
                    <li class="pl-2">Your booking will be confirmed once payment is verified by our team (usually within 24 hours)</li>
                </ol>
            </div>

            <!-- Upload Proof Form -->
            <div class="border-t-2 pt-4 sm:pt-6">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4 text-gray-800 flex items-center">
                    <i class="fas fa-cloud-upload-alt text-green-600 mr-2"></i>Upload Proof of Payment
                </h3>
                
                <form method="POST" action="<?php echo e(route('cars.booking.upload-payment-proof', $booking)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">Payment Proof (Receipt/Screenshot) *</label>
                        <input type="file" name="payment_proof" accept="image/*,.pdf" required
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm focus:border-green-600 focus:outline-none <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <p class="text-xs sm:text-sm text-gray-600 mt-2">
                            <i class="fas fa-info-circle text-blue-500 mr-1"></i>
                            Upload a clear image or PDF of your transfer receipt
                        </p>
                        <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">Additional Notes (Optional)</label>
                        <textarea name="payment_notes" rows="3" 
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-green-600 focus:outline-none"
                            placeholder="Any additional information about your transfer..."></textarea>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                        <button type="submit" 
                            class="flex-1 bg-gradient-to-r from-green-600 to-teal-600 text-white py-3 sm:py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                            <i class="fas fa-upload mr-2"></i> Submit Payment Proof
                        </button>
                        <a href="<?php echo e(route('cars.show', $booking->car)); ?>" 
                            class="flex-1 bg-gray-300 text-gray-700 py-3 sm:py-4 rounded-lg hover:bg-gray-400 text-center font-semibold transition text-sm sm:text-base">
                            I'll Upload Later
                        </a>
                    </div>
                </form>
            </div>

            <!-- Reference Info -->
            <div class="mt-4 sm:mt-6 p-3 sm:p-4 bg-gray-100 rounded-lg text-xs sm:text-sm">
                <div class="grid md:grid-cols-2 gap-2 sm:gap-3">
                    <div>
                        <p class="text-gray-600"><strong>Booking Reference:</strong></p>
                        <p class="font-mono font-semibold text-gray-800 break-all"><?php echo e($booking->booking_reference); ?></p>
                    </div>
                    <div>
                        <p class="text-gray-600"><strong>Payment Reference:</strong></p>
                        <p class="font-mono font-semibold text-gray-800 break-all"><?php echo e($booking->payment_reference); ?></p>
                    </div>
                </div>
                <p class="mt-2 sm:mt-3 text-xs text-gray-600">
                    <i class="fas fa-info-circle text-blue-500 mr-1"></i> 
                    Keep these references for your records. You can also upload proof later from your bookings page.
                </p>
            </div>
        </div>

        <!-- Help Section -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <h3 class="font-bold text-base sm:text-lg mb-2 sm:mb-3 text-gray-800 flex items-center">
                <i class="fas fa-question-circle text-blue-600 mr-2"></i>Need Help?
            </h3>
            <p class="text-gray-600 mb-3 text-sm sm:text-base">If you have any questions or issues with your payment, please contact our support team.</p>
            <div class="flex flex-col sm:flex-row flex-wrap gap-2 sm:gap-3">
                <?php
                    $contactEmail = \App\Models\Setting::get('contact_email', 'support@shortstayng.com');
                    $contactPhone = \App\Models\Setting::get('contact_phone', '+234 800 000 0000');
                    $whatsappNumber = \App\Models\Setting::get('whatsapp_number', $contactPhone);
                ?>
                <a href="mailto:<?php echo e($contactEmail); ?>" class="text-green-600 hover:text-green-700 font-semibold text-sm sm:text-base break-all">
                    <i class="fas fa-envelope mr-1"></i> <?php echo e($contactEmail); ?>

                </a>
                <a href="tel:<?php echo e(str_replace(' ', '', $contactPhone)); ?>" class="text-green-600 hover:text-green-700 font-semibold text-sm sm:text-base">
                    <i class="fas fa-phone mr-1"></i> <?php echo e($contactPhone); ?>

                </a>
                <?php if($whatsappNumber): ?>
                    <a href="https://wa.me/<?php echo e(str_replace(['+', ' '], '', $whatsappNumber)); ?>" target="_blank" class="text-green-600 hover:text-green-700 font-semibold text-sm sm:text-base">
                        <i class="fab fa-whatsapp mr-1"></i> WhatsApp
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function copyAccountNumber(accountNumber) {
    const tempInput = document.createElement('input');
    tempInput.value = accountNumber;
    document.body.appendChild(tempInput);
    tempInput.select();
    
    try {
        document.execCommand('copy');
        
        const button = event.target.closest('button');
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check mr-2"></i> Copied!';
        button.classList.remove('bg-green-600', 'hover:bg-green-700');
        button.classList.add('bg-green-700');
        
        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('bg-green-700');
            button.classList.add('bg-green-600', 'hover:bg-green-700');
        }, 2000);
    } catch (err) {
        alert('Failed to copy. Please copy manually: ' + accountNumber);
    }
    
    document.body.removeChild(tempInput);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/cars/bank-transfer.blade.php ENDPATH**/ ?>