<?php $__env->startSection('title', 'User Details - ' . $user->name); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <a href="<?php echo e(route('admin.all-users.index')); ?>" class="text-primary hover:text-primary-dark font-semibold">
        <i class="fas fa-arrow-left mr-2"></i> Back to All Users
    </a>
</div>

<!-- User Header -->
<div class="bg-white rounded-lg shadow-md p-6 mb-6">
    <div class="flex items-start justify-between">
        <div class="flex items-center">
            <?php if($user->profile_photo): ?>
                <img src="<?php echo e(asset('storage/' . $user->profile_photo)); ?>" 
                    alt="<?php echo e($user->name); ?>"
                    class="w-20 h-20 rounded-full object-cover border-4 border-primary mr-6"
                    onerror="this.onerror=null; this.outerHTML='<div class=\'w-20 h-20 bg-primary rounded-full flex items-center justify-center text-white text-3xl font-bold mr-6\'><?php echo e(substr($user->name, 0, 1)); ?></div>'">
            <?php else: ?>
                <div class="w-20 h-20 bg-primary rounded-full flex items-center justify-center text-white text-3xl font-bold mr-6">
                    <?php echo e(substr($user->name, 0, 1)); ?>

                </div>
            <?php endif; ?>
            <div>
                <h1 class="text-3xl font-bold text-secondary"><?php echo e($user->name); ?></h1>
                <p class="text-gray-600"><?php echo e($user->email); ?></p>
                <?php if($user->phone): ?>
                    <p class="text-gray-600"><i class="fas fa-phone mr-2"></i><?php echo e($user->phone); ?></p>
                <?php endif; ?>
                <div class="flex gap-2 mt-2">
                    <?php if($user->hasRole('vendor')): ?>
                        <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                            <i class="fas fa-store mr-1"></i> Vendor
                        </span>
                    <?php elseif($user->hasAnyRole(['owner', 'manager', 'moderator'])): ?>
                        <span class="px-3 py-1 bg-red-100 text-red-800 rounded-full text-xs font-semibold">
                            <i class="fas fa-shield-alt mr-1"></i> Admin
                        </span>
                    <?php else: ?>
                        <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-semibold">
                            <i class="fas fa-user mr-1"></i> Customer
                        </span>
                    <?php endif; ?>
                    
                    <?php if($user->email_verified_at): ?>
                        <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                            <i class="fas fa-check-circle mr-1"></i> Verified
                        </span>
                    <?php else: ?>
                        <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-semibold">
                            <i class="fas fa-clock mr-1"></i> Unverified
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="text-right">
            <p class="text-sm text-gray-600">Member Since</p>
            <p class="font-semibold"><?php echo e($user->created_at->format('M d, Y')); ?></p>
        </div>
    </div>
</div>

<!-- Statistics -->
<div class="grid md:grid-cols-5 gap-6 mb-6">
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Bookings</p>
                <p class="text-3xl font-bold text-primary"><?php echo e($userStats['total_bookings']); ?></p>
            </div>
            <div class="bg-primary/10 p-3 rounded-full">
                <i class="fas fa-calendar-check text-primary text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Completed</p>
                <p class="text-3xl font-bold text-green-600"><?php echo e($userStats['completed_bookings']); ?></p>
            </div>
            <div class="bg-green-100 p-3 rounded-full">
                <i class="fas fa-check-circle text-green-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Spent</p>
                <p class="text-2xl font-bold text-blue-600">₦<?php echo e(number_format($userStats['total_spent'])); ?></p>
            </div>
            <div class="bg-blue-100 p-3 rounded-full">
                <i class="fas fa-wallet text-blue-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Reviews</p>
                <p class="text-3xl font-bold text-orange-600"><?php echo e($userStats['total_reviews']); ?></p>
            </div>
            <div class="bg-orange-100 p-3 rounded-full">
                <i class="fas fa-star text-orange-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Avg Rating</p>
                <p class="text-3xl font-bold text-yellow-600"><?php echo e(number_format($userStats['average_rating'] ?? 0, 1)); ?></p>
            </div>
            <div class="bg-yellow-100 p-3 rounded-full">
                <i class="fas fa-star-half-alt text-yellow-600 text-xl"></i>
            </div>
        </div>
    </div>
</div>

<!-- Vendor Information -->
<?php if($user->vendor): ?>
<div class="bg-white rounded-lg shadow-md p-6 mb-6">
    <h2 class="text-2xl font-bold mb-4">Vendor Information</h2>
    <div class="grid md:grid-cols-2 gap-6">
        <div>
            <p class="text-sm text-gray-600">Company Name</p>
            <p class="font-semibold"><?php echo e($user->vendor->company_name); ?></p>
        </div>
        <div>
            <p class="text-sm text-gray-600">KYC Status</p>
            <p>
                <?php if($user->vendor->kyc_status === 'approved'): ?>
                    <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                        <i class="fas fa-check-circle mr-1"></i> Approved
                    </span>
                <?php elseif($user->vendor->kyc_status === 'pending'): ?>
                    <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-semibold">
                        <i class="fas fa-clock mr-1"></i> Pending
                    </span>
                <?php elseif($user->vendor->kyc_status === 'rejected'): ?>
                    <span class="px-3 py-1 bg-red-100 text-red-800 rounded-full text-xs font-semibold">
                        <i class="fas fa-times-circle mr-1"></i> Rejected
                    </span>
                <?php else: ?>
                    <span class="px-3 py-1 bg-gray-100 text-gray-800 rounded-full text-xs font-semibold">
                        <i class="fas fa-minus-circle mr-1"></i> Not Submitted
                    </span>
                <?php endif; ?>
            </p>
        </div>
        <div>
            <p class="text-sm text-gray-600">Verified Status</p>
            <p>
                <?php if($user->vendor->verified): ?>
                    <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                        <i class="fas fa-check-circle mr-1"></i> Verified
                    </span>
                <?php else: ?>
                    <span class="px-3 py-1 bg-gray-100 text-gray-800 rounded-full text-xs font-semibold">
                        <i class="fas fa-times-circle mr-1"></i> Not Verified
                    </span>
                <?php endif; ?>
            </p>
        </div>
        <div>
            <p class="text-sm text-gray-600">Total Properties</p>
            <p class="font-semibold"><?php echo e($user->vendor->properties->count()); ?></p>
        </div>
    </div>
    <div class="mt-4">
        <a href="<?php echo e(route('admin.vendors.show', $user->vendor)); ?>" class="text-primary hover:text-primary-dark font-semibold">
            <i class="fas fa-arrow-right mr-2"></i> View Vendor Details
        </a>
    </div>
</div>
<?php endif; ?>

<!-- Recent Bookings -->
<div class="bg-white rounded-lg shadow-md p-6 mb-6">
    <h2 class="text-2xl font-bold mb-4">Recent Bookings</h2>
    
    <?php if($user->bookings->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Property</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Dates</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Amount</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php $__currentLoopData = $user->bookings->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3">
                                <p class="font-semibold"><?php echo e($booking->property->title); ?></p>
                                <p class="text-sm text-gray-600"><?php echo e($booking->property->city); ?></p>
                            </td>
                            <td class="px-4 py-3 text-sm">
                                <?php echo e($booking->start_date->format('M d')); ?> - <?php echo e($booking->end_date->format('M d, Y')); ?>

                                <br>
                                <span class="text-gray-600"><?php echo e($booking->nights_count); ?> nights</span>
                            </td>
                            <td class="px-4 py-3 font-semibold">
                                ₦<?php echo e(number_format($booking->total_amount)); ?>

                            </td>
                            <td class="px-4 py-3">
                                <?php if($booking->booking_status === 'completed'): ?>
                                    <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">Completed</span>
                                <?php elseif($booking->booking_status === 'confirmed'): ?>
                                    <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-semibold">Confirmed</span>
                                <?php elseif($booking->booking_status === 'cancelled'): ?>
                                    <span class="px-2 py-1 bg-red-100 text-red-800 rounded-full text-xs font-semibold">Cancelled</span>
                                <?php else: ?>
                                    <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-semibold">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3">
                                <a href="<?php echo e(route('admin.bookings.show', $booking)); ?>" class="text-primary hover:text-primary-dark font-semibold text-sm">
                                    <i class="fas fa-eye mr-1"></i> View
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p class="text-gray-500 text-center py-8">No bookings yet</p>
    <?php endif; ?>
</div>

<!-- Recent Reviews -->
<?php if($user->reviews->count() > 0): ?>
<div class="bg-white rounded-lg shadow-md p-6">
    <h2 class="text-2xl font-bold mb-4">Recent Reviews</h2>
    
    <div class="space-y-4">
        <?php $__currentLoopData = $user->reviews->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border-b pb-4 last:border-b-0">
                <div class="flex items-start justify-between mb-2">
                    <div>
                        <p class="font-semibold"><?php echo e($review->property->title); ?></p>
                        <div class="flex text-yellow-500 text-sm">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <i class="fas fa-star<?php echo e($i <= $review->rating ? '' : ' text-gray-300'); ?>"></i>
                            <?php endfor; ?>
                        </div>
                    </div>
                    <span class="text-sm text-gray-600"><?php echo e($review->created_at->format('M d, Y')); ?></span>
                </div>
                <p class="text-gray-700"><?php echo e($review->comment); ?></p>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/all-users/show.blade.php ENDPATH**/ ?>