<?php $__env->startSection('title', 'Vendor Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h1 class="text-3xl font-bold mb-6">Vendor Dashboard</h1>

    <!-- Stats Overview -->
    <div class="grid md:grid-cols-4 gap-6 mb-8">
        <?php if($offersProperties): ?>
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-gray-600">Total Properties</p>
                    <i class="fas fa-home text-primary text-2xl"></i>
                </div>
                <p class="text-3xl font-bold"><?php echo e($stats['total_properties']); ?></p>
                <p class="text-sm text-gray-500 mt-1"><?php echo e($stats['active_properties']); ?> active</p>
            </div>
        <?php endif; ?>

        <?php if($offersCarRentals): ?>
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex items-center justify-between mb-2">
                    <p class="text-gray-600">Total Cars</p>
                    <i class="fas fa-car text-green-600 text-2xl"></i>
                </div>
                <p class="text-3xl font-bold"><?php echo e($stats['total_cars']); ?></p>
                <p class="text-sm text-gray-500 mt-1"><?php echo e($stats['active_cars']); ?> active</p>
            </div>
        <?php endif; ?>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Bookings</p>
                <i class="fas fa-calendar-check text-green-500 text-2xl"></i>
            </div>
            <p class="text-3xl font-bold"><?php echo e($stats['total_bookings']); ?></p>
            <p class="text-sm text-gray-500 mt-1"><?php echo e($stats['pending_bookings']); ?> pending</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Pending Balance</p>
                <i class="fas fa-wallet text-yellow-500 text-2xl"></i>
            </div>
            <p class="text-3xl font-bold">₦<?php echo e(number_format(auth()->user()->vendor->pending_balance)); ?></p>
            <p class="text-sm text-gray-500 mt-1">Available for payout</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Earned</p>
                <i class="fas fa-money-bill-wave text-primary text-2xl"></i>
            </div>
            <p class="text-3xl font-bold">₦<?php echo e(number_format(auth()->user()->vendor->total_earned)); ?></p>
            <p class="text-sm text-gray-500 mt-1">All-time earnings</p>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid md:grid-cols-3 gap-6 mb-8">
        <?php if($offersProperties): ?>
            <a href="<?php echo e(route('vendor.properties.create')); ?>" 
                class="bg-primary text-white rounded-lg shadow-md p-6 hover:bg-primary-dark transition">
                <i class="fas fa-plus-circle text-3xl mb-3"></i>
                <h3 class="font-bold text-lg">Add New Property</h3>
                <p class="text-sm mt-1 opacity-90">List a new property on ShortStayNG</p>
            </a>
        <?php endif; ?>

        <?php if($offersCarRentals): ?>
            <a href="<?php echo e(route('vendor.cars.create')); ?>" 
                class="bg-green-600 text-white rounded-lg shadow-md p-6 hover:bg-green-700 transition">
                <i class="fas fa-plus-circle text-3xl mb-3"></i>
                <h3 class="font-bold text-lg">Add New Car</h3>
                <p class="text-sm mt-1 opacity-90">List a new car for rental</p>
            </a>
        <?php endif; ?>

        <a href="<?php echo e(route('vendor.bookings.index')); ?>" 
            class="bg-blue-600 text-white rounded-lg shadow-md p-6 hover:bg-blue-700 transition">
            <i class="fas fa-calendar-alt text-3xl mb-3"></i>
            <h3 class="font-bold text-lg">Manage Bookings</h3>
            <p class="text-sm mt-1 opacity-90">View and manage your bookings</p>
        </a>

        <?php if($offersProperties): ?>
            <a href="<?php echo e(route('vendor.ads.index')); ?>" 
                class="bg-yellow-600 text-white rounded-lg shadow-md p-6 hover:bg-yellow-700 transition">
                <i class="fas fa-bullhorn text-3xl mb-3"></i>
                <h3 class="font-bold text-lg">Promote Property</h3>
                <p class="text-sm mt-1 opacity-90">Feature your property with ads</p>
            </a>
        <?php endif; ?>
    </div>

    <!-- Recent Bookings -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="font-bold text-xl mb-4">Recent Bookings</h2>
        
        <?php $__empty_1 = true; $__currentLoopData = $recentBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div>
                        <?php if(isset($booking->property)): ?>
                            
                            <div class="flex items-center gap-2 mb-1">
                                <i class="fas fa-home text-primary"></i>
                                <h3 class="font-semibold"><?php echo e($booking->property->title); ?></h3>
                            </div>
                            <p class="text-sm text-gray-600">Guest: <?php echo e($booking->user->name); ?></p>
                            <p class="text-sm text-gray-600">
                                <?php echo e($booking->start_date->format('M d')); ?> - <?php echo e($booking->end_date->format('M d, Y')); ?>

                            </p>
                        <?php else: ?>
                            
                            <div class="flex items-center gap-2 mb-1">
                                <i class="fas fa-car text-green-600"></i>
                                <h3 class="font-semibold"><?php echo e($booking->car->full_name); ?></h3>
                            </div>
                            <p class="text-sm text-gray-600">Driver: <?php echo e($booking->driver_name); ?></p>
                            <p class="text-sm text-gray-600">
                                <?php echo e(\Carbon\Carbon::parse($booking->pickup_date)->format('M d')); ?> - <?php echo e(\Carbon\Carbon::parse($booking->return_date)->format('M d, Y')); ?>

                            </p>
                        <?php endif; ?>
                    </div>
                    <div class="text-right">
                        <span class="px-3 py-1 rounded-full text-sm
                            <?php if(isset($booking->property)): ?>
                                <?php if($booking->vendor_approval_status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif($booking->vendor_approval_status === 'approved'): ?> bg-green-100 text-green-800
                                <?php else: ?> bg-red-100 text-red-800
                                <?php endif; ?>
                            <?php else: ?>
                                <?php if($booking->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif($booking->status === 'confirmed'): ?> bg-green-100 text-green-800
                                <?php elseif($booking->status === 'active'): ?> bg-blue-100 text-blue-800
                                <?php elseif($booking->status === 'completed'): ?> bg-gray-100 text-gray-800
                                <?php else: ?> bg-red-100 text-red-800
                                <?php endif; ?>
                            <?php endif; ?>">
                            <?php echo e(isset($booking->property) ? ucfirst($booking->vendor_approval_status) : ucfirst($booking->status)); ?>

                        </span>
                        <p class="text-sm font-bold mt-2">₦<?php echo e(number_format($booking->total_amount)); ?></p>
                        <a href="<?php echo e(isset($booking->property) ? route('vendor.bookings.show', $booking) : route('vendor.car-bookings.show', $booking)); ?>" 
                            class="text-primary text-sm hover:underline mt-1 inline-block">View Details</a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-gray-600 text-center py-8">No bookings yet</p>
        <?php endif; ?>
    </div>

    <!-- Top Performing Items -->
    <?php if($offersProperties && $topProperties->count() > 0): ?>
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <h2 class="font-bold text-xl mb-4">Top Performing Properties</h2>
            
            <?php $__currentLoopData = $topProperties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between border-b last:border-b-0 py-3">
                    <div class="flex items-center">
                        <img src="<?php echo e(isset($property->photos[0]) ? asset('storage/' . $property->photos[0]) : '/images/placeholder.jpg'); ?>" 
                            class="w-16 h-16 object-cover rounded mr-4">
                        <div>
                            <h3 class="font-semibold"><?php echo e($property->title); ?></h3>
                            <p class="text-sm text-gray-600"><?php echo e($property->bookings_count); ?> bookings</p>
                        </div>
                    </div>
                    <a href="<?php echo e(route('vendor.properties.edit', $property)); ?>" 
                        class="text-primary hover:underline">Edit</a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <?php if($offersCarRentals && $topCars->count() > 0): ?>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h2 class="font-bold text-xl mb-4">Top Performing Cars</h2>
            
            <?php $__currentLoopData = $topCars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between border-b last:border-b-0 py-3">
                    <div class="flex items-center">
                        <img src="<?php echo e($car->main_photo ? asset('storage/' . $car->main_photo) : '/images/placeholder.jpg'); ?>" 
                            class="w-16 h-16 object-cover rounded mr-4">
                        <div>
                            <h3 class="font-semibold"><?php echo e($car->full_name); ?></h3>
                            <p class="text-sm text-gray-600"><?php echo e($car->bookings_count); ?> bookings</p>
                        </div>
                    </div>
                    <a href="<?php echo e(route('vendor.cars.edit', $car)); ?>" 
                        class="text-primary hover:underline">Edit</a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <?php if((!$offersProperties || $topProperties->count() === 0) && (!$offersCarRentals || $topCars->count() === 0)): ?>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h2 class="font-bold text-xl mb-4">Top Performing Items</h2>
            <p class="text-gray-600 text-center py-8">No listings yet</p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/dashboard.blade.php ENDPATH**/ ?>