
<?php
    $languages = \App\Models\Language::active();
    $currentLocale = app()->getLocale();
    $currentLanguage = $languages->firstWhere('code', $currentLocale);
?>

<?php if($languages->count() > 1): ?>
<div class="relative inline-block text-left" x-data="{ open: false }">
    <div>
        <button @click="open = !open" type="button" 
                class="inline-flex items-center justify-center w-full rounded-md border border-gray-300 shadow-sm px-3 py-2 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary"
                id="language-menu-button" aria-expanded="true" aria-haspopup="true">
            <span class="mr-2"><?php echo e($currentLanguage->flag ?? '🌐'); ?></span>
            <span class="hidden md:inline"><?php echo e($currentLanguage->name ?? 'Language'); ?></span>
            <span class="md:hidden"><?php echo e($currentLanguage->code ?? 'EN'); ?></span>
            <svg class="ml-2 -mr-1 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </div>

    <div x-show="open" 
         @click.away="open = false"
         x-transition:enter="transition ease-out duration-100"
         x-transition:enter-start="transform opacity-0 scale-95"
         x-transition:enter-end="transform opacity-100 scale-100"
         x-transition:leave="transition ease-in duration-75"
         x-transition:leave-start="transform opacity-100 scale-100"
         x-transition:leave-end="transform opacity-0 scale-95"
         class="origin-top-right absolute right-0 mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 divide-y divide-gray-100 focus:outline-none z-50"
         role="menu" aria-orientation="vertical" aria-labelledby="language-menu-button" tabindex="-1"
         style="display: none;">
        <div class="py-1" role="none">
            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('language.switch', $language->code)); ?>" 
                   class="group flex items-center px-4 py-2 text-sm <?php echo e($language->code === $currentLocale ? 'bg-gray-100 text-gray-900 font-semibold' : 'text-gray-700 hover:bg-gray-50 hover:text-gray-900'); ?>"
                   role="menuitem" tabindex="-1">
                    <span class="mr-3 text-xl"><?php echo e($language->flag); ?></span>
                    <span class="flex-1"><?php echo e($language->name); ?></span>
                    <?php if($language->code === $currentLocale): ?>
                        <svg class="h-5 w-5 text-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                        </svg>
                    <?php endif; ?>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>


<?php if (! $__env->hasRenderedOnce('06eedb71-ad2c-449c-8481-9b5fd089bd31')): $__env->markAsRenderedOnce('06eedb71-ad2c-449c-8481-9b5fd089bd31'); ?>
    <?php $__env->startPush('scripts'); ?>
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php endif; ?>
<?php /**PATH /Users/mac/ShortStayNG/resources/views/components/language-selector.blade.php ENDPATH**/ ?>