<?php $__env->startSection('title', 'Discount Deals'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-3xl font-bold text-secondary">Discount Deals</h1>
            <p class="text-gray-600 mt-1">Manage user booking discount codes</p>
        </div>
        <a href="<?php echo e(route('admin.discount-deals.create')); ?>" 
            class="bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark transition flex items-center">
            <i class="fas fa-plus mr-2"></i> Create Discount Deal
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded">
            <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded">
            <i class="fas fa-exclamation-circle mr-2"></i><?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <!-- Discount Deals Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Code</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Discount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Usage</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Valid Until</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $discountDeals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="font-mono font-bold text-primary"><?php echo e($deal->code); ?></span>
                            <?php if($deal->is_featured): ?>
                                <span class="ml-2 px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-star"></i> Featured
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($deal->name); ?></div>
                            <?php if($deal->description): ?>
                                <div class="text-xs text-gray-500"><?php echo e(Str::limit($deal->description, 50)); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($deal->discount_type === 'percentage'): ?>
                                <span class="text-green-600 font-semibold"><?php echo e($deal->discount_value); ?>% OFF</span>
                                <?php if($deal->max_discount_amount): ?>
                                    <div class="text-xs text-gray-500">Max: ₦<?php echo e(number_format($deal->max_discount_amount)); ?></div>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-green-600 font-semibold">₦<?php echo e(number_format($deal->discount_value)); ?> OFF</span>
                            <?php endif; ?>
                            <?php if($deal->min_booking_amount > 0): ?>
                                <div class="text-xs text-gray-500">Min: ₦<?php echo e(number_format($deal->min_booking_amount)); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                <?php echo e($deal->usage_count); ?> / <?php echo e($deal->usage_limit ?? '∞'); ?>

                            </div>
                            <div class="text-xs text-gray-500">
                                <?php echo e($deal->usage_per_user); ?>x per user
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <?php if($deal->valid_until): ?>
                                <?php echo e($deal->valid_until->format('M d, Y')); ?>

                                <?php if($deal->valid_until->isPast()): ?>
                                    <span class="text-red-500">(Expired)</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-gray-400">No expiry</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($deal->is_active && $deal->isValid()): ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                    Active
                                </span>
                            <?php elseif($deal->is_active): ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                    Scheduled
                                </span>
                            <?php else: ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                                    Inactive
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-2">
                                <a href="<?php echo e(route('admin.discount-deals.edit', $deal)); ?>" 
                                    class="text-blue-600 hover:text-blue-900" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <form action="<?php echo e(route('admin.discount-deals.toggle', $deal)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" 
                                        class="<?php echo e($deal->is_active ? 'text-yellow-600 hover:text-yellow-900' : 'text-green-600 hover:text-green-900'); ?>"
                                        title="<?php echo e($deal->is_active ? 'Deactivate' : 'Activate'); ?>">
                                        <i class="fas fa-<?php echo e($deal->is_active ? 'pause' : 'play'); ?>-circle"></i>
                                    </button>
                                </form>
                                
                                <form action="<?php echo e(route('admin.discount-deals.toggle-featured', $deal)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" 
                                        class="<?php echo e($deal->is_featured ? 'text-yellow-600 hover:text-yellow-900' : 'text-gray-400 hover:text-yellow-600'); ?>"
                                        title="<?php echo e($deal->is_featured ? 'Unfeature' : 'Feature'); ?>">
                                        <i class="fas fa-star"></i>
                                    </button>
                                </form>
                                
                                <?php if($deal->usage_count == 0): ?>
                                    <form action="<?php echo e(route('admin.discount-deals.destroy', $deal)); ?>" method="POST" 
                                        class="inline" onsubmit="return confirm('Are you sure you want to delete this discount deal?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-900" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-tags text-4xl mb-4 text-gray-300"></i>
                            <p class="text-lg">No discount deals found</p>
                            <a href="<?php echo e(route('admin.discount-deals.create')); ?>" class="text-primary hover:underline mt-2 inline-block">
                                Create your first discount deal
                            </a>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if($discountDeals->hasPages()): ?>
        <div class="mt-6">
            <?php echo e($discountDeals->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/discount-deals/index.blade.php ENDPATH**/ ?>