<?php $__env->startSection('title', 'Create FAQ'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <!-- Header -->
    <div class="mb-6">
        <a href="<?php echo e(route('admin.faqs.index')); ?>" class="text-primary hover:underline mb-2 inline-block">
            <i class="fas fa-arrow-left mr-2"></i>Back to FAQs
        </a>
        <h1 class="text-3xl font-bold text-secondary">Create FAQ</h1>
        <p class="text-gray-600 mt-1">Add a new frequently asked question</p>
    </div>

    <?php if($errors->any()): ?>
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded">
            <p class="font-bold mb-2">Please fix the following errors:</p>
            <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.faqs.store')); ?>" method="POST" class="bg-white rounded-lg shadow-md p-6">
        <?php echo csrf_field(); ?>

        <!-- Question -->
        <div class="mb-6">
            <label for="question" class="block text-sm font-medium text-gray-700 mb-2">
                Question <span class="text-red-500">*</span>
            </label>
            <input type="text" name="question" id="question" value="<?php echo e(old('question')); ?>" required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                placeholder="e.g., How do I book a property?">
        </div>

        <!-- Answer -->
        <div class="mb-6">
            <label for="answer" class="block text-sm font-medium text-gray-700 mb-2">
                Answer <span class="text-red-500">*</span>
            </label>
            <textarea name="answer" id="answer" rows="6" required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                placeholder="Provide a detailed answer..."><?php echo e(old('answer')); ?></textarea>
            <p class="text-xs text-gray-500 mt-1">You can use line breaks for better formatting</p>
        </div>

        <!-- Category -->
        <div class="mb-6">
            <label for="category" class="block text-sm font-medium text-gray-700 mb-2">
                Category <span class="text-red-500">*</span>
            </label>
            <select name="category" id="category" required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php echo e(old('category') == $key ? 'selected' : ''); ?>>
                        <?php echo e($label); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <!-- Display Order -->
        <div class="mb-6">
            <label for="display_order" class="block text-sm font-medium text-gray-700 mb-2">
                Display Order
            </label>
            <input type="number" name="display_order" id="display_order" value="<?php echo e(old('display_order', 0)); ?>" min="0"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                placeholder="0">
            <p class="text-xs text-gray-500 mt-1">Lower numbers appear first (0 = highest priority)</p>
        </div>

        <!-- Is Active -->
        <div class="mb-6">
            <label class="flex items-center">
                <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>

                    class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                <span class="ml-2 text-sm text-gray-700">Active (visible on FAQ page)</span>
            </label>
        </div>

        <!-- Submit Buttons -->
        <div class="flex justify-end space-x-4 pt-6 border-t">
            <a href="<?php echo e(route('admin.faqs.index')); ?>" 
                class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">
                Cancel
            </a>
            <button type="submit" 
                class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark transition">
                <i class="fas fa-save mr-2"></i>Create FAQ
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/faqs/create.blade.php ENDPATH**/ ?>