<?php $__env->startSection('title', 'Car Bookings'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-calendar-check mr-3"></i>Car Bookings
                    </h1>
                    <p class="text-blue-100">Manage all car rental bookings</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                    <i class="fas fa-clipboard-list text-4xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid md:grid-cols-6 gap-4 mb-8">
        <div class="bg-white rounded-xl shadow-md p-4 border-l-4 border-blue-500">
            <p class="text-gray-600 text-xs font-semibold mb-1">Total</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['total']); ?></p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-4 border-l-4 border-yellow-500">
            <p class="text-gray-600 text-xs font-semibold mb-1">Pending</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['pending']); ?></p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-4 border-l-4 border-green-500">
            <p class="text-gray-600 text-xs font-semibold mb-1">Confirmed</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['confirmed']); ?></p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-4 border-l-4 border-indigo-500">
            <p class="text-gray-600 text-xs font-semibold mb-1">Active</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['active']); ?></p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-4 border-l-4 border-teal-500">
            <p class="text-gray-600 text-xs font-semibold mb-1">Completed</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['completed']); ?></p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-4 border-l-4 border-red-500">
            <p class="text-gray-600 text-xs font-semibold mb-1">Cancelled</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['cancelled']); ?></p>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
        <form method="GET" action="<?php echo e(route('admin.car-bookings.index')); ?>" class="flex flex-wrap gap-4">
            <div class="flex-1 min-w-[200px]">
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                    placeholder="Search by reference, driver name, or phone..."
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-2">
            </div>
            
            <select name="status" class="border-2 border-gray-300 rounded-lg px-4 py-2">
                <option value="">All Status</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="confirmed" <?php echo e(request('status') == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
            </select>

            <select name="payment_status" class="border-2 border-gray-300 rounded-lg px-4 py-2">
                <option value="">All Payments</option>
                <option value="pending" <?php echo e(request('payment_status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="paid" <?php echo e(request('payment_status') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                <option value="failed" <?php echo e(request('payment_status') == 'failed' ? 'selected' : ''); ?>>Failed</option>
            </select>

            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition">
                <i class="fas fa-search mr-2"></i>Filter
            </button>
            
            <a href="<?php echo e(route('admin.car-bookings.index')); ?>" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition">
                <i class="fas fa-redo mr-2"></i>Reset
            </a>
        </form>
    </div>

    <!-- Bookings Table -->
    <?php if($bookings->count() > 0): ?>
        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white">
                        <tr>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Reference</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Car</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Driver</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Dates</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Amount</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Status</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Payment</th>
                            <th class="px-6 py-4 text-center text-sm font-semibold">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50 transition">
                            <td class="px-6 py-4">
                                <p class="font-bold text-gray-800"><?php echo e($booking->booking_reference); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($booking->created_at->format('M d, Y')); ?></p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="font-semibold text-gray-800"><?php echo e($booking->car->full_name); ?></p>
                                <p class="text-xs text-gray-600"><?php echo e($booking->car->plate_number); ?></p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="font-semibold text-gray-800"><?php echo e($booking->driver_name); ?></p>
                                <p class="text-xs text-gray-600"><?php echo e($booking->driver_phone); ?></p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-sm text-gray-800"><?php echo e($booking->pickup_date->format('M d, Y')); ?></p>
                                <p class="text-xs text-gray-600">to <?php echo e($booking->return_date->format('M d, Y')); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($booking->total_days); ?> days</p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-lg font-bold text-green-600">₦<?php echo e(number_format($booking->total_amount)); ?></p>
                            </td>
                            <td class="px-6 py-4">
                                <?php if($booking->status === 'completed'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-teal-100 text-teal-800">
                                        <i class="fas fa-check-circle mr-2"></i>Completed
                                    </span>
                                <?php elseif($booking->status === 'active'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-indigo-100 text-indigo-800">
                                        <i class="fas fa-car mr-2"></i>Active
                                    </span>
                                <?php elseif($booking->status === 'confirmed'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-green-100 text-green-800">
                                        <i class="fas fa-check mr-2"></i>Confirmed
                                    </span>
                                <?php elseif($booking->status === 'cancelled'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-red-100 text-red-800">
                                        <i class="fas fa-times-circle mr-2"></i>Cancelled
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-2"></i>Pending
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4">
                                <?php if($booking->payment_status === 'paid'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-green-100 text-green-800">
                                        <i class="fas fa-check-circle mr-2"></i>Paid
                                    </span>
                                <?php elseif($booking->payment_status === 'failed'): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-red-100 text-red-800">
                                        <i class="fas fa-times-circle mr-2"></i>Failed
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-2"></i>Pending
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-center space-x-2">
                                    <a href="<?php echo e(route('admin.car-bookings.show', $booking)); ?>" 
                                        class="bg-blue-500 text-white px-3 py-2 rounded-lg hover:bg-blue-600 transition text-sm">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 bg-gray-50">
                <?php echo e($bookings->links()); ?>

            </div>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-xl shadow-lg p-12 text-center">
            <div class="bg-gray-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-calendar-check text-gray-400 text-4xl"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-800 mb-3">No Bookings Found</h3>
            <p class="text-gray-600">No bookings match your current filters</p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/car-bookings/index.blade.php ENDPATH**/ ?>