<?php $__env->startSection('title', 'Add House Type Image'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-4 py-8 max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center mb-4">
            <a href="<?php echo e(route('admin.house-types.index')); ?>" 
                class="text-gray-600 hover:text-gray-800 mr-4">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h1 class="text-3xl font-bold text-gray-800">
                <i class="fas fa-home text-indigo-600 mr-3"></i>Add House Type Image
            </h1>
        </div>
        <p class="text-gray-600">Upload a banner image for a house type</p>
    </div>

    <!-- Form -->
    <form method="POST" action="<?php echo e(route('admin.house-types.store')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="bg-white rounded-xl shadow-lg p-8">
            <!-- House Type Selection -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-tag text-indigo-600 mr-2"></i>House Type *
                </label>
                <?php if($availableTypes->count() > 0): ?>
                    <select name="house_type" 
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-indigo-600 focus:outline-none transition <?php $__errorArgs = ['house_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        required>
                        <option value="">Select House Type</option>
                        <?php $__currentLoopData = $availableTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type); ?>" <?php echo e(old('house_type') === $type ? 'selected' : ''); ?>>
                                <?php echo e($type); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['house_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php else: ?>
                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded-lg">
                        <div class="flex items-start">
                            <i class="fas fa-exclamation-triangle text-yellow-600 text-xl mr-3 mt-1"></i>
                            <div>
                                <p class="text-yellow-800 font-semibold mb-2">No Available House Types</p>
                                <p class="text-yellow-700 text-sm">
                                    All house types from your properties already have images. 
                                    You can edit existing ones or add new properties with different house types.
                                </p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($availableTypes->count() > 0): ?>
                <!-- Image Upload -->
                <div class="mb-6">
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-image text-indigo-600 mr-2"></i>Banner Image *
                    </label>
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-indigo-600 transition">
                        <input type="file" 
                            name="image" 
                            id="imageInput"
                            accept="image/*"
                            class="hidden"
                            onchange="previewImage(event)"
                            required>
                        <label for="imageInput" class="cursor-pointer">
                            <div id="imagePreview" class="mb-4">
                                <i class="fas fa-cloud-upload-alt text-6xl text-gray-400"></i>
                            </div>
                            <p class="text-gray-600 mb-2">Click to upload house type banner image</p>
                            <p class="text-sm text-gray-500">Recommended: 800x600px, Max 5MB (JPG, PNG, WebP)</p>
                        </label>
                    </div>
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Description -->
                <div class="mb-6">
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-align-left text-indigo-600 mr-2"></i>Description (Optional)
                    </label>
                    <textarea name="description" 
                        rows="3" 
                        maxlength="500"
                        placeholder="Brief description of this house type..."
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-indigo-600 focus:outline-none transition <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('description')); ?></textarea>
                    <p class="text-sm text-gray-500 mt-1">Maximum 500 characters</p>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Active Status -->
                <div class="mb-6">
                    <label class="flex items-center cursor-pointer">
                        <input type="checkbox" 
                            name="active" 
                            value="1"
                            <?php echo e(old('active', true) ? 'checked' : ''); ?>

                            class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                        <span class="ml-3 text-gray-700 font-semibold">
                            <i class="fas fa-eye text-indigo-600 mr-2"></i>Show on Homepage
                        </span>
                    </label>
                </div>

                <!-- Submit Buttons -->
                <div class="flex items-center justify-end space-x-4 pt-6 border-t">
                    <a href="<?php echo e(route('admin.house-types.index')); ?>" 
                        class="px-6 py-3 border-2 border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 font-semibold transition">
                        Cancel
                    </a>
                    <button type="submit" 
                        class="px-8 py-3 bg-gradient-to-r from-indigo-600 to-indigo-800 text-white rounded-lg hover:shadow-lg font-semibold transition transform hover:scale-105">
                        <i class="fas fa-save mr-2"></i>Create House Type Image
                    </button>
                </div>
            <?php else: ?>
                <div class="flex items-center justify-end pt-6 border-t">
                    <a href="<?php echo e(route('admin.house-types.index')); ?>" 
                        class="px-6 py-3 bg-gray-600 text-white rounded-lg hover:bg-gray-700 font-semibold transition">
                        <i class="fas fa-arrow-left mr-2"></i>Back to List
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </form>
</div>

<script>
function previewImage(event) {
    const preview = document.getElementById('imagePreview');
    const file = event.target.files[0];
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.innerHTML = `<img src="${e.target.result}" class="max-w-full h-64 object-cover rounded-lg mx-auto">`;
        }
        reader.readAsDataURL(file);
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/house-types/create.blade.php ENDPATH**/ ?>