<?php $__env->startSection('title', 'Transactions'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Header -->
    <div class="mb-6 sm:mb-8">
        <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                <i class="fas fa-receipt mr-2 sm:mr-3"></i>Transaction History
            </h1>
            <p class="text-xs sm:text-sm text-green-100">Track all your earnings and payouts</p>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3 sm:gap-4 md:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-xs sm:text-sm">Total Earnings</p>
                <i class="fas fa-arrow-up text-green-600 text-lg sm:text-xl"></i>
            </div>
            <p class="text-2xl sm:text-3xl font-bold text-gray-800">₦<?php echo e(number_format($summary['total_earnings'])); ?></p>
            <p class="text-xs text-gray-500 mt-1">All time</p>
        </div>

        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-xs sm:text-sm">Total Payouts</p>
                <i class="fas fa-arrow-down text-red-600 text-lg sm:text-xl"></i>
            </div>
            <p class="text-2xl sm:text-3xl font-bold text-gray-800">₦<?php echo e(number_format($summary['total_payouts'])); ?></p>
            <p class="text-xs text-gray-500 mt-1">All time</p>
        </div>

        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 sm:col-span-2 md:col-span-1">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-xs sm:text-sm">Pending Balance</p>
                <i class="fas fa-wallet text-blue-600 text-lg sm:text-xl"></i>
            </div>
            <p class="text-2xl sm:text-3xl font-bold text-gray-800">₦<?php echo e(number_format($summary['pending_balance'])); ?></p>
            <p class="text-xs text-gray-500 mt-1">Available for withdrawal</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <form method="GET" action="<?php echo e(route('vendor.transactions.index')); ?>" class="space-y-3 sm:space-y-0 sm:grid sm:grid-cols-2 md:grid-cols-4 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Transaction Type</label>
                <select name="type" class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
                    <option value="all" <?php echo e($type === 'all' ? 'selected' : ''); ?>>All Transactions</option>
                    <option value="earnings" <?php echo e($type === 'earnings' ? 'selected' : ''); ?>>Earnings Only</option>
                    <option value="payouts" <?php echo e($type === 'payouts' ? 'selected' : ''); ?>>Payouts Only</option>
                </select>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Source</label>
                <select name="source" class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
                    <option value="all" <?php echo e($source === 'all' ? 'selected' : ''); ?>>All Sources</option>
                    <option value="property" <?php echo e($source === 'property' ? 'selected' : ''); ?>>Property Bookings</option>
                    <option value="car" <?php echo e($source === 'car' ? 'selected' : ''); ?>>Car Rentals</option>
                    <option value="deposit" <?php echo e($source === 'deposit' ? 'selected' : ''); ?>>Deposit Deductions</option>
                </select>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Start Date</label>
                <input type="date" name="start_date" value="<?php echo e($startDate); ?>" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">End Date</label>
                <input type="date" name="end_date" value="<?php echo e($endDate); ?>" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
            </div>

            <div class="sm:col-span-2 md:col-span-4 flex flex-col sm:flex-row gap-2 sm:gap-3">
                <button type="submit" class="flex-1 sm:flex-none bg-green-600 text-white px-4 sm:px-6 py-2 rounded-lg hover:bg-green-700 font-semibold text-sm sm:text-base transition">
                    <i class="fas fa-filter mr-2"></i>Apply Filters
                </button>
                <a href="<?php echo e(route('vendor.transactions.index')); ?>" class="flex-1 sm:flex-none bg-gray-200 text-gray-700 px-4 sm:px-6 py-2 rounded-lg hover:bg-gray-300 font-semibold text-sm sm:text-base text-center transition">
                    <i class="fas fa-times mr-2"></i>Clear Filters
                </a>
            </div>
        </form>
    </div>

    <!-- Transactions Table/Cards -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg sm:text-xl font-bold text-gray-800">Transaction History</h2>
            <p class="text-xs sm:text-sm text-gray-600 mt-1"><?php echo e($total); ?> transaction(s) found</p>
        </div>

        <?php if($transactions->isEmpty()): ?>
            <div class="p-8 sm:p-12 text-center">
                <i class="fas fa-receipt text-gray-300 text-4xl sm:text-5xl md:text-6xl mb-3 sm:mb-4"></i>
                <p class="text-gray-500 text-base sm:text-lg">No transactions found</p>
                <p class="text-gray-400 text-xs sm:text-sm mt-2">Your transaction history will appear here</p>
            </div>
        <?php else: ?>
            <!-- Mobile Card View (visible on mobile) -->
            <div class="md:hidden divide-y divide-gray-200">
                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-4 hover:bg-gray-50 transition">
                        <div class="flex justify-between items-start mb-3">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-1">
                                    <?php if($transaction['type'] === 'earning'): ?>
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-arrow-up mr-1"></i>Earning
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                            <i class="fas fa-arrow-down mr-1"></i>Payout
                                        </span>
                                    <?php endif; ?>
                                    <span class="text-xs text-gray-500">
                                        <?php if($transaction['source'] === 'property'): ?>
                                            <i class="fas fa-home mr-1"></i>Property
                                        <?php elseif($transaction['source'] === 'car'): ?>
                                            <i class="fas fa-car mr-1"></i>Car
                                        <?php elseif($transaction['source'] === 'deposit'): ?>
                                            <i class="fas fa-shield-alt mr-1"></i>Deposit
                                        <?php else: ?>
                                            <i class="fas fa-money-bill-wave mr-1"></i>Withdrawal
                                        <?php endif; ?>
                                    </span>
                                </div>
                                <p class="font-semibold text-sm text-gray-800"><?php echo e($transaction['description']); ?></p>
                                <?php if(isset($transaction['details']['check_in'])): ?>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <?php echo e(\Carbon\Carbon::parse($transaction['details']['check_in'])->format('M d')); ?> - 
                                        <?php echo e(\Carbon\Carbon::parse($transaction['details']['check_out'])->format('M d, Y')); ?>

                                    </p>
                                <?php elseif(isset($transaction['details']['pickup_date'])): ?>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <?php echo e(\Carbon\Carbon::parse($transaction['details']['pickup_date'])->format('M d')); ?> - 
                                        <?php echo e(\Carbon\Carbon::parse($transaction['details']['return_date'])->format('M d, Y')); ?>

                                    </p>
                                <?php elseif(isset($transaction['details']['bank'])): ?>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <?php echo e($transaction['details']['bank']); ?> - <?php echo e($transaction['details']['account']); ?>

                                    </p>
                                <?php endif; ?>
                            </div>
                            <span class="text-lg font-bold <?php echo e($transaction['type'] === 'earning' ? 'text-green-600' : 'text-red-600'); ?>">
                                <?php echo e($transaction['type'] === 'earning' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction['amount'])); ?>

                            </span>
                        </div>
                        
                        <div class="flex items-center justify-between text-xs text-gray-500">
                            <span><?php echo e(\Carbon\Carbon::parse($transaction['date'])->format('M d, Y h:i A')); ?></span>
                            <?php if($transaction['status'] === 'completed' || $transaction['status'] === 'paid'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full font-semibold bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-1"></i>Completed
                                </span>
                            <?php elseif($transaction['status'] === 'pending'): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full font-semibold bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-clock mr-1"></i>Pending
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full font-semibold bg-blue-100 text-blue-800">
                                    <i class="fas fa-spinner mr-1"></i>Processing
                                </span>
                            <?php endif; ?>
                        </div>
                        
                        <p class="text-xs font-mono text-gray-400 mt-2">Ref: <?php echo e($transaction['reference']); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Desktop Table View (hidden on mobile) -->
            <div class="hidden md:block overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Reference</th>
                            <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-3 text-center text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                    <?php echo e(\Carbon\Carbon::parse($transaction['date'])->format('M d, Y')); ?>

                                    <br>
                                    <span class="text-xs text-gray-400"><?php echo e(\Carbon\Carbon::parse($transaction['date'])->format('h:i A')); ?></span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($transaction['type'] === 'earning'): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-arrow-up mr-1"></i>Earning
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                            <i class="fas fa-arrow-down mr-1"></i>Payout
                                        </span>
                                    <?php endif; ?>
                                    <br>
                                    <span class="text-xs text-gray-500 mt-1">
                                        <?php if($transaction['source'] === 'property'): ?>
                                            <i class="fas fa-home mr-1"></i>Property
                                        <?php elseif($transaction['source'] === 'car'): ?>
                                            <i class="fas fa-car mr-1"></i>Car Rental
                                        <?php elseif($transaction['source'] === 'deposit'): ?>
                                            <i class="fas fa-shield-alt mr-1"></i>Deposit
                                        <?php else: ?>
                                            <i class="fas fa-money-bill-wave mr-1"></i>Withdrawal
                                        <?php endif; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-800">
                                    <p class="font-semibold"><?php echo e($transaction['description']); ?></p>
                                    <?php if(isset($transaction['details']['check_in'])): ?>
                                        <p class="text-xs text-gray-500 mt-1">
                                            <?php echo e(\Carbon\Carbon::parse($transaction['details']['check_in'])->format('M d')); ?> - 
                                            <?php echo e(\Carbon\Carbon::parse($transaction['details']['check_out'])->format('M d, Y')); ?>

                                        </p>
                                    <?php elseif(isset($transaction['details']['pickup_date'])): ?>
                                        <p class="text-xs text-gray-500 mt-1">
                                            <?php echo e(\Carbon\Carbon::parse($transaction['details']['pickup_date'])->format('M d')); ?> - 
                                            <?php echo e(\Carbon\Carbon::parse($transaction['details']['return_date'])->format('M d, Y')); ?>

                                        </p>
                                    <?php elseif(isset($transaction['details']['bank'])): ?>
                                        <p class="text-xs text-gray-500 mt-1">
                                            <?php echo e($transaction['details']['bank']); ?> - <?php echo e($transaction['details']['account']); ?>

                                        </p>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-xs font-mono text-gray-600"><?php echo e($transaction['reference']); ?></span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right">
                                    <span class="text-lg font-bold <?php echo e($transaction['type'] === 'earning' ? 'text-green-600' : 'text-red-600'); ?>">
                                        <?php echo e($transaction['type'] === 'earning' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction['amount'])); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <?php if($transaction['status'] === 'completed' || $transaction['status'] === 'paid'): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>Completed
                                        </span>
                                    <?php elseif($transaction['status'] === 'pending'): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-yellow-100 text-yellow-800">
                                            <i class="fas fa-clock mr-1"></i>Pending
                                        </span>
                                    <?php elseif($transaction['status'] === 'processing'): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-blue-100 text-blue-800">
                                            <i class="fas fa-spinner mr-1"></i>Processing
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-gray-100 text-gray-800">
                                            <?php echo e(ucfirst($transaction['status'])); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if($total > $perPage): ?>
                <div class="px-4 sm:px-6 py-3 sm:py-4 border-t bg-gray-50">
                    <div class="flex flex-col sm:flex-row items-center justify-between gap-3">
                        <p class="text-xs sm:text-sm text-gray-600 text-center sm:text-left">
                            Showing <?php echo e(($currentPage - 1) * $perPage + 1); ?> to <?php echo e(min($currentPage * $perPage, $total)); ?> of <?php echo e($total); ?> transactions
                        </p>
                        <div class="flex gap-2">
                            <?php if($currentPage > 1): ?>
                                <a href="<?php echo e(route('vendor.transactions.index', array_merge(request()->query(), ['page' => $currentPage - 1]))); ?>" 
                                    class="px-3 sm:px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 text-xs sm:text-sm font-semibold">
                                    <i class="fas fa-chevron-left mr-1"></i>Previous
                                </a>
                            <?php endif; ?>
                            <?php if($currentPage * $perPage < $total): ?>
                                <a href="<?php echo e(route('vendor.transactions.index', array_merge(request()->query(), ['page' => $currentPage + 1]))); ?>" 
                                    class="px-3 sm:px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 text-xs sm:text-sm font-semibold">
                                    Next<i class="fas fa-chevron-right ml-1"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <!-- Export Button -->
    <div class="mt-4 sm:mt-6 text-center">
        <button onclick="window.print()" class="w-full sm:w-auto bg-gray-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-gray-700 font-semibold text-sm sm:text-base transition no-print">
            <i class="fas fa-download mr-2"></i>Export Transactions
        </button>
    </div>
</div>

<style>
@media print {
    .no-print {
        display: none !important;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/transactions/index.blade.php ENDPATH**/ ?>