<?php $__env->startSection('title', 'KYC Verification'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto px-3 sm:px-4 py-4 sm:py-8">
    <!-- Header -->
    <div class="mb-4 sm:mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                <i class="fas fa-id-card mr-2 sm:mr-3"></i>KYC Verification
            </h1>
            <p class="text-primary-light text-sm sm:text-base">Complete your verification to start listing properties</p>
        </div>
    </div>

    <!-- Status Alerts -->
    <?php if($vendor->kyc_status === 'approved'): ?>
        <div class="bg-gradient-to-r from-green-50 to-teal-50 border-2 border-green-200 rounded-lg sm:rounded-xl p-4 sm:p-6 mb-4 sm:mb-8 shadow-md">
            <div class="flex items-center">
                <div class="bg-green-500 text-white rounded-full p-3 sm:p-4 mr-3 sm:mr-4 flex-shrink-0">
                    <i class="fas fa-check-circle text-2xl sm:text-3xl"></i>
                </div>
                <div>
                    <h3 class="text-lg sm:text-xl font-bold text-green-800 mb-1">Verification Approved!</h3>
                    <p class="text-green-700 text-sm sm:text-base">Your KYC has been successfully verified. You can now list properties.</p>
                </div>
            </div>
        </div>
    <?php elseif($vendor->kyc_status === 'rejected'): ?>
        <div class="bg-gradient-to-r from-red-50 to-orange-50 border-2 border-red-200 rounded-lg sm:rounded-xl p-4 sm:p-6 mb-4 sm:mb-8 shadow-md">
            <div class="flex items-start">
                <div class="bg-red-500 text-white rounded-full p-3 sm:p-4 mr-3 sm:mr-4 flex-shrink-0">
                    <i class="fas fa-times-circle text-2xl sm:text-3xl"></i>
                </div>
                <div class="flex-1">
                    <h3 class="text-lg sm:text-xl font-bold text-red-800 mb-2">Verification Rejected</h3>
                    <?php if($vendor->kyc_rejection_reason): ?>
                        <div class="bg-white rounded-lg p-3 sm:p-4 mb-2 sm:mb-3">
                            <p class="text-xs sm:text-sm text-gray-600 mb-1">Rejection Reason:</p>
                            <p class="text-red-700 font-semibold text-sm sm:text-base"><?php echo e($vendor->kyc_rejection_reason); ?></p>
                        </div>
                    <?php endif; ?>
                    <p class="text-red-700 text-sm sm:text-base">Please review and resubmit with correct information.</p>
                </div>
            </div>
        </div>
    <?php elseif($vendor->hasSubmittedKyc()): ?>
        <div class="bg-gradient-to-r from-yellow-50 to-orange-50 border-2 border-yellow-200 rounded-lg sm:rounded-xl p-4 sm:p-6 mb-4 sm:mb-8 shadow-md">
            <div class="flex items-center">
                <div class="bg-yellow-500 text-white rounded-full p-3 sm:p-4 mr-3 sm:mr-4 flex-shrink-0">
                    <i class="fas fa-clock text-2xl sm:text-3xl"></i>
                </div>
                <div>
                    <h3 class="text-lg sm:text-xl font-bold text-yellow-800 mb-1">Under Review</h3>
                    <p class="text-yellow-700 text-sm sm:text-base">Your KYC is being reviewed. We'll notify you once it's processed (usually within 24-48 hours).</p>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-gradient-to-r from-blue-50 to-primary/5 border-2 border-blue-200 rounded-lg sm:rounded-xl p-4 sm:p-6 mb-4 sm:mb-8 shadow-md">
            <div class="flex items-center">
                <div class="bg-primary text-white rounded-full p-3 sm:p-4 mr-3 sm:mr-4 flex-shrink-0">
                    <i class="fas fa-info-circle text-2xl sm:text-3xl"></i>
                </div>
                <div>
                    <h3 class="text-lg sm:text-xl font-bold text-blue-800 mb-1">Verification Required</h3>
                    <p class="text-blue-700 text-sm sm:text-base">Complete your KYC verification to unlock all features and start listing properties.</p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($vendor->kyc_status !== 'approved'): ?>
        <form method="POST" action="<?php echo e(route('vendor.kyc.submit')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <!-- Step 1: Identity Verification -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden mb-4 sm:mb-6">
                <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h2 class="text-lg sm:text-xl font-bold flex items-center">
                        <span class="bg-white text-primary rounded-full w-7 h-7 sm:w-8 sm:h-8 flex items-center justify-center mr-2 sm:mr-3 font-bold text-sm sm:text-base">1</span>
                        Identity Verification
                    </h2>
                </div>
                <div class="p-4 sm:p-6">
                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-id-card text-primary mr-2"></i>ID Card Type *
                        </label>
                        <select name="id_card_type" required class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['id_card_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <option value="">Select ID Type</option>
                            <option value="NIN" <?php echo e(old('id_card_type', $vendor->id_card_type) === 'NIN' ? 'selected' : ''); ?>>National Identity Number (NIN)</option>
                            <option value="Drivers License" <?php echo e(old('id_card_type', $vendor->id_card_type) === 'Drivers License' ? 'selected' : ''); ?>>Driver's License</option>
                            <option value="International Passport" <?php echo e(old('id_card_type', $vendor->id_card_type) === 'International Passport' ? 'selected' : ''); ?>>International Passport</option>
                            <option value="Voters Card" <?php echo e(old('id_card_type', $vendor->id_card_type) === 'Voters Card' ? 'selected' : ''); ?>>Voter's Card</option>
                        </select>
                        <?php $__errorArgs = ['id_card_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-hashtag text-primary mr-2"></i>ID Card Number *
                        </label>
                        <input type="text" name="id_card_number" value="<?php echo e(old('id_card_number', $vendor->id_card_number)); ?>" required
                            placeholder="Enter your ID card number"
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['id_card_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['id_card_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-file-upload text-primary mr-2"></i>Upload ID Card Document *
                        </label>
                        <?php if($vendor->id_card_document): ?>
                            <div class="mb-2 sm:mb-3 bg-green-50 border border-green-200 rounded-lg p-2 sm:p-3">
                                <a href="<?php echo e(asset('storage/' . $vendor->id_card_document)); ?>" target="_blank" 
                                    class="text-green-700 hover:text-green-800 font-semibold flex items-center text-xs sm:text-sm">
                                    <i class="fas fa-file-check mr-2"></i> View Current Document
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="border-2 border-dashed border-gray-300 rounded-lg sm:rounded-xl p-4 sm:p-6 text-center hover:border-primary transition">
                            <i class="fas fa-cloud-upload-alt text-3xl sm:text-4xl text-gray-400 mb-2 sm:mb-3"></i>
                            <input type="file" name="id_card_document" accept=".pdf,.jpg,.jpeg,.png" 
                                <?php echo e($vendor->id_card_document ? '' : 'required'); ?>

                                class="w-full text-sm <?php $__errorArgs = ['id_card_document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <p class="text-xs sm:text-sm text-gray-600 mt-2">
                                Upload a clear photo or scan of your ID card<br>
                                <span class="text-xs text-gray-500">PDF, JPG, PNG - Max 5MB</span>
                            </p>
                        </div>
                        <?php $__errorArgs = ['id_card_document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Step 2: Business Information (Property Vendors Only) -->
            <?php if($vendor->offersProperties()): ?>
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden mb-4 sm:mb-6">
                <div class="bg-gradient-to-r from-green-500 to-teal-500 text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h2 class="text-lg sm:text-xl font-bold flex items-center">
                        <span class="bg-white text-primary rounded-full w-7 h-7 sm:w-8 sm:h-8 flex items-center justify-center mr-2 sm:mr-3 font-bold text-sm sm:text-base">2</span>
                        Business Information (Property Rental)
                    </h2>
                    <p class="text-green-100 text-xs sm:text-sm mt-1">Required for property rental services</p>
                </div>
                <div class="p-4 sm:p-6">
                    <div class="mb-4 sm:mb-6">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            <i class="fas fa-building text-primary mr-2"></i>CAC/Business Registration Certificate (Optional)
                        </label>
                        <?php if($vendor->cac_document): ?>
                            <div class="mb-2 sm:mb-3 bg-green-50 border border-green-200 rounded-lg p-2 sm:p-3">
                                <a href="<?php echo e(asset('storage/' . $vendor->cac_document)); ?>" target="_blank" 
                                    class="text-green-700 hover:text-green-800 font-semibold flex items-center text-xs sm:text-sm">
                                    <i class="fas fa-file-check mr-2"></i> View Current Document
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="border-2 border-dashed border-gray-300 rounded-lg sm:rounded-xl p-4 sm:p-6 text-center hover:border-primary transition">
                            <i class="fas fa-cloud-upload-alt text-3xl sm:text-4xl text-gray-400 mb-2 sm:mb-3"></i>
                            <input type="file" name="cac_document" accept=".pdf,.jpg,.jpeg,.png"
                                class="w-full text-sm <?php $__errorArgs = ['cac_document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <p class="text-xs sm:text-sm text-gray-600 mt-2">
                                Upload your CAC certificate if you have a registered business<br>
                                <span class="text-xs text-gray-500">PDF, JPG, PNG - Max 5MB</span>
                            </p>
                        </div>
                        <?php $__errorArgs = ['cac_document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                            </p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="grid md:grid-cols-2 gap-4 sm:gap-6">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-map-marker-alt text-primary mr-2"></i>Business Address *
                            </label>
                            <textarea name="business_address" rows="4" <?php echo e($vendor->offersProperties() ? 'required' : ''); ?>

                                placeholder="Enter your business address"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['business_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('business_address', $vendor->business_address)); ?></textarea>
                            <?php $__errorArgs = ['business_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-home text-primary mr-2"></i>Home Address *
                            </label>
                            <textarea name="home_address" rows="4" <?php echo e($vendor->offersProperties() ? 'required' : ''); ?>

                                placeholder="Enter your home address"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['home_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('home_address', $vendor->home_address)); ?></textarea>
                            <?php $__errorArgs = ['home_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Step 3: Car Rental KYC (Car Rental Vendors Only) -->
            <?php if($vendor->offersCarRentals()): ?>
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden mb-4 sm:mb-6">
                <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h2 class="text-lg sm:text-xl font-bold flex items-center">
                        <span class="bg-white text-primary rounded-full w-7 h-7 sm:w-8 sm:h-8 flex items-center justify-center mr-2 sm:mr-3 font-bold text-sm sm:text-base"><?php echo e($vendor->offersProperties() ? '3' : '2'); ?></span>
                        Car Rental Business Verification
                    </h2>
                    <p class="text-primary-light text-xs sm:text-sm mt-1">Required for car rental services</p>
                </div>

                <div class="p-4 sm:p-6">
                    <!-- Car Rental KYC Status -->
                    <?php if($vendor->car_rental_kyc_status === 'verified'): ?>
                        <div class="bg-green-50 border-2 border-green-200 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-primary text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                                <div>
                                    <h4 class="font-bold text-green-800 text-sm sm:text-base">Car Rental KYC Verified</h4>
                                    <p class="text-xs sm:text-sm text-green-700">You can now list vehicles for rent</p>
                                </div>
                            </div>
                        </div>
                    <?php elseif($vendor->car_rental_kyc_status === 'rejected'): ?>
                        <div class="bg-red-50 border-2 border-red-200 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                            <div class="flex items-start">
                                <i class="fas fa-times-circle text-red-600 text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                                <div class="flex-1">
                                    <h4 class="font-bold text-red-800 mb-2 text-sm sm:text-base">Car Rental KYC Rejected</h4>
                                    <?php if($vendor->car_rental_rejection_reason): ?>
                                        <p class="text-xs sm:text-sm text-red-700 bg-white rounded p-2 sm:p-3"><?php echo e($vendor->car_rental_rejection_reason); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php elseif($vendor->hasSubmittedCarRentalKyc()): ?>
                        <div class="bg-yellow-50 border-2 border-yellow-200 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-clock text-yellow-600 text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                                <div>
                                    <h4 class="font-bold text-yellow-800 text-sm sm:text-base">Under Review</h4>
                                    <p class="text-xs sm:text-sm text-yellow-700">Your car rental KYC is being reviewed</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="grid md:grid-cols-2 gap-4 sm:gap-6">
                        <!-- Business Name -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-building text-primary mr-2"></i>Car Rental Business Name *
                            </label>
                            <input type="text" name="car_rental_business_name" 
                                value="<?php echo e(old('car_rental_business_name', $vendor->car_rental_business_name)); ?>"
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                placeholder="e.g., ABC Car Rentals Ltd"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['car_rental_business_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>">
                            <?php $__errorArgs = ['car_rental_business_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- CAC Registration Number -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-file-contract text-primary mr-2"></i>CAC Registration Number *
                            </label>
                            <input type="text" name="car_rental_business_registration" 
                                value="<?php echo e(old('car_rental_business_registration', $vendor->car_rental_business_registration)); ?>"
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                placeholder="e.g., RC123456"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['car_rental_business_registration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>">
                            <?php $__errorArgs = ['car_rental_business_registration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Tax ID (TIN) -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-receipt text-primary mr-2"></i>Tax Identification Number (TIN) *
                            </label>
                            <input type="text" name="car_rental_tax_id" 
                                value="<?php echo e(old('car_rental_tax_id', $vendor->car_rental_tax_id)); ?>"
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                placeholder="Enter TIN"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['car_rental_tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>">
                            <?php $__errorArgs = ['car_rental_tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Business Address -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-map-marker-alt text-primary mr-2"></i>Business Address *
                            </label>
                            <textarea name="car_rental_business_address" rows="3" 
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                placeholder="Enter business address"
                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php $__errorArgs = ['car_rental_business_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>"><?php echo e(old('car_rental_business_address', $vendor->car_rental_business_address)); ?></textarea>
                            <?php $__errorArgs = ['car_rental_business_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- CAC Certificate Upload -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-upload text-primary mr-2"></i>CAC Certificate *
                            </label>
                            <?php if($vendor->car_rental_business_certificate): ?>
                                <div class="mb-2 p-2 sm:p-3 bg-green-50 border border-green-200 rounded-lg">
                                    <a href="<?php echo e(asset('storage/' . $vendor->car_rental_business_certificate)); ?>" target="_blank" 
                                        class="text-green-700 hover:text-green-900 flex items-center text-xs sm:text-sm">
                                        <i class="fas fa-file-pdf mr-2"></i>View Uploaded Certificate
                                    </a>
                                </div>
                            <?php endif; ?>
                            <input type="file" name="car_rental_business_certificate" accept=".pdf,.jpg,.jpeg,.png"
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'disabled' : ($vendor->car_rental_business_certificate ? '' : 'required')); ?>

                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm <?php $__errorArgs = ['car_rental_business_certificate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <p class="text-xs text-gray-500 mt-1">PDF, JPG, or PNG (Max 5MB)</p>
                            <?php $__errorArgs = ['car_rental_business_certificate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Transport/Rental License -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-id-card text-primary mr-2"></i>Transport/Rental License *
                            </label>
                            <?php if($vendor->car_rental_license): ?>
                                <div class="mb-2 p-2 sm:p-3 bg-green-50 border border-green-200 rounded-lg">
                                    <a href="<?php echo e(asset('storage/' . $vendor->car_rental_license)); ?>" target="_blank" 
                                        class="text-green-700 hover:text-green-900 flex items-center text-xs sm:text-sm">
                                        <i class="fas fa-file-pdf mr-2"></i>View Uploaded License
                                    </a>
                                </div>
                            <?php endif; ?>
                            <input type="file" name="car_rental_license" accept=".pdf,.jpg,.jpeg,.png"
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'disabled' : ($vendor->car_rental_license ? '' : 'required')); ?>

                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm <?php $__errorArgs = ['car_rental_license'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <p class="text-xs text-gray-500 mt-1">PDF, JPG, or PNG (Max 5MB)</p>
                            <?php $__errorArgs = ['car_rental_license'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Insurance Certificate -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-shield-alt text-primary mr-2"></i>Insurance Certificate *
                            </label>
                            <?php if($vendor->car_rental_insurance_certificate): ?>
                                <div class="mb-2 p-2 sm:p-3 bg-green-50 border border-green-200 rounded-lg">
                                    <a href="<?php echo e(asset('storage/' . $vendor->car_rental_insurance_certificate)); ?>" target="_blank" 
                                        class="text-green-700 hover:text-green-900 flex items-center text-xs sm:text-sm">
                                        <i class="fas fa-file-pdf mr-2"></i>View Uploaded Certificate
                                    </a>
                                </div>
                            <?php endif; ?>
                            <input type="file" name="car_rental_insurance_certificate" accept=".pdf,.jpg,.jpeg,.png"
                                <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'disabled' : ($vendor->car_rental_insurance_certificate ? '' : 'required')); ?>

                                class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm <?php $__errorArgs = ['car_rental_insurance_certificate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <p class="text-xs text-gray-500 mt-1">PDF, JPG, or PNG (Max 5MB)</p>
                            <?php $__errorArgs = ['car_rental_insurance_certificate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <!-- Bank Details for Car Rental -->
                    <div class="mt-4 sm:mt-6 pt-4 sm:pt-6 border-t-2 border-gray-200">
                        <h3 class="text-base sm:text-lg font-bold text-gray-800 mb-3 sm:mb-4 flex items-center">
                            <i class="fas fa-university text-primary mr-2"></i>
                            Bank Account for Car Rental Payments
                        </h3>
                        <p class="text-xs sm:text-sm text-gray-600 mb-3 sm:mb-4">Separate bank account for receiving car rental payments</p>

                        <div class="grid md:grid-cols-3 gap-4 sm:gap-6">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Bank Name *</label>
                                <input type="text" name="car_rental_bank_name" 
                                    value="<?php echo e(old('car_rental_bank_name', $vendor->car_rental_bank_name)); ?>"
                                    <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                    placeholder="e.g., GTBank"
                                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>">
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Account Number *</label>
                                <input type="text" name="car_rental_account_number" 
                                    value="<?php echo e(old('car_rental_account_number', $vendor->car_rental_account_number)); ?>"
                                    <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                    placeholder="0123456789"
                                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>">
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Account Name *</label>
                                <input type="text" name="car_rental_account_name" 
                                    value="<?php echo e(old('car_rental_account_name', $vendor->car_rental_account_name)); ?>"
                                    <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'readonly' : 'required'); ?>

                                    placeholder="Account holder name"
                                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition text-sm sm:text-base <?php echo e($vendor->car_rental_kyc_status === 'verified' ? 'bg-gray-100' : ''); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Submit Buttons -->
            <div class="flex flex-col sm:flex-row gap-3 sm:gap-4 justify-center">
                <button type="submit" 
                    class="bg-gradient-to-r from-primary to-primary-dark text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg sm:rounded-xl hover:shadow-xl font-bold text-base sm:text-lg transition transform hover:scale-105">
                    <i class="fas fa-check-circle mr-2"></i> Submit KYC Verification
                </button>
                <a href="<?php echo e(route('vendor.dashboard')); ?>" 
                    class="bg-gray-200 text-gray-700 px-6 sm:px-8 py-3 sm:py-4 rounded-lg sm:rounded-xl hover:bg-gray-300 font-semibold text-base sm:text-lg transition text-center">
                    <i class="fas fa-times mr-2"></i> Cancel
                </a>
            </div>
        </form>
    <?php else: ?>
        <!-- Show submitted information -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-8">
            <h2 class="text-xl sm:text-2xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-check-circle text-green-500 mr-2 sm:mr-3"></i>
                Verified Information
            </h2>
            
            <div class="grid md:grid-cols-2 gap-4 sm:gap-6">
                <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-l-4 border-primary">
                    <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">ID Card Type</p>
                    <p class="font-bold text-base sm:text-lg text-gray-800"><?php echo e($vendor->id_card_type); ?></p>
                </div>
                <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-l-4 border-primary">
                    <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">ID Card Number</p>
                    <p class="font-bold text-base sm:text-lg text-gray-800"><?php echo e($vendor->id_card_number); ?></p>
                </div>
                <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-l-4 border-green-500">
                    <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">Business Address</p>
                    <p class="font-semibold text-sm sm:text-base text-gray-800"><?php echo e($vendor->business_address); ?></p>
                </div>
                <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-l-4 border-green-500">
                    <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">Home Address</p>
                    <p class="font-semibold text-sm sm:text-base text-gray-800"><?php echo e($vendor->home_address); ?></p>
                </div>
            </div>

            <?php if($vendor->id_card_document || $vendor->cac_document): ?>
                <div class="mt-4 sm:mt-6 pt-4 sm:pt-6 border-t">
                    <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4">Uploaded Documents</h3>
                    <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                        <?php if($vendor->id_card_document): ?>
                            <a href="<?php echo e(asset('storage/' . $vendor->id_card_document)); ?>" target="_blank" 
                                class="flex items-center justify-center bg-primary/10 text-primary px-3 sm:px-4 py-2 sm:py-3 rounded-lg hover:bg-primary/20 transition text-sm sm:text-base">
                                <i class="fas fa-file-alt mr-2"></i> ID Card Document
                            </a>
                        <?php endif; ?>
                        <?php if($vendor->cac_document): ?>
                            <a href="<?php echo e(asset('storage/' . $vendor->cac_document)); ?>" target="_blank" 
                                class="flex items-center justify-center bg-green-50 text-green-700 px-3 sm:px-4 py-2 sm:py-3 rounded-lg hover:bg-green-100 transition text-sm sm:text-base">
                                <i class="fas fa-file-alt mr-2"></i> CAC Document
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/kyc/show.blade.php ENDPATH**/ ?>