<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-secondary mb-2">Refund Payouts</h1>
            <p class="text-gray-600">Manage user refund payout requests</p>
        </div>
        <a href="<?php echo e(route('admin.transactions.index')); ?>" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition">
            <i class="fas fa-arrow-left mr-2"></i>Back to Transactions
        </a>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <form method="GET" action="<?php echo e(route('admin.refund-payouts.index')); ?>" class="grid md:grid-cols-2 gap-4">
            <select name="status" class="border-gray-300 rounded-lg" onchange="this.form.submit()">
                <option value="all" <?php echo e($status === 'all' ? 'selected' : ''); ?>>All Status</option>
                <option value="pending" <?php echo e($status === 'pending' ? 'selected' : ''); ?>>Pending (Not Requested)</option>
                <option value="requested" <?php echo e($status === 'requested' ? 'selected' : ''); ?>>Requested (Action Needed)</option>
                <option value="processing" <?php echo e($status === 'processing' ? 'selected' : ''); ?>>Processing</option>
                <option value="paid" <?php echo e($status === 'paid' ? 'selected' : ''); ?>>Paid</option>
            </select>

            <select name="service" class="border-gray-300 rounded-lg" onchange="this.form.submit()">
                <option value="all" <?php echo e($service === 'all' ? 'selected' : ''); ?>>All Services</option>
                <option value="property" <?php echo e($service === 'property' ? 'selected' : ''); ?>>Property Only</option>
                <option value="car" <?php echo e($service === 'car' ? 'selected' : ''); ?>>Car Only</option>
            </select>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="grid md:grid-cols-5 gap-6 mb-6">
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total</p>
                    <p class="text-2xl font-bold text-secondary"><?php echo e($stats['total']); ?></p>
                </div>
                <div class="bg-blue-100 rounded-full p-3">
                    <i class="fas fa-hand-holding-usd text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Pending</p>
                    <p class="text-2xl font-bold text-gray-600"><?php echo e($stats['pending']); ?></p>
                </div>
                <div class="bg-gray-100 rounded-full p-3">
                    <i class="fas fa-clock text-gray-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Requested</p>
                    <p class="text-2xl font-bold text-yellow-600"><?php echo e($stats['requested']); ?></p>
                </div>
                <div class="bg-yellow-100 rounded-full p-3">
                    <i class="fas fa-exclamation-circle text-yellow-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Processing</p>
                    <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['processing']); ?></p>
                </div>
                <div class="bg-blue-100 rounded-full p-3">
                    <i class="fas fa-spinner text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Paid</p>
                    <p class="text-2xl font-bold text-green-600"><?php echo e($stats['paid']); ?></p>
                </div>
                <div class="bg-green-100 rounded-full p-3">
                    <i class="fas fa-check-circle text-green-600 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Amount Summary -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6 mb-6">
        <div class="grid md:grid-cols-2 gap-6">
            <div>
                <p class="text-primary-light mb-1">Total Refund Amount</p>
                <p class="text-3xl font-bold">₦<?php echo e(number_format($stats['total_amount'])); ?></p>
            </div>
            <div>
                <p class="text-primary-light mb-1">Pending Payment</p>
                <p class="text-3xl font-bold">₦<?php echo e(number_format($stats['pending_amount'])); ?></p>
            </div>
        </div>
    </div>

    <!-- Payouts List -->
    <?php if($payouts->count() > 0): ?>
        <div class="space-y-4">
            <?php $__currentLoopData = $payouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-3">
                                <span class="px-3 py-1 
                                    <?php if($payout['status'] === 'requested'): ?> bg-yellow-100 text-yellow-800
                                    <?php elseif($payout['status'] === 'processing'): ?> bg-blue-100 text-blue-800
                                    <?php elseif($payout['status'] === 'paid'): ?> bg-green-100 text-green-800
                                    <?php else: ?> bg-gray-100 text-gray-800
                                    <?php endif; ?> rounded-full text-xs font-semibold">
                                    <?php if($payout['status'] === 'requested'): ?>
                                        <i class="fas fa-exclamation-circle mr-1"></i>Action Needed
                                    <?php elseif($payout['status'] === 'processing'): ?>
                                        <i class="fas fa-spinner fa-spin mr-1"></i>Processing
                                    <?php elseif($payout['status'] === 'paid'): ?>
                                        <i class="fas fa-check-circle mr-1"></i>Paid
                                    <?php else: ?>
                                        <i class="fas fa-clock mr-1"></i>Pending
                                    <?php endif; ?>
                                </span>
                                
                                <?php if($payout['service'] === 'property'): ?>
                                    <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-home mr-1"></i>Property
                                    </span>
                                <?php else: ?>
                                    <span class="px-3 py-1 bg-orange-100 text-orange-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-car mr-1"></i>Car
                                    </span>
                                <?php endif; ?>
                            </div>

                            <h3 class="font-bold text-lg text-gray-800 mb-2"><?php echo e($payout['description']); ?></h3>
                            <p class="text-sm text-gray-600 mb-3">Reference: <span class="font-mono">#<?php echo e($payout['reference']); ?></span></p>

                            <!-- User Bank Details -->
                            <div class="bg-gray-50 rounded-lg p-4 mb-3">
                                <h4 class="font-semibold text-sm text-gray-700 mb-2">
                                    <i class="fas fa-user-circle mr-1"></i>User Details:
                                </h4>
                                <div class="grid md:grid-cols-4 gap-4 text-sm">
                                    <div>
                                        <p class="text-gray-600">Name</p>
                                        <p class="font-semibold"><?php echo e($payout['user']->name); ?></p>
                                    </div>
                                    <div>
                                        <p class="text-gray-600">Email</p>
                                        <p class="font-semibold text-xs"><?php echo e($payout['user']->email); ?></p>
                                    </div>
                                    <?php if($payout['user']->phone): ?>
                                        <div>
                                            <p class="text-gray-600">Phone</p>
                                            <p class="font-semibold"><?php echo e($payout['user']->phone); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if($payout['user']->bank_name): ?>
                                    <div class="grid md:grid-cols-3 gap-4 text-sm mt-3 pt-3 border-t">
                                        <div>
                                            <p class="text-gray-600">Bank</p>
                                            <p class="font-semibold"><?php echo e($payout['user']->bank_name); ?></p>
                                        </div>
                                        <div>
                                            <p class="text-gray-600">Account Number</p>
                                            <p class="font-semibold"><?php echo e($payout['user']->account_number); ?></p>
                                        </div>
                                        <div>
                                            <p class="text-gray-600">Account Name</p>
                                            <p class="font-semibold"><?php echo e($payout['user']->account_name ?? 'N/A'); ?></p>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="mt-3 pt-3 border-t">
                                        <p class="text-red-600 text-sm">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>User has not provided bank details. Please contact user.
                                        </p>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if($payout['payment_method']): ?>
                                <div class="bg-green-50 rounded-lg p-4">
                                    <h4 class="font-semibold text-sm text-green-800 mb-2">
                                        <i class="fas fa-check-circle mr-1"></i>Payment Completed:
                                    </h4>
                                    <div class="grid md:grid-cols-2 gap-4 text-sm">
                                        <div>
                                            <p class="text-gray-600">Method</p>
                                            <p class="font-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $payout['payment_method']))); ?></p>
                                        </div>
                                        <div>
                                            <p class="text-gray-600">Paid On</p>
                                            <p class="font-semibold"><?php echo e($payout['paid_at']->format('M d, Y h:i A')); ?></p>
                                        </div>
                                        <?php if($payout['payment_details']): ?>
                                            <div class="md:col-span-2">
                                                <p class="text-gray-600">Reference/Notes</p>
                                                <p class="font-semibold"><?php echo e($payout['payment_details']); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="text-right ml-6">
                            <p class="font-bold text-3xl text-green-600 mb-2">
                                ₦<?php echo e(number_format($payout['amount'])); ?>

                            </p>
                            <?php if($payout['requested_at']): ?>
                                <p class="text-xs text-gray-500 mb-1">
                                    Requested: <?php echo e($payout['requested_at']->format('M d, Y')); ?>

                                </p>
                                <p class="text-xs text-gray-400">
                                    <?php echo e($payout['requested_at']->diffForHumans()); ?>

                                </p>
                            <?php else: ?>
                                <p class="text-xs text-gray-500">
                                    Not yet requested
                                </p>
                            <?php endif; ?>
                            
                            <?php if($payout['type'] === 'property'): ?>
                                <a href="<?php echo e(route('admin.bookings.show', $payout['id'])); ?>" 
                                   class="inline-block mt-3 bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary-dark transition text-sm">
                                    <i class="fas fa-eye mr-2"></i>View Booking
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('admin.car-bookings.show', $payout['id'])); ?>" 
                                   class="inline-block mt-3 bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary-dark transition text-sm">
                                    <i class="fas fa-eye mr-2"></i>View Booking
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-xl shadow-md p-12 text-center">
            <i class="fas fa-hand-holding-usd text-6xl text-gray-300 mb-4"></i>
            <h3 class="text-xl font-bold text-gray-700 mb-2">No Payouts Found</h3>
            <p class="text-gray-600">No refund payout requests match your filter.</p>
        </div>
    <?php endif; ?>

    <!-- Help Section -->
    <div class="mt-6 bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-info-circle text-blue-500 text-xl"></i>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">How Refund Payouts Work</h3>
                <div class="mt-2 text-sm text-blue-700">
                    <ul class="list-disc list-inside space-y-1">
                        <li><strong>Pending:</strong> Deposit decision has been made, but user hasn't requested payout yet</li>
                        <li><strong>Requested:</strong> User has requested payout - <span class="font-bold text-red-600">admin action needed</span></li>
                        <li><strong>Processing:</strong> Admin is processing the payment</li>
                        <li><strong>Paid:</strong> Refund has been paid to the user</li>
                    </ul>
                    <p class="mt-3 font-semibold">
                        <i class="fas fa-arrow-right mr-1"></i>To process a refund, click "View Booking" and use the refund processing form.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/transactions/payouts.blade.php ENDPATH**/ ?>