<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php
        $favicon = \App\Models\Setting::get('favicon');
        $logo = \App\Models\Setting::get('logo');
        $siteName = \App\Models\Setting::get('site_name', 'ShortStayNG');
        $siteDescription = \App\Models\Setting::get('site_description', 'Book Hotels & Shortlets in Nigeria');
        $pageTitle = View::yieldContent('title') ?: 'Admin Dashboard';
        $ogImage = $logo ? asset('storage/' . $logo) : asset('images/og-default.jpg');
    ?>
    
    <title><?php echo e($pageTitle); ?> - <?php echo e($siteName); ?></title>
    <meta name="description" content="<?php echo e($siteDescription); ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($pageTitle); ?> - <?php echo e($siteName); ?>">
    <meta property="og:description" content="<?php echo e($siteDescription); ?>">
    <meta property="og:image" content="<?php echo e($ogImage); ?>">
    <meta property="og:site_name" content="<?php echo e($siteName); ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($pageTitle); ?> - <?php echo e($siteName); ?>">
    <meta name="twitter:description" content="<?php echo e($siteDescription); ?>">
    <meta name="twitter:image" content="<?php echo e($ogImage); ?>">
    
    <?php if($favicon): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $favicon)); ?>">
    <?php endif; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#136D73',
                        'primary-dark': '#0f5a5f',
                        'primary-light': '#1a8891',
                    }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-100">
    <!-- Mobile Menu Button -->
    <div class="lg:hidden fixed top-0 left-0 right-0 bg-primary z-50 p-4 flex items-center justify-between">
        <div class="flex items-center">
            <?php if($logo): ?>
                <img src="<?php echo e(asset('storage/' . $logo)); ?>" alt="<?php echo e($siteName); ?>" class="h-8 w-auto brightness-0 invert">
            <?php else: ?>
                <span class="text-xl font-bold text-white"><?php echo e($siteName); ?></span>
            <?php endif; ?>
        </div>
        <div class="flex items-center gap-3">
            <div class="scale-90">
                <?php if (isset($component)) { $__componentOriginal27dc6277b85491d47ded5f7c284c1a13 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal27dc6277b85491d47ded5f7c284c1a13 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.language-selector','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('language-selector'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal27dc6277b85491d47ded5f7c284c1a13)): ?>
<?php $attributes = $__attributesOriginal27dc6277b85491d47ded5f7c284c1a13; ?>
<?php unset($__attributesOriginal27dc6277b85491d47ded5f7c284c1a13); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal27dc6277b85491d47ded5f7c284c1a13)): ?>
<?php $component = $__componentOriginal27dc6277b85491d47ded5f7c284c1a13; ?>
<?php unset($__componentOriginal27dc6277b85491d47ded5f7c284c1a13); ?>
<?php endif; ?>
            </div>
            <button onclick="toggleMobileMenu()" class="text-white">
                <i class="fas fa-bars text-2xl"></i>
            </button>
        </div>
    </div>

    <div class="flex h-screen">
        <!-- Sidebar -->
        <div id="sidebar" class="w-64 bg-primary-dark text-white fixed lg:static inset-y-0 left-0 transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out z-40 overflow-y-auto">
            <div class="p-4 bg-primary">
                <?php if($logo): ?>
                    <img src="<?php echo e(asset('storage/' . $logo)); ?>" alt="<?php echo e($siteName); ?>" class="h-10 w-auto mb-2 brightness-0 invert">
                <?php else: ?>
                    <h2 class="text-2xl font-bold">🏨 <?php echo e($siteName); ?></h2>
                <?php endif; ?>
                <p class="text-sm text-gray-200">Welcome, <?php echo e(auth()->user()->name); ?></p>
            </div>
            
            <nav class="mt-8">
                <!-- Dashboard -->
                <a href="<?php echo e(route('admin.dashboard')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-tachometer-alt mr-3"></i> Dashboard
                </a>

                <!-- Bookings & Payments -->
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Bookings & Payments</p>
                </div>
                <a href="<?php echo e(route('admin.bookings.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.bookings.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-calendar-check mr-3"></i> Bookings
                </a>
                <a href="<?php echo e(route('admin.payment-verification.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.payment-verification.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-money-check-alt mr-3"></i> Payment Verification
                    <?php if($pendingPayments = \App\Models\Booking::where('payment_method', 'bank_transfer')->where('payment_status', 'pending_verification')->count()): ?>
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($pendingPayments); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.transactions.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.transactions.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-receipt mr-3"></i> Transactions
                </a>
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'owner|manager')): ?>
                <a href="<?php echo e(route('admin.refund-payouts.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.refund-payouts.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-hand-holding-usd mr-3"></i> User Refund Payouts
                    <?php
                        $refundRequests = \App\Models\Booking::where('refund_payout_status', 'requested')->count();
                    ?>
                    <?php if($refundRequests > 0): ?>
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($refundRequests); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.payouts.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.payouts.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-money-bill-wave mr-3"></i> Vendor Payouts
                    <?php if($pendingPayouts = \App\Models\Payout::where('status', 'pending')->count()): ?>
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($pendingPayouts); ?></span>
                    <?php endif; ?>
                </a>
                <?php endif; ?>

                <!-- Users & Vendors -->
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Users & Vendors</p>
                </div>
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'owner|manager')): ?>
                <a href="<?php echo e(route('admin.all-users.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.all-users.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-users mr-3"></i> All Users
                </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.vendors.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.vendors.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-store mr-3"></i> Vendors
                </a>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-ads')): ?>
                <a href="<?php echo e(route('admin.kyc.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.kyc.index') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-id-card mr-3"></i> KYC Approvals
                    <?php if($kycPendingCount = \App\Models\Vendor::where('kyc_status', 'pending')->whereNotNull('kyc_submitted_at')->count()): ?>
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($kycPendingCount); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.kyc-form.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.kyc-form.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-edit mr-3"></i> KYC Form Builder
                </a>
                <?php endif; ?>

                <!-- Properties -->
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Properties</p>
                </div>
                <a href="<?php echo e(route('admin.properties.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.properties.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-home mr-3"></i> All Properties
                    <?php if($pendingCount = \App\Models\Property::where('status', 'pending')->count()): ?>
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($pendingCount); ?></span>
                    <?php endif; ?>
                </a>

                <!-- Car Rentals -->
                <?php if(\App\Models\Setting::get('car_rental_enabled', false)): ?>
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Car Rentals</p>
                </div>
                <a href="<?php echo e(route('admin.cars.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.cars.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-car mr-3"></i> All Cars
                    <?php if($pendingCars = \App\Models\Car::where('status', 'pending')->count()): ?>
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($pendingCars); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.car-bookings.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.car-bookings.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-calendar-check mr-3"></i> Car Bookings
                </a>
                <?php endif; ?>

                <!-- Advertisements -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-ads')): ?>
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Advertisements</p>
                </div>
                <a href="<?php echo e(route('admin.ads.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.ads.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-ad mr-3"></i> Ad Approvals
                </a>
                <?php endif; ?>
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'owner|manager')): ?>
                <a href="<?php echo e(route('admin.ad-plans.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.ad-plans.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-tags mr-3"></i> Ad Plans
                </a>
                <?php endif; ?>

                <!-- Promotions & Discounts -->
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'owner|manager')): ?>
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Promotions & Discounts</p>
                </div>
                <a href="<?php echo e(route('admin.promo-codes.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.promo-codes.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-ticket-alt mr-3"></i> Promo Codes
                    <?php if($activePromos = \App\Models\PromoCode::where('is_active', true)->count()): ?>
                        <span class="ml-auto bg-green-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($activePromos); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.discount-deals.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.discount-deals.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-percent mr-3"></i> Discount Deals
                    <?php if($activeDeals = \App\Models\DiscountDeal::where('is_active', true)->count()): ?>
                        <span class="ml-auto bg-green-400 text-black px-2 py-1 rounded-full text-xs font-bold"><?php echo e($activeDeals); ?></span>
                    <?php endif; ?>
                </a>
                <?php endif; ?>

                <!-- Homepage Content -->
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'owner|manager')): ?>
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Homepage Content</p>
                </div>
                <a href="<?php echo e(route('admin.destinations.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.destinations.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-map-marked-alt mr-3"></i> Popular Destinations
                    <?php if($activeDestinations = \App\Models\PopularDestination::where('active', true)->count()): ?>
                        <span class="ml-auto bg-purple-400 text-white px-2 py-1 rounded-full text-xs font-bold"><?php echo e($activeDestinations); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.house-types.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.house-types.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-home mr-3"></i> House Type Images
                    <?php if($activeHouseTypes = \App\Models\HouseTypeImage::where('active', true)->count()): ?>
                        <span class="ml-auto bg-indigo-400 text-white px-2 py-1 rounded-full text-xs font-bold"><?php echo e($activeHouseTypes); ?></span>
                    <?php endif; ?>
                </a>
                <a href="<?php echo e(route('admin.faqs.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.faqs.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-question-circle mr-3"></i> FAQs
                    <?php if($activeFaqs = \App\Models\Faq::where('is_active', true)->count()): ?>
                        <span class="ml-auto bg-blue-400 text-white px-2 py-1 rounded-full text-xs font-bold"><?php echo e($activeFaqs); ?></span>
                    <?php endif; ?>
                </a>
                <?php endif; ?>

                <!-- System Settings (Owner Only) -->
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'owner')): ?>
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">System Settings</p>
                </div>
                <a href="<?php echo e(route('admin.users.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.users.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-users-cog mr-3"></i> Admin Users
                </a>
                <a href="<?php echo e(route('admin.payment-methods.index')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.payment-methods.*') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-credit-card mr-3"></i> Payment Methods
                </a>
                <a href="<?php echo e(route('admin.settings')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.settings') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-cog mr-3"></i> Settings
                </a>
                <a href="<?php echo e(route('admin.audit-logs')); ?>" 
                    class="flex items-center px-6 py-3 hover:bg-primary <?php echo e(request()->routeIs('admin.audit-logs') ? 'bg-primary border-l-4 border-primary-light' : ''); ?>">
                    <i class="fas fa-history mr-3"></i> Audit Logs
                </a>
                <?php endif; ?>
                
                <div class="border-t border-blue-800 mt-4 pt-4">
                    <a href="<?php echo e(route('home')); ?>" class="flex items-center px-6 py-3 hover:bg-primary">
                        <i class="fas fa-globe mr-3"></i> View Site
                    </a>
                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button class="flex items-center px-6 py-3 hover:bg-primary w-full text-left">
                            <i class="fas fa-sign-out-alt mr-3"></i> Logout
                        </button>
                    </form>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto pt-16 lg:pt-0">
            <!-- Top Bar -->
            <div class="bg-white shadow-md p-4 hidden lg:block">
                <div class="flex justify-between items-center">
                    <h1 class="text-xl font-bold">Welcome, <?php echo e(auth()->user()->name); ?></h1>
                    <div class="flex items-center space-x-4">
                        <span class="px-3 py-1 bg-primary/10 text-blue-800 rounded-full text-sm font-semibold">
                            <?php echo e(ucfirst(auth()->user()->getRoleNames()->first())); ?>

                        </span>
                        <span class="text-sm"><?php echo e(auth()->user()->name); ?></span>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if(session('success')): ?>
                <div class="m-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error') || $errors->any()): ?>
                <div class="m-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                    <?php echo e(session('error') ?? $errors->first()); ?>

                </div>
            <?php endif; ?>

            <!-- Page Content -->
            <div class="p-6">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    
    <script>
        function toggleMobileMenu() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('-translate-x-full');
        }
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const menuButton = event.target.closest('button[onclick="toggleMobileMenu()"]');
            
            if (!sidebar.contains(event.target) && !menuButton && window.innerWidth < 1024) {
                sidebar.classList.add('-translate-x-full');
            }
        });
    </script>
</body>
</html>
<?php /**PATH /Users/mac/ShortStayNG/resources/views/layouts/admin.blade.php ENDPATH**/ ?>