<?php $__env->startSection('title', 'Property Approvals'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h1 class="text-3xl font-bold mb-6">Property Management</h1>

    <!-- Status Filter -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <div class="flex gap-2">
            <a href="<?php echo e(route('admin.properties.index', ['status' => 'pending'])); ?>" 
                class="px-4 py-2 rounded <?php echo e($status === 'pending' ? 'bg-yellow-600 text-white' : 'bg-gray-200'); ?>">
                Pending (<?php echo e(\App\Models\Property::where('status', 'pending')->count()); ?>)
            </a>
            <a href="<?php echo e(route('admin.properties.index', ['status' => 'active'])); ?>" 
                class="px-4 py-2 rounded <?php echo e($status === 'active' ? 'bg-green-600 text-white' : 'bg-gray-200'); ?>">
                Active
            </a>
            <a href="<?php echo e(route('admin.properties.index', ['status' => 'inactive'])); ?>" 
                class="px-4 py-2 rounded <?php echo e($status === 'inactive' ? 'bg-gray-600 text-white' : 'bg-gray-200'); ?>">
                Inactive
            </a>
            <a href="<?php echo e(route('admin.properties.index', ['status' => 'rejected'])); ?>" 
                class="px-4 py-2 rounded <?php echo e($status === 'rejected' ? 'bg-red-600 text-white' : 'bg-gray-200'); ?>">
                Rejected
            </a>
        </div>
    </div>

    <!-- Properties List -->
    <div class="grid md:grid-cols-2 gap-6">
        <?php $__empty_1 = true; $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <img src="<?php echo e(isset($property->photos[0]) ? asset('storage/' . $property->photos[0]) : '/images/placeholder.jpg'); ?>" 
                    alt="<?php echo e($property->title); ?>" 
                    class="w-full h-48 object-cover">
                
                <div class="p-4">
                    <div class="flex justify-between items-start mb-2">
                        <h3 class="font-bold text-lg"><?php echo e($property->title); ?></h3>
                        <span class="px-2 py-1 rounded text-xs font-semibold
                            <?php echo e($property->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 
                               ($property->status === 'active' ? 'bg-green-100 text-green-800' : 
                               ($property->status === 'rejected' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-secondary'))); ?>">
                            <?php echo e(ucfirst($property->status)); ?>

                        </span>
                    </div>

                    <p class="text-gray-600 text-sm mb-2"><?php echo e($property->city); ?>, <?php echo e($property->state); ?></p>
                    <p class="text-gray-600 text-sm mb-2">
                        <strong>Vendor:</strong> <?php echo e($property->vendor->company_name); ?>

                    </p>
                    <p class="text-primary font-bold mb-3">₦<?php echo e(number_format($property->price_per_night)); ?>/night</p>

                    <?php if($property->rejection_reason): ?>
                        <div class="bg-red-50 border border-red-200 rounded p-2 mb-3">
                            <p class="text-xs text-red-800"><strong>Rejection Reason:</strong></p>
                            <p class="text-xs text-red-600"><?php echo e($property->rejection_reason); ?></p>
                        </div>
                    <?php endif; ?>

                    <div class="flex gap-2">
                        <a href="<?php echo e(route('admin.properties.show', $property)); ?>" 
                            class="flex-1 bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark text-center text-sm">
                            View Details
                        </a>

                        <?php if($property->status === 'pending'): ?>
                            <form method="POST" action="<?php echo e(route('admin.properties.approve', $property)); ?>" class="flex-1">
                                <?php echo csrf_field(); ?>
                                <button type="submit" 
                                    class="w-full bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                    Approve
                                </button>
                            </form>
                            
                            <button onclick="openRejectModal(<?php echo e($property->id); ?>)" 
                                class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm">
                                Reject
                            </button>
                        <?php elseif($property->status === 'active' || $property->status === 'inactive'): ?>
                            <form method="POST" action="<?php echo e(route('admin.properties.toggle', $property)); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" 
                                    class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 text-sm">
                                    <?php echo e($property->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-2 bg-white rounded-lg shadow-md p-12 text-center">
                <p class="text-gray-600">No properties found with status: <?php echo e($status); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <div class="mt-6">
        <?php echo e($properties->links()); ?>

    </div>
</div>

<!-- Reject Modal -->
<div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-8 max-w-md w-full mx-4">
        <h2 class="text-2xl font-bold mb-4">Reject Property</h2>
        
        <form id="reject-form" method="POST">
            <?php echo csrf_field(); ?>
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Reason for Rejection *</label>
                <textarea name="rejection_reason" rows="4" required
                    placeholder="Please provide a detailed reason..."
                    class="w-full border rounded px-4 py-2"></textarea>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-4 py-3 rounded hover:bg-gray-300 font-semibold">
                    Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-red-600 text-white px-4 py-3 rounded hover:bg-red-700 font-semibold">
                    Reject Property
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openRejectModal(propertyId) {
    document.getElementById('reject-form').action = `/admin/properties/${propertyId}/reject`;
    document.getElementById('reject-modal').classList.remove('hidden');
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/properties/index.blade.php ENDPATH**/ ?>