@extends('layouts.vendor')

@section('title', 'Transactions')

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Header -->
    <div class="mb-6 sm:mb-8">
        <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                <i class="fas fa-receipt mr-2 sm:mr-3"></i>Transaction History
            </h1>
            <p class="text-xs sm:text-sm text-green-100">Track all your earnings and payouts</p>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3 sm:gap-4 md:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-xs sm:text-sm">Total Earnings</p>
                <i class="fas fa-arrow-up text-green-600 text-lg sm:text-xl"></i>
            </div>
            <p class="text-2xl sm:text-3xl font-bold text-gray-800">₦{{ number_format($summary['total_earnings']) }}</p>
            <p class="text-xs text-gray-500 mt-1">All time</p>
        </div>

        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-xs sm:text-sm">Total Payouts</p>
                <i class="fas fa-arrow-down text-red-600 text-lg sm:text-xl"></i>
            </div>
            <p class="text-2xl sm:text-3xl font-bold text-gray-800">₦{{ number_format($summary['total_payouts']) }}</p>
            <p class="text-xs text-gray-500 mt-1">All time</p>
        </div>

        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 sm:col-span-2 md:col-span-1">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-xs sm:text-sm">Pending Balance</p>
                <i class="fas fa-wallet text-blue-600 text-lg sm:text-xl"></i>
            </div>
            <p class="text-2xl sm:text-3xl font-bold text-gray-800">₦{{ number_format($summary['pending_balance']) }}</p>
            <p class="text-xs text-gray-500 mt-1">Available for withdrawal</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <form method="GET" action="{{ route('vendor.transactions.index') }}" class="space-y-3 sm:space-y-0 sm:grid sm:grid-cols-2 md:grid-cols-4 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Transaction Type</label>
                <select name="type" class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
                    <option value="all" {{ $type === 'all' ? 'selected' : '' }}>All Transactions</option>
                    <option value="earnings" {{ $type === 'earnings' ? 'selected' : '' }}>Earnings Only</option>
                    <option value="payouts" {{ $type === 'payouts' ? 'selected' : '' }}>Payouts Only</option>
                </select>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Source</label>
                <select name="source" class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
                    <option value="all" {{ $source === 'all' ? 'selected' : '' }}>All Sources</option>
                    <option value="property" {{ $source === 'property' ? 'selected' : '' }}>Property Bookings</option>
                    <option value="car" {{ $source === 'car' ? 'selected' : '' }}>Car Rentals</option>
                    <option value="deposit" {{ $source === 'deposit' ? 'selected' : '' }}>Deposit Deductions</option>
                </select>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Start Date</label>
                <input type="date" name="start_date" value="{{ $startDate }}" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">End Date</label>
                <input type="date" name="end_date" value="{{ $endDate }}" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-green-600 focus:outline-none">
            </div>

            <div class="sm:col-span-2 md:col-span-4 flex flex-col sm:flex-row gap-2 sm:gap-3">
                <button type="submit" class="flex-1 sm:flex-none bg-green-600 text-white px-4 sm:px-6 py-2 rounded-lg hover:bg-green-700 font-semibold text-sm sm:text-base transition">
                    <i class="fas fa-filter mr-2"></i>Apply Filters
                </button>
                <a href="{{ route('vendor.transactions.index') }}" class="flex-1 sm:flex-none bg-gray-200 text-gray-700 px-4 sm:px-6 py-2 rounded-lg hover:bg-gray-300 font-semibold text-sm sm:text-base text-center transition">
                    <i class="fas fa-times mr-2"></i>Clear Filters
                </a>
            </div>
        </form>
    </div>

    <!-- Transactions Table/Cards -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg sm:text-xl font-bold text-gray-800">Transaction History</h2>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">{{ $total }} transaction(s) found</p>
        </div>

        @if($transactions->isEmpty())
            <div class="p-8 sm:p-12 text-center">
                <i class="fas fa-receipt text-gray-300 text-4xl sm:text-5xl md:text-6xl mb-3 sm:mb-4"></i>
                <p class="text-gray-500 text-base sm:text-lg">No transactions found</p>
                <p class="text-gray-400 text-xs sm:text-sm mt-2">Your transaction history will appear here</p>
            </div>
        @else
            <!-- Mobile Card View (visible on mobile) -->
            <div class="md:hidden divide-y divide-gray-200">
                @foreach($transactions as $transaction)
                    <div class="p-4 hover:bg-gray-50 transition">
                        <div class="flex justify-between items-start mb-3">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-1">
                                    @if($transaction['type'] === 'earning')
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-arrow-up mr-1"></i>Earning
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                            <i class="fas fa-arrow-down mr-1"></i>Payout
                                        </span>
                                    @endif
                                    <span class="text-xs text-gray-500">
                                        @if($transaction['source'] === 'property')
                                            <i class="fas fa-home mr-1"></i>Property
                                        @elseif($transaction['source'] === 'car')
                                            <i class="fas fa-car mr-1"></i>Car
                                        @elseif($transaction['source'] === 'deposit')
                                            <i class="fas fa-shield-alt mr-1"></i>Deposit
                                        @else
                                            <i class="fas fa-money-bill-wave mr-1"></i>Withdrawal
                                        @endif
                                    </span>
                                </div>
                                <p class="font-semibold text-sm text-gray-800">{{ $transaction['description'] }}</p>
                                @if(isset($transaction['details']['check_in']))
                                    <p class="text-xs text-gray-500 mt-1">
                                        {{ \Carbon\Carbon::parse($transaction['details']['check_in'])->format('M d') }} - 
                                        {{ \Carbon\Carbon::parse($transaction['details']['check_out'])->format('M d, Y') }}
                                    </p>
                                @elseif(isset($transaction['details']['pickup_date']))
                                    <p class="text-xs text-gray-500 mt-1">
                                        {{ \Carbon\Carbon::parse($transaction['details']['pickup_date'])->format('M d') }} - 
                                        {{ \Carbon\Carbon::parse($transaction['details']['return_date'])->format('M d, Y') }}
                                    </p>
                                @elseif(isset($transaction['details']['bank']))
                                    <p class="text-xs text-gray-500 mt-1">
                                        {{ $transaction['details']['bank'] }} - {{ $transaction['details']['account'] }}
                                    </p>
                                @endif
                            </div>
                            <span class="text-lg font-bold {{ $transaction['type'] === 'earning' ? 'text-green-600' : 'text-red-600' }}">
                                {{ $transaction['type'] === 'earning' ? '+' : '-' }}₦{{ number_format($transaction['amount']) }}
                            </span>
                        </div>
                        
                        <div class="flex items-center justify-between text-xs text-gray-500">
                            <span>{{ \Carbon\Carbon::parse($transaction['date'])->format('M d, Y h:i A') }}</span>
                            @if($transaction['status'] === 'completed' || $transaction['status'] === 'paid')
                                <span class="inline-flex items-center px-2 py-1 rounded-full font-semibold bg-green-100 text-green-800">
                                    <i class="fas fa-check-circle mr-1"></i>Completed
                                </span>
                            @elseif($transaction['status'] === 'pending')
                                <span class="inline-flex items-center px-2 py-1 rounded-full font-semibold bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-clock mr-1"></i>Pending
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-1 rounded-full font-semibold bg-blue-100 text-blue-800">
                                    <i class="fas fa-spinner mr-1"></i>Processing
                                </span>
                            @endif
                        </div>
                        
                        <p class="text-xs font-mono text-gray-400 mt-2">Ref: {{ $transaction['reference'] }}</p>
                    </div>
                @endforeach
            </div>

            <!-- Desktop Table View (hidden on mobile) -->
            <div class="hidden md:block overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Reference</th>
                            <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-3 text-center text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($transactions as $transaction)
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                    {{ \Carbon\Carbon::parse($transaction['date'])->format('M d, Y') }}
                                    <br>
                                    <span class="text-xs text-gray-400">{{ \Carbon\Carbon::parse($transaction['date'])->format('h:i A') }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($transaction['type'] === 'earning')
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-arrow-up mr-1"></i>Earning
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                            <i class="fas fa-arrow-down mr-1"></i>Payout
                                        </span>
                                    @endif
                                    <br>
                                    <span class="text-xs text-gray-500 mt-1">
                                        @if($transaction['source'] === 'property')
                                            <i class="fas fa-home mr-1"></i>Property
                                        @elseif($transaction['source'] === 'car')
                                            <i class="fas fa-car mr-1"></i>Car Rental
                                        @elseif($transaction['source'] === 'deposit')
                                            <i class="fas fa-shield-alt mr-1"></i>Deposit
                                        @else
                                            <i class="fas fa-money-bill-wave mr-1"></i>Withdrawal
                                        @endif
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-800">
                                    <p class="font-semibold">{{ $transaction['description'] }}</p>
                                    @if(isset($transaction['details']['check_in']))
                                        <p class="text-xs text-gray-500 mt-1">
                                            {{ \Carbon\Carbon::parse($transaction['details']['check_in'])->format('M d') }} - 
                                            {{ \Carbon\Carbon::parse($transaction['details']['check_out'])->format('M d, Y') }}
                                        </p>
                                    @elseif(isset($transaction['details']['pickup_date']))
                                        <p class="text-xs text-gray-500 mt-1">
                                            {{ \Carbon\Carbon::parse($transaction['details']['pickup_date'])->format('M d') }} - 
                                            {{ \Carbon\Carbon::parse($transaction['details']['return_date'])->format('M d, Y') }}
                                        </p>
                                    @elseif(isset($transaction['details']['bank']))
                                        <p class="text-xs text-gray-500 mt-1">
                                            {{ $transaction['details']['bank'] }} - {{ $transaction['details']['account'] }}
                                        </p>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-xs font-mono text-gray-600">{{ $transaction['reference'] }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right">
                                    <span class="text-lg font-bold {{ $transaction['type'] === 'earning' ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $transaction['type'] === 'earning' ? '+' : '-' }}₦{{ number_format($transaction['amount']) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    @if($transaction['status'] === 'completed' || $transaction['status'] === 'paid')
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>Completed
                                        </span>
                                    @elseif($transaction['status'] === 'pending')
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-yellow-100 text-yellow-800">
                                            <i class="fas fa-clock mr-1"></i>Pending
                                        </span>
                                    @elseif($transaction['status'] === 'processing')
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-blue-100 text-blue-800">
                                            <i class="fas fa-spinner mr-1"></i>Processing
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-gray-100 text-gray-800">
                                            {{ ucfirst($transaction['status']) }}
                                        </span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($total > $perPage)
                <div class="px-4 sm:px-6 py-3 sm:py-4 border-t bg-gray-50">
                    <div class="flex flex-col sm:flex-row items-center justify-between gap-3">
                        <p class="text-xs sm:text-sm text-gray-600 text-center sm:text-left">
                            Showing {{ ($currentPage - 1) * $perPage + 1 }} to {{ min($currentPage * $perPage, $total) }} of {{ $total }} transactions
                        </p>
                        <div class="flex gap-2">
                            @if($currentPage > 1)
                                <a href="{{ route('vendor.transactions.index', array_merge(request()->query(), ['page' => $currentPage - 1])) }}" 
                                    class="px-3 sm:px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 text-xs sm:text-sm font-semibold">
                                    <i class="fas fa-chevron-left mr-1"></i>Previous
                                </a>
                            @endif
                            @if($currentPage * $perPage < $total)
                                <a href="{{ route('vendor.transactions.index', array_merge(request()->query(), ['page' => $currentPage + 1])) }}" 
                                    class="px-3 sm:px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 text-xs sm:text-sm font-semibold">
                                    Next<i class="fas fa-chevron-right ml-1"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        @endif
    </div>

    <!-- Export Button -->
    <div class="mt-4 sm:mt-6 text-center">
        <button onclick="window.print()" class="w-full sm:w-auto bg-gray-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-gray-700 font-semibold text-sm sm:text-base transition no-print">
            <i class="fas fa-download mr-2"></i>Export Transactions
        </button>
    </div>
</div>

<style>
@media print {
    .no-print {
        display: none !important;
    }
}
</style>
@endsection