@extends('layouts.vendor')

@section('title', 'Add Room Type - ' . $property->title)

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('vendor.properties.edit', $property) }}" class="text-primary hover:text-primary-dark font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i> Back to Property Edit
        </a>
    </div>

    <!-- Header -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
            <i class="fas fa-door-open mr-2 sm:mr-3"></i>Add Room Type
        </h1>
        <p class="text-sm sm:text-base opacity-90">{{ $property->title }}</p>
    </div>

    <form method="POST" action="{{ route('vendor.properties.rooms.store', $property) }}" enctype="multipart/form-data">
        @csrf

        <!-- Room Type Details -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-info-circle text-primary mr-2 sm:mr-3"></i> Room Type Details
            </h2>

            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Room Type Name *</label>
                <input type="text" name="room_type" value="{{ old('room_type') }}" 
                    placeholder="e.g., Deluxe Suite, Standard Room, Executive Room" required
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                @error('room_type')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="3" 
                    placeholder="Describe this room type..."
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">{{ old('description') }}</textarea>
                @error('description')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-money-bill-wave text-green-600 mr-2"></i>Price per Night (₦) *
                    </label>
                    <input type="number" name="price_per_night" value="{{ old('price_per_night') }}" 
                        min="0" step="0.01" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('price_per_night')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-boxes text-blue-600 mr-2"></i>Total Units Available *
                    </label>
                    <input type="number" name="total_units" value="{{ old('total_units', 1) }}" 
                        min="1" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('total_units')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-users text-purple-600 mr-2"></i>Max Guests *
                    </label>
                    <input type="number" name="max_guests" value="{{ old('max_guests', 2) }}" 
                        min="1" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('max_guests')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-ruler-combined text-orange-600 mr-2"></i>Room Size (sqm)
                    </label>
                    <input type="number" name="room_size_sqm" value="{{ old('room_size_sqm') }}" 
                        min="0" step="0.01"
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('room_size_sqm')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-bed text-primary mr-2"></i>Bedrooms *
                    </label>
                    <input type="number" name="bedrooms" value="{{ old('bedrooms', 1) }}" 
                        min="0" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('bedrooms')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-bed text-primary mr-2"></i>Beds *
                    </label>
                    <input type="number" name="beds" value="{{ old('beds', 1) }}" 
                        min="0" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('beds')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-bath text-primary mr-2"></i>Bathrooms *
                    </label>
                    <input type="number" name="bathrooms" value="{{ old('bathrooms', 1) }}" 
                        min="0" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('bathrooms')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Room Amenities -->
            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-3">
                    <i class="fas fa-star text-yellow-600 mr-2"></i>Room Amenities
                </label>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3">
                    @php
                    $roomAmenities = [
                        'Air Conditioning', 'Mini Bar', 'TV', 'WiFi', 'Safe', 'Balcony',
                        'Coffee Maker', 'Desk', 'Iron', 'Hair Dryer', 'Bathtub', 'Shower',
                        'Telephone', 'Room Service', 'Towels', 'Toiletries'
                    ];
                    @endphp
                    @foreach($roomAmenities as $amenity)
                    <label class="flex items-center space-x-2 bg-gray-50 p-2 rounded-lg cursor-pointer hover:bg-gray-100 transition">
                        <input type="checkbox" name="amenities[]" value="{{ $amenity }}" 
                               {{ in_array($amenity, old('amenities', [])) ? 'checked' : '' }}
                               class="w-4 h-4 text-primary rounded">
                        <span class="text-xs sm:text-sm">{{ $amenity }}</span>
                    </label>
                    @endforeach
                </div>
            </div>

            <!-- Room Photos -->
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-camera text-primary mr-2"></i>Room Photos
                </label>
                <input type="file" name="photos[]" multiple accept="image/*" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition"
                    onchange="previewImages(this)">
                <p class="text-xs text-gray-600 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>
                    You can select multiple images (Max 5MB each)
                </p>
                @error('photos.*')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
                <div id="photoPreview" class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3 sm:gap-4 mt-4"></div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                <button type="submit" 
                    class="flex-1 bg-primary text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-primary-dark font-bold text-base sm:text-lg transition">
                    <i class="fas fa-save mr-2"></i> Add Room Type
                </button>
                <a href="{{ route('vendor.properties.edit', $property) }}" 
                    class="flex-1 bg-gray-300 text-gray-700 px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-gray-400 font-bold text-base sm:text-lg text-center transition">
                    <i class="fas fa-times mr-2"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
function previewImages(input) {
    const container = document.getElementById('photoPreview');
    container.innerHTML = '';
    
    if (input.files) {
        Array.from(input.files).forEach((file) => {
            const reader = new FileReader();
            reader.onload = function(e) {
                const div = document.createElement('div');
                div.className = 'relative';
                div.innerHTML = `
                    <img src="${e.target.result}" class="w-full h-32 sm:h-40 object-cover rounded-lg">
                `;
                container.appendChild(div);
            };
            reader.readAsDataURL(file);
        });
    }
}
</script>
@endpush
@endsection