@extends('layouts.vendor')

@section('title', 'Edit Car')

@section('content')
<div class="max-w-6xl mx-auto px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-edit mr-3"></i>Edit Car
                    </h1>
                    <p class="text-blue-100">{{ $car->full_name }} - {{ $car->plate_number }}</p>
                </div>
                <a href="{{ route('vendor.cars.index') }}" 
                    class="bg-white/20 backdrop-blur-sm text-white px-6 py-3 rounded-lg hover:bg-white/30 transition">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Cars
                </a>
            </div>
        </div>
    </div>

    <!-- Status Alert -->
    @if($car->status === 'rejected')
        <div class="bg-red-50 border-2 border-red-200 rounded-xl p-6 mb-6">
            <div class="flex items-start">
                <div class="bg-red-500 text-white rounded-full p-3 mr-4">
                    <i class="fas fa-times-circle text-2xl"></i>
                </div>
                <div class="flex-1">
                    <h3 class="text-xl font-bold text-red-800 mb-2">Car Rejected</h3>
                    @if($car->rejection_reason)
                        <div class="bg-white rounded-lg p-4 mb-3">
                            <p class="text-sm text-gray-600 mb-1">Rejection Reason:</p>
                            <p class="text-red-700 font-semibold">{{ $car->rejection_reason }}</p>
                        </div>
                    @endif
                    <p class="text-red-700">Please update the information and resubmit.</p>
                </div>
            </div>
        </div>
    @elseif($car->status === 'pending')
        <div class="bg-yellow-50 border-2 border-yellow-200 rounded-xl p-6 mb-6">
            <div class="flex items-center">
                <div class="bg-yellow-500 text-white rounded-full p-3 mr-4">
                    <i class="fas fa-clock text-2xl"></i>
                </div>
                <div>
                    <h3 class="text-xl font-bold text-yellow-800 mb-1">Under Review</h3>
                    <p class="text-yellow-700">Your car is being reviewed by admin. You can still make updates.</p>
                </div>
            </div>
        </div>
    @elseif($car->status === 'approved')
        <div class="bg-green-50 border-2 border-green-200 rounded-xl p-6 mb-6">
            <div class="flex items-center">
                <div class="bg-green-500 text-white rounded-full p-3 mr-4">
                    <i class="fas fa-check-circle text-2xl"></i>
                </div>
                <div>
                    <h3 class="text-xl font-bold text-green-800 mb-1">Car Approved!</h3>
                    <p class="text-green-700">Your car is live and available for bookings.</p>
                </div>
            </div>
        </div>
    @endif

    <form method="POST" action="{{ route('vendor.cars.update', $car) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        @include('vendor.cars._form_basic')
        @include('vendor.cars._form_specs')
        @include('vendor.cars._form_location')
        @include('vendor.cars._form_pricing')
        @include('vendor.cars._form_requirements')
        @include('vendor.cars._form_photos')
        @include('vendor.cars._form_description')

        <!-- Submit Button -->
        <div class="flex items-center justify-between bg-gradient-to-r from-gray-50 to-gray-100 p-6 rounded-xl shadow-lg">
            <div class="flex items-center">
                <div class="bg-blue-600/10 p-3 rounded-lg mr-4">
                    <i class="fas fa-info-circle text-blue-600 text-2xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-gray-800">Ready to update?</p>
                    <p class="text-sm text-gray-600">Changes will be saved immediately</p>
                </div>
            </div>
            <button type="submit" 
                class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-8 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold flex items-center">
                <i class="fas fa-save mr-2"></i>Update Car
            </button>
        </div>
    </form>
</div>
@endsection
