<!-- Specifications Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-cogs mr-3"></i>Specifications
        </h2>
    </div>
    <div class="p-6">
        <div class="grid md:grid-cols-3 gap-6">
            <!-- Transmission -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-cog text-blue-600 mr-2"></i>Transmission *
                </label>
                <select name="transmission" required
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition @error('transmission') border-red-500 @enderror">
                    <option value="">Select</option>
                    <option value="automatic" {{ old('transmission', $car->transmission ?? '') == 'automatic' ? 'selected' : '' }}>Automatic</option>
                    <option value="manual" {{ old('transmission', $car->transmission ?? '') == 'manual' ? 'selected' : '' }}>Manual</option>
                </select>
                @error('transmission')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Fuel Type -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-gas-pump text-blue-600 mr-2"></i>Fuel Type *
                </label>
                <select name="fuel_type" required
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition @error('fuel_type') border-red-500 @enderror">
                    <option value="">Select</option>
                    <option value="petrol" {{ old('fuel_type', $car->fuel_type ?? '') == 'petrol' ? 'selected' : '' }}>Petrol</option>
                    <option value="diesel" {{ old('fuel_type', $car->fuel_type ?? '') == 'diesel' ? 'selected' : '' }}>Diesel</option>
                    <option value="electric" {{ old('fuel_type', $car->fuel_type ?? '') == 'electric' ? 'selected' : '' }}>Electric</option>
                    <option value="hybrid" {{ old('fuel_type', $car->fuel_type ?? '') == 'hybrid' ? 'selected' : '' }}>Hybrid</option>
                </select>
                @error('fuel_type')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Seats -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-users text-blue-600 mr-2"></i>Seats *
                </label>
                <input type="number" name="seats" value="{{ old('seats', $car->seats ?? 5) }}" required
                    min="1" max="50"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition @error('seats') border-red-500 @enderror">
                @error('seats')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Doors -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-door-open text-blue-600 mr-2"></i>Doors *
                </label>
                <input type="number" name="doors" value="{{ old('doors', $car->doors ?? 4) }}" required
                    min="2" max="10"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition @error('doors') border-red-500 @enderror">
                @error('doors')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Luggage Capacity -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-suitcase text-blue-600 mr-2"></i>Luggage Capacity *
                </label>
                <input type="number" name="luggage_capacity" value="{{ old('luggage_capacity', $car->luggage_capacity ?? 2) }}" required
                    min="0" max="20" placeholder="Number of large bags"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition @error('luggage_capacity') border-red-500 @enderror">
                @error('luggage_capacity')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Air Conditioning -->
            <div class="flex items-center pt-8">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="air_conditioning" value="1" 
                        {{ old('air_conditioning', $car->air_conditioning ?? true) ? 'checked' : '' }}
                        class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                    <span class="ml-3 text-sm font-semibold text-gray-700">
                        <i class="fas fa-snowflake text-blue-600 mr-2"></i>Air Conditioning
                    </span>
                </label>
            </div>
        </div>

        <!-- Features -->
        <div class="mt-6">
            <label class="block text-sm font-semibold text-gray-700 mb-3">
                <i class="fas fa-star text-blue-600 mr-2"></i>Additional Features
            </label>
            <div class="grid md:grid-cols-4 gap-4">
                @php
                    $features = ['GPS Navigation', 'Bluetooth', 'USB Port', 'Backup Camera', 'Parking Sensors', 'Sunroof', 'Leather Seats', 'Heated Seats', 'Cruise Control', 'Keyless Entry', 'Child Seat Available', 'Aux Input'];
                    $selectedFeatures = old('features', $car->features ?? []);
                @endphp
                @foreach($features as $feature)
                    <label class="flex items-center cursor-pointer p-3 bg-gray-50 rounded-lg hover:bg-blue-50 transition">
                        <input type="checkbox" name="features[]" value="{{ $feature }}" 
                            {{ in_array($feature, $selectedFeatures) ? 'checked' : '' }}
                            class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <span class="ml-2 text-sm text-gray-700">{{ $feature }}</span>
                    </label>
                @endforeach
            </div>
        </div>
    </div>
</div>
