<!-- Pricing Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-yellow-600 to-orange-600 text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-money-bill-wave mr-3"></i>Pricing
        </h2>
    </div>
    <div class="p-6">
        <div class="grid md:grid-cols-3 gap-6">
            <!-- Price Per Day -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-calendar-day text-yellow-600 mr-2"></i>Price Per Day (₦) *
                </label>
                <input type="number" name="price_per_day" value="{{ old('price_per_day', $car->price_per_day ?? '') }}" required
                    min="0" step="0.01" placeholder="e.g., 15000"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition @error('price_per_day') border-red-500 @enderror">
                @error('price_per_day')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Price Per Week -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-calendar-week text-yellow-600 mr-2"></i>Price Per Week (₦)
                </label>
                <input type="number" name="price_per_week" value="{{ old('price_per_week', $car->price_per_week ?? '') }}"
                    min="0" step="0.01" placeholder="Optional"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition @error('price_per_week') border-red-500 @enderror">
                @error('price_per_week')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Price Per Month -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-calendar-alt text-yellow-600 mr-2"></i>Price Per Month (₦)
                </label>
                <input type="number" name="price_per_month" value="{{ old('price_per_month', $car->price_per_month ?? '') }}"
                    min="0" step="0.01" placeholder="Optional"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition @error('price_per_month') border-red-500 @enderror">
                @error('price_per_month')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Security Deposit -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-shield-alt text-yellow-600 mr-2"></i>Security Deposit (₦) *
                </label>
                <input type="number" name="security_deposit" value="{{ old('security_deposit', $car->security_deposit ?? 0) }}" required
                    min="0" step="0.01" placeholder="e.g., 50000"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition @error('security_deposit') border-red-500 @enderror">
                @error('security_deposit')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Minimum Rental Days -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-hourglass-start text-yellow-600 mr-2"></i>Minimum Rental Days *
                </label>
                <input type="number" name="minimum_rental_days" value="{{ old('minimum_rental_days', $car->minimum_rental_days ?? 1) }}" required
                    min="1" placeholder="e.g., 1"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition @error('minimum_rental_days') border-red-500 @enderror">
                @error('minimum_rental_days')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Maximum Rental Days -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-hourglass-end text-yellow-600 mr-2"></i>Maximum Rental Days
                </label>
                <input type="number" name="maximum_rental_days" value="{{ old('maximum_rental_days', $car->maximum_rental_days ?? '') }}"
                    min="1" placeholder="Optional"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition @error('maximum_rental_days') border-red-500 @enderror">
                @error('maximum_rental_days')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>
        </div>

        <!-- Insurance -->
        <div class="mt-6 p-4 bg-gray-50 rounded-lg">
            <div class="flex items-center mb-4">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="insurance_included" value="1" 
                        {{ old('insurance_included', $car->insurance_included ?? false) ? 'checked' : '' }}
                        class="w-5 h-5 text-yellow-600 border-gray-300 rounded focus:ring-yellow-500">
                    <span class="ml-3 text-sm font-semibold text-gray-700">
                        <i class="fas fa-umbrella text-yellow-600 mr-2"></i>Insurance Included
                    </span>
                </label>
            </div>
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Insurance Cost Per Day (₦)</label>
                <input type="number" name="insurance_cost_per_day" value="{{ old('insurance_cost_per_day', $car->insurance_cost_per_day ?? '') }}"
                    min="0" step="0.01" placeholder="e.g., 2000"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition">
            </div>
        </div>

        <!-- Mileage -->
        <div class="mt-6 p-4 bg-gray-50 rounded-lg">
            <h3 class="text-sm font-semibold text-gray-700 mb-4">
                <i class="fas fa-tachometer-alt text-yellow-600 mr-2"></i>Mileage Limits
            </h3>
            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Mileage Limit Per Day (km)</label>
                    <input type="number" name="mileage_limit_per_day" value="{{ old('mileage_limit_per_day', $car->mileage_limit_per_day ?? '') }}"
                        min="0" placeholder="e.g., 200"
                        class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition">
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Extra Mileage Cost (₦/km)</label>
                    <input type="number" name="extra_mileage_cost" value="{{ old('extra_mileage_cost', $car->extra_mileage_cost ?? '') }}"
                        min="0" step="0.01" placeholder="e.g., 50"
                        class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-yellow-600 focus:outline-none transition">
                </div>
            </div>
        </div>
    </div>
</div>
