<!-- Basic Information Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-info-circle mr-3"></i>Basic Information
        </h2>
    </div>
    <div class="p-6">
        <div class="grid md:grid-cols-2 gap-6">
            <!-- Category -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-tag text-green-600 mr-2"></i>Category *
                </label>
                <select name="car_category_id" required
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-green-600 focus:outline-none transition @error('car_category_id') border-red-500 @enderror">
                    <option value="">Select Category</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ old('car_category_id', $car->car_category_id ?? '') == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </select>
                @error('car_category_id')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Brand -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-car text-green-600 mr-2"></i>Brand *
                </label>
                <input type="text" name="brand" value="{{ old('brand', $car->brand ?? '') }}" required
                    placeholder="e.g., Toyota, Honda, Mercedes"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-green-600 focus:outline-none transition @error('brand') border-red-500 @enderror">
                @error('brand')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Model -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-car-side text-green-600 mr-2"></i>Model *
                </label>
                <input type="text" name="model" value="{{ old('model', $car->model ?? '') }}" required
                    placeholder="e.g., Camry, Accord, E-Class"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-green-600 focus:outline-none transition @error('model') border-red-500 @enderror">
                @error('model')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Year -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-calendar text-green-600 mr-2"></i>Year *
                </label>
                <input type="number" name="year" value="{{ old('year', $car->year ?? date('Y')) }}" required
                    min="1900" max="{{ date('Y') + 1 }}"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-green-600 focus:outline-none transition @error('year') border-red-500 @enderror">
                @error('year')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Plate Number -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-id-card text-green-600 mr-2"></i>Plate Number *
                </label>
                <input type="text" name="plate_number" value="{{ old('plate_number', $car->plate_number ?? '') }}" required
                    placeholder="e.g., ABC-123-XY"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-green-600 focus:outline-none transition @error('plate_number') border-red-500 @enderror">
                @error('plate_number')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Color -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-palette text-green-600 mr-2"></i>Color *
                </label>
                <input type="text" name="color" value="{{ old('color', $car->color ?? '') }}" required
                    placeholder="e.g., Black, White, Silver"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-green-600 focus:outline-none transition @error('color') border-red-500 @enderror">
                @error('color')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>
        </div>
    </div>
</div>
