@extends('layouts.vendor')

@section('title', 'Car Booking Details')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <a href="{{ route('vendor.bookings.index') }}" class="text-primary hover:text-primary-dark font-semibold mb-4 inline-block">
            <i class="fas fa-arrow-left mr-2"></i>Back to Bookings
        </a>
        <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-xl shadow-lg p-6">
            <div class="flex justify-between items-start">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-car mr-3"></i>Car Booking Details
                    </h1>
                    <p class="text-green-100">Booking Reference: <span class="font-mono font-bold">{{ $booking->booking_reference }}</span></p>
                </div>
                <span class="px-4 py-2 rounded-full text-sm font-bold
                    @if($booking->status === 'confirmed') bg-green-200 text-green-900
                    @elseif($booking->status === 'pending') bg-yellow-200 text-yellow-900
                    @elseif($booking->status === 'active') bg-blue-200 text-blue-900
                    @elseif($booking->status === 'completed') bg-gray-200 text-gray-900
                    @elseif($booking->status === 'cancelled') bg-red-200 text-red-900
                    @else bg-white text-gray-900
                    @endif">
                    {{ ucfirst($booking->status) }}
                </span>
            </div>
        </div>
    </div>

    <div class="grid lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Car Details -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-car text-green-600 mr-2"></i>Car Details
                </h2>
                
                <div class="flex flex-col md:flex-row gap-6">
                    @if($booking->car->main_photo)
                        <img src="{{ asset('storage/' . $booking->car->main_photo) }}" 
                            alt="{{ $booking->car->full_name }}"
                            class="w-full md:w-64 h-48 object-cover rounded-lg">
                    @endif
                    
                    <div class="flex-1">
                        <h3 class="text-2xl font-bold text-gray-800 mb-2">{{ $booking->car->full_name }}</h3>
                        <p class="text-gray-600 mb-3">{{ $booking->car->category->name }}</p>
                        
                        <div class="grid grid-cols-2 gap-3 text-sm">
                            <div>
                                <p class="text-gray-600">Transmission</p>
                                <p class="font-semibold">{{ ucfirst($booking->car->transmission) }}</p>
                            </div>
                            <div>
                                <p class="text-gray-600">Fuel Type</p>
                                <p class="font-semibold">{{ ucfirst($booking->car->fuel_type) }}</p>
                            </div>
                            <div>
                                <p class="text-gray-600">Seats</p>
                                <p class="font-semibold">{{ $booking->car->seats }} Passengers</p>
                            </div>
                            <div>
                                <p class="text-gray-600">Location</p>
                                <p class="font-semibold">{{ $booking->car->city }}, {{ $booking->car->state }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Rental Period -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-calendar text-green-600 mr-2"></i>Rental Period
                </h2>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="bg-green-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Pickup</p>
                        <p class="text-lg font-bold text-gray-800">{{ \Carbon\Carbon::parse($booking->pickup_date)->format('l, M d, Y') }}</p>
                        <p class="text-gray-600">{{ \Carbon\Carbon::parse($booking->pickup_time, 'UTC')->format('h:i A') }}</p>
                    </div>
                    
                    <div class="bg-red-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Return</p>
                        <p class="text-lg font-bold text-gray-800">{{ \Carbon\Carbon::parse($booking->return_date)->format('l, M d, Y') }}</p>
                        <p class="text-gray-600">{{ \Carbon\Carbon::parse($booking->return_time, 'UTC')->format('h:i A') }}</p>
                    </div>
                </div>
                
                <div class="mt-4 p-4 bg-blue-50 rounded-lg">
                    <p class="text-center text-gray-700">
                        <span class="font-bold text-2xl text-blue-600">{{ $booking->total_days }}</span>
                        <span class="text-gray-600 ml-2">{{ Str::plural('day', $booking->total_days) }} rental</span>
                    </p>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-user text-green-600 mr-2"></i>Customer Information
                </h2>
                
                @if($booking->payment_status === 'paid' || $booking->payment_status === 'verified')
                    <div class="grid md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <p class="text-sm text-gray-600">Name</p>
                            <p class="font-semibold">{{ $booking->user->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email</p>
                            <p class="font-semibold">{{ $booking->user->email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Phone</p>
                            <p class="font-semibold">{{ $booking->user->phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">User ID</p>
                            <p class="font-semibold">#{{ $booking->user->id }}</p>
                        </div>
                    </div>
                @else
                    <div class="p-6 bg-yellow-50 border-l-4 border-yellow-500 rounded">
                        <div class="flex items-start">
                            <i class="fas fa-lock text-yellow-600 text-2xl mr-3 mt-1"></i>
                            <div>
                                <p class="font-semibold text-yellow-800 mb-2">Payment Pending</p>
                                <p class="text-sm text-yellow-700">
                                    Customer contact information will be available once payment is confirmed.
                                </p>
                                @if($booking->payment_status === 'pending_verification')
                                    <p class="text-sm text-yellow-700 mt-2">
                                        <i class="fas fa-clock mr-1"></i>Payment proof submitted - awaiting admin verification.
                                    </p>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Driver Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-id-card text-green-600 mr-2"></i>Driver Information
                </h2>
                
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Driver Name</p>
                        <p class="font-semibold">{{ $booking->driver_name }}</p>
                    </div>
                    @if($booking->payment_status === 'paid' || $booking->payment_status === 'verified')
                        <div>
                            <p class="text-sm text-gray-600">Phone</p>
                            <p class="font-semibold">{{ $booking->driver_phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email</p>
                            <p class="font-semibold">{{ $booking->driver_email }}</p>
                        </div>
                    @else
                        <div class="col-span-2">
                            <p class="text-sm text-gray-600">Contact Information</p>
                            <p class="text-yellow-600 text-sm bg-yellow-50 p-2 rounded">
                                <i class="fas fa-lock mr-1"></i> Contact details will be available after payment is confirmed
                            </p>
                        </div>
                    @endif
                    <div>
                        <p class="text-sm text-gray-600">Age</p>
                        <p class="font-semibold">{{ $booking->driver_age }} years</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">License Number</p>
                        <p class="font-semibold">{{ $booking->driver_license_number }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">License Expiry</p>
                        <p class="font-semibold">{{ \Carbon\Carbon::parse($booking->driver_license_expiry)->format('M d, Y') }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Driving Experience</p>
                        <p class="font-semibold">{{ $booking->driver_experience_years }} years</p>
                    </div>
                    @if($booking->driver_license_photo)
                        <div class="col-span-2">
                            <p class="text-sm text-gray-600 mb-2">License Photo</p>
                            <img src="{{ asset('storage/' . $booking->driver_license_photo) }}" 
                                alt="Driver License" 
                                class="w-64 h-auto rounded-lg border">
                        </div>
                    @endif
                </div>
                
                <!-- Additional Options -->
                @if($booking->with_driver || $booking->airport_pickup)
                    <div class="mt-4 border-t pt-4">
                        <h3 class="font-bold text-gray-800 mb-3 text-sm">Additional Options</h3>
                        <div class="space-y-2">
                            @if($booking->with_driver)
                                <div class="flex items-center p-3 bg-blue-50 border-l-4 border-blue-500 rounded">
                                    <i class="fas fa-user-tie text-blue-600 mr-3 text-xl"></i>
                                    <div>
                                        <p class="font-semibold text-blue-800">Rent with Driver</p>
                                        <p class="text-sm text-blue-700">Professional driver included (₦{{ number_format($booking->driver_cost) }})</p>
                                    </div>
                                </div>
                            @endif
                            
                            @if($booking->airport_pickup)
                                <div class="flex items-center p-3 bg-green-50 border-l-4 border-green-500 rounded">
                                    <i class="fas fa-plane text-green-600 mr-3 text-xl"></i>
                                    <div>
                                        <p class="font-semibold text-green-800">Airport Pickup</p>
                                        <p class="text-sm text-green-700">Airport pickup service requested (₦{{ number_format($booking->airport_pickup_cost) }})</p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                @if($booking->special_requests)
                    <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Special Requests</p>
                        <p class="text-gray-800">{{ $booking->special_requests }}</p>
                    </div>
                @endif
            </div>

            <!-- Payment Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-credit-card text-green-600 mr-2"></i>Payment Information
                </h2>
                
                <div class="grid md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <p class="text-sm text-gray-600">Payment Status</p>
                        <span class="inline-block px-3 py-1 rounded-full text-sm font-semibold mt-1
                            @if($booking->payment_status === 'paid') bg-green-100 text-green-800
                            @elseif($booking->payment_status === 'pending_verification') bg-yellow-100 text-yellow-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ ucfirst(str_replace('_', ' ', $booking->payment_status)) }}
                        </span>
                    </div>
                    @if($booking->payment_method)
                        <div>
                            <p class="text-sm text-gray-600">Payment Method</p>
                            <p class="font-semibold">{{ ucfirst(str_replace('_', ' ', $booking->payment_method)) }}</p>
                        </div>
                    @endif
                    @if($booking->payment_reference)
                        <div>
                            <p class="text-sm text-gray-600">Payment Reference</p>
                            <p class="font-mono font-semibold">{{ $booking->payment_reference }}</p>
                        </div>
                    @endif
                    @if($booking->paid_at)
                        <div>
                            <p class="text-sm text-gray-600">Paid At</p>
                            <p class="font-semibold">{{ $booking->paid_at->format('M d, Y h:i A') }}</p>
                        </div>
                    @endif
                </div>

                @if($booking->payment_proof)
                    <div class="mt-4">
                        <p class="text-sm text-gray-600 mb-2">Payment Proof</p>
                        <img src="{{ asset('storage/' . $booking->payment_proof) }}" 
                            alt="Payment Proof" 
                            class="w-64 h-auto rounded-lg border">
                    </div>
                @endif

            </div>

        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <!-- Cost Breakdown -->
            <div class="bg-white rounded-xl shadow-lg p-6 mb-6 sticky top-4">
                <h3 class="font-bold text-lg text-gray-800 mb-4">Cost Breakdown</h3>
                
                <div class="space-y-3 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Rental Cost</span>
                        <span class="font-semibold">₦{{ number_format($booking->rental_cost) }}</span>
                    </div>
                    
                    @if($booking->insurance_cost > 0)
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Insurance</span>
                            <span class="font-semibold">₦{{ number_format($booking->insurance_cost) }}</span>
                        </div>
                    @endif
                    
                    @if($booking->security_deposit > 0)
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Security Deposit</span>
                            <span class="font-semibold">₦{{ number_format($booking->security_deposit) }}</span>
                        </div>
                    @endif
                    
                    @if($booking->extra_charges > 0)
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Extra Charges</span>
                            <span class="font-semibold">₦{{ number_format($booking->extra_charges) }}</span>
                        </div>
                    @endif
                </div>
                
                <div class="border-t pt-3 mb-3">
                    <div class="flex justify-between items-center">
                        <span class="font-bold text-gray-800">Total Amount</span>
                        <span class="font-bold text-2xl text-green-600">₦{{ number_format($booking->total_amount) }}</span>
                    </div>
                </div>

                <!-- Commission Breakdown -->
                <div class="bg-red-50 border-2 border-red-200 rounded-lg p-4 mb-3">
                    <h4 class="font-bold text-sm text-red-800 mb-3 flex items-center">
                        <i class="fas fa-percentage mr-2"></i>Platform Commission
                    </h4>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-red-700">Commission Rate</span>
                            <span class="font-semibold text-red-800">{{ $booking->commission_rate }}%</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-red-700">Commission Amount</span>
                            <span class="font-semibold text-red-800">-₦{{ number_format($booking->commission_amount) }}</span>
                        </div>
                    </div>
                </div>

                <!-- Vendor Payout -->
                <div class="bg-green-50 border-2 border-green-300 rounded-lg p-4">
                    <div class="flex justify-between items-center">
                        <span class="font-bold text-green-800">Your Payout</span>
                        <span class="font-bold text-2xl text-green-700">₦{{ number_format($booking->vendor_payout_amount) }}</span>
                    </div>
                    <p class="text-xs text-green-700 mt-2">
                        <i class="fas fa-info-circle mr-1"></i>
                        Amount you'll receive after platform commission
                    </p>
                </div>
            </div>

            <!-- Quick Actions -->
            @if($booking->payment_status === 'paid' || $booking->payment_status === 'verified')
                <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                    <h3 class="font-bold text-lg text-gray-800 mb-4">Quick Actions</h3>
                    
                    <div class="space-y-3">
                        <a href="mailto:{{ $booking->driver_email }}" class="block w-full bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark font-semibold">
                            <i class="fas fa-envelope mr-2"></i>Email Customer
                        </a>
                        <a href="tel:{{ $booking->driver_phone }}" class="block w-full bg-green-600 text-white text-center py-3 rounded-lg hover:bg-green-700 font-semibold">
                            <i class="fas fa-phone mr-2"></i>Call Customer
                        </a>
                    </div>
                </div>
            @endif

            <!-- Damage Report (After Return) -->
            @if($booking->status === 'pending_inspection' && $booking->returned_at)
                <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                    <h3 class="font-bold text-lg text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-exclamation-triangle text-yellow-600 mr-2"></i>Vehicle Inspection
                    </h3>
                    
                    <p class="text-sm text-gray-600 mb-4">
                        The customer has returned the vehicle. Please inspect it and report any damages.
                    </p>

                    <form method="POST" action="{{ route('vendor.car-bookings.report-damage', $booking) }}" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Inspection Result
                            </label>
                            <select name="has_damage" required class="w-full border-gray-300 rounded-lg">
                                <option value="">Select...</option>
                                <option value="0">No Damage - Refund Deposit</option>
                                <option value="1">Damage Found - Deduct from Deposit</option>
                            </select>
                        </div>

                        <div id="damage-details" class="hidden">
                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Damage Description
                                </label>
                                <textarea name="damage_report" rows="4" 
                                    class="w-full border-gray-300 rounded-lg"
                                    placeholder="Describe the damages found..."></textarea>
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Deduction Amount (₦)
                                </label>
                                <input type="number" name="deposit_deduction_amount" 
                                    min="0" max="{{ $booking->security_deposit }}"
                                    class="w-full border-gray-300 rounded-lg"
                                    placeholder="Amount to deduct from deposit">
                                <p class="text-xs text-gray-500 mt-1">
                                    Maximum: ₦{{ number_format($booking->security_deposit) }}
                                </p>
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">
                                    Damage Photos (Optional)
                                </label>
                                <input type="file" name="damage_photos[]" multiple accept="image/*"
                                    class="w-full border-gray-300 rounded-lg">
                            </div>
                        </div>

                        <button type="submit" 
                            class="w-full bg-primary text-white py-3 rounded-lg hover:bg-primary-dark font-semibold transition">
                            <i class="fas fa-check-circle mr-2"></i>Submit Inspection Report
                        </button>
                    </form>

                    <script>
                        document.querySelector('select[name="has_damage"]').addEventListener('change', function() {
                            const damageDetails = document.getElementById('damage-details');
                            if (this.value === '1') {
                                damageDetails.classList.remove('hidden');
                                damageDetails.querySelectorAll('input, textarea').forEach(el => el.required = true);
                            } else {
                                damageDetails.classList.add('hidden');
                                damageDetails.querySelectorAll('input, textarea').forEach(el => el.required = false);
                            }
                        });
                    </script>
                </div>
            @endif

            <!-- Booking Timeline -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h3 class="font-bold text-lg text-gray-800 mb-4">Booking Timeline</h3>
                
                <div class="space-y-4">
                    <div class="flex items-start">
                        <div class="bg-green-100 rounded-full p-2 mr-3">
                            <i class="fas fa-plus text-green-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Booking Created</p>
                            <p class="text-xs text-gray-600">{{ $booking->created_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                    
                    @if($booking->confirmed_at)
                        <div class="flex items-start">
                            <div class="bg-blue-100 rounded-full p-2 mr-3">
                                <i class="fas fa-check text-blue-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Confirmed</p>
                                <p class="text-xs text-gray-600">{{ $booking->confirmed_at->format('M d, Y h:i A') }}</p>
                            </div>
                        </div>
                    @endif
                    
                    @if($booking->paid_at)
                        <div class="flex items-start">
                            <div class="bg-green-100 rounded-full p-2 mr-3">
                                <i class="fas fa-money-bill text-green-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Payment Received</p>
                                <p class="text-xs text-gray-600">{{ $booking->paid_at->format('M d, Y h:i A') }}</p>
                            </div>
                        </div>
                    @endif
                    
                    @if($booking->pickup_at)
                        <div class="flex items-start">
                            <div class="bg-purple-100 rounded-full p-2 mr-3">
                                <i class="fas fa-car text-purple-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Vehicle Picked Up</p>
                                <p class="text-xs text-gray-600">{{ $booking->pickup_at->format('M d, Y h:i A') }}</p>
                            </div>
                        </div>
                    @endif
                    
                    @if($booking->returned_at)
                        <div class="flex items-start">
                            <div class="bg-gray-100 rounded-full p-2 mr-3">
                                <i class="fas fa-flag-checkered text-gray-600"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-sm">Vehicle Returned</p>
                                <p class="text-xs text-gray-600">{{ $booking->returned_at->format('M d, Y h:i A') }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
