@extends('layouts.vendor')

@section('title', 'Booking Details #' . $booking->id)

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('vendor.bookings.index') }}" class="text-primary hover:text-primary-dark font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i> Back to Bookings
        </a>
    </div>

    <!-- Header Card -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start gap-3">
            <div class="flex-1">
                <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">Booking #{{ $booking->id }}</h1>
                <p class="text-sm sm:text-base opacity-90">
                    <i class="fas fa-home mr-2"></i>{{ $booking->property->title }}
                </p>
            </div>
            <div>
                <span class="px-3 sm:px-4 py-1.5 sm:py-2 rounded-full font-semibold text-xs sm:text-sm
                    @if($booking->booking_status === 'confirmed') bg-green-500 text-white
                    @elseif($booking->booking_status === 'pending') bg-yellow-400 text-gray-900
                    @elseif($booking->booking_status === 'completed') bg-blue-500 text-white
                    @else bg-gray-500 text-white
                    @endif">
                    <i class="fas fa-circle text-xs mr-1"></i> {{ ucfirst($booking->booking_status) }}
                </span>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6 mb-4 sm:mb-6">
        <!-- Main Content -->
        <div class="md:col-span-2 space-y-4 sm:space-y-6">

            <!-- Guest Information -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-user-circle text-primary mr-2 sm:mr-3"></i> Guest Information
                </h2>
                @if($booking->vendor_visible_user_info)
                    <div class="bg-blue-50 rounded-lg p-3 sm:p-4 space-y-2">
                        <p class="flex items-center text-sm sm:text-base">
                            <i class="fas fa-user text-primary mr-2 sm:mr-3 w-4 sm:w-5"></i>
                            <span class="font-semibold">{{ $booking->user->name }}</span>
                        </p>
                        <p class="flex items-center text-sm sm:text-base break-all">
                            <i class="fas fa-envelope text-primary mr-2 sm:mr-3 w-4 sm:w-5"></i>
                            <span>{{ $booking->user->email }}</span>
                        </p>
                        <p class="flex items-center text-sm sm:text-base">
                            <i class="fas fa-phone text-primary mr-2 sm:mr-3 w-4 sm:w-5"></i>
                            <span>{{ $booking->user->phone }}</span>
                        </p>
                    </div>
                @else
                    <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-3 sm:p-4 text-center">
                        <i class="fas fa-lock text-yellow-600 text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <p class="text-yellow-800 font-semibold text-sm sm:text-base">Contact Details Locked</p>
                        <p class="text-xs sm:text-sm text-yellow-700 mt-1">Guest contact details will be visible after payment confirmation</p>
                    </div>
                @endif
            </div>

            <!-- Stay Details -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-calendar-alt text-primary mr-2 sm:mr-3"></i> Stay Details
                </h2>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 mb-3 sm:mb-4">
                    <div class="bg-primary/5 rounded-lg p-3 sm:p-4">
                        <p class="text-xs text-gray-600 mb-1">Check-in</p>
                        <p class="font-bold text-primary text-sm sm:text-base">
                            <i class="fas fa-calendar-check mr-2"></i>{{ $booking->start_date->format('M d, Y') }}
                        </p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-3 sm:p-4">
                        <p class="text-xs text-gray-600 mb-1">Check-out</p>
                        <p class="font-bold text-primary text-sm sm:text-base">
                            <i class="fas fa-calendar-times mr-2"></i>{{ $booking->end_date->format('M d, Y') }}
                        </p>
                    </div>
                </div>
                <div class="grid grid-cols-3 gap-2 sm:gap-3">
                    <div class="text-center bg-light-bg rounded-lg p-2 sm:p-3">
                        <p class="text-xl sm:text-2xl font-bold text-primary">{{ $booking->nights_count }}</p>
                        <p class="text-xs text-gray-600">Nights</p>
                    </div>
                    <div class="text-center bg-light-bg rounded-lg p-2 sm:p-3">
                        <p class="text-xl sm:text-2xl font-bold text-primary">{{ $booking->guest_count }}</p>
                        <p class="text-xs text-gray-600">Guests</p>
                    </div>
                    <div class="text-center bg-light-bg rounded-lg p-2 sm:p-3">
                        <p class="text-xs sm:text-sm font-bold text-primary">{{ ucfirst($booking->trip_type) }}</p>
                        <p class="text-xs text-gray-600">Trip Type</p>
                    </div>
                </div>
            </div>

            <!-- Payment Summary -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-wallet text-primary mr-2 sm:mr-3"></i> Payment Summary
                </h2>
                <div class="space-y-2 sm:space-y-3">
                    <div class="flex justify-between items-center py-2 text-sm sm:text-base">
                        <span class="text-gray-700">Subtotal</span>
                        <span class="font-semibold">₦{{ number_format($booking->subtotal) }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 text-gray-600 text-sm sm:text-base">
                        <span>Caution Fee (Refundable)</span>
                        <span class="font-semibold">₦{{ number_format($booking->caution_fee_amount) }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 sm:py-3 border-t-2 border-primary">
                        <span class="font-bold text-base sm:text-lg">Total Paid by Guest</span>
                        <span class="font-bold text-xl sm:text-2xl text-primary">₦{{ number_format($booking->total_amount) }}</span>
                    </div>
                    <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-3 sm:p-4 mt-3 sm:mt-4">
                        <p class="text-xs text-gray-600 mb-1">Your Payout (after {{ $booking->commission_rate }}% commission)</p>
                        <p class="font-bold text-xl sm:text-2xl text-green-600">₦{{ number_format($booking->vendor_payout_amount) }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-4 sm:space-y-6">
            <!-- Property Info Card -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h3 class="font-bold text-secondary mb-3 flex items-center text-sm sm:text-base">
                    <i class="fas fa-home text-primary mr-2"></i> Property
                </h3>
                <p class="font-semibold text-base sm:text-lg">{{ $booking->property->title }}</p>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">
                    <i class="fas fa-map-marker-alt text-primary mr-1"></i>
                    {{ $booking->property->city }}, {{ $booking->property->state }}
                </p>
            </div>

            <!-- Caution Fee Status -->
            @if($booking->caution_refund_status !== 'pending')
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                    <h3 class="font-bold text-secondary mb-3 flex items-center text-sm sm:text-base">
                        <i class="fas fa-shield-alt text-primary mr-2"></i> Caution Fee Status
                    </h3>
                    <div class="p-3 sm:p-4 rounded-lg
                        @if($booking->caution_refund_status === 'approved') bg-green-50 border-l-4 border-green-500
                        @elseif($booking->caution_refund_status === 'rejected') bg-red-50 border-l-4 border-red-500
                        @else bg-blue-50 border-l-4 border-blue-500
                        @endif">
                        <p class="font-bold text-base sm:text-lg
                            @if($booking->caution_refund_status === 'approved') text-green-600
                            @elseif($booking->caution_refund_status === 'rejected') text-red-600
                            @else text-blue-600
                            @endif">
                            <i class="fas fa-circle text-xs mr-1"></i> {{ ucfirst($booking->caution_refund_status) }}
                        </p>
                        @if($booking->caution_refund_reason)
                            <p class="text-xs sm:text-sm text-gray-700 mt-2">{{ $booking->caution_refund_reason }}</p>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Caution Fee Management (Full Width) -->
    @if($booking->booking_status === 'completed' && $booking->checked_out_at && $booking->caution_refund_status === 'pending')
        <div class="mt-4 sm:mt-6 bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                <i class="fas fa-shield-alt text-primary mr-2 sm:mr-3"></i> Property Inspection & Caution Fee Decision
            </h2>
            
            <p class="text-xs sm:text-sm text-gray-600 mb-3 sm:mb-4">
                The guest has checked out. Please inspect the property and report any damages.
            </p>

            <form method="POST" action="{{ route('vendor.bookings.caution', $booking) }}" enctype="multipart/form-data">
                @csrf
                
                <div class="mb-3 sm:mb-4">
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        Inspection Result *
                    </label>
                    <select name="has_damage" id="hasDamage" required class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
                        <option value="">Select...</option>
                        <option value="0">No Damage - Refund Full Caution Fee (₦{{ number_format($booking->caution_fee_amount ?? $booking->caution_fee ?? 0) }})</option>
                        <option value="1">Damage Found - Deduct from Caution Fee</option>
                    </select>
                </div>

                <div id="damageDetails" class="hidden">
                    <div class="mb-3 sm:mb-4">
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                            Damage Description *
                        </label>
                        <textarea name="damage_description" rows="4" 
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none"
                            placeholder="Describe the damages found (e.g., broken furniture, stained carpet, missing items)..."></textarea>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                            Deduction Amount (₦) *
                        </label>
                        <input type="number" name="deduction_amount" min="0" max="{{ $booking->caution_fee_amount ?? $booking->caution_fee ?? 0 }}" step="0.01"
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none"
                            placeholder="Enter amount to deduct">
                        <p class="text-xs text-gray-500 mt-1">Maximum: ₦{{ number_format($booking->caution_fee_amount ?? $booking->caution_fee ?? 0) }}</p>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                            Damage Photos (Optional)
                        </label>
                        <input type="file" name="damage_photos[]" multiple accept="image/*"
                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none">
                        <p class="text-xs text-gray-500 mt-1">Upload photos of the damage (max 5 images)</p>
                    </div>
                </div>

                <button type="submit" class="w-full sm:w-auto bg-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-sm sm:text-base transition">
                    <i class="fas fa-save mr-2"></i> Submit Inspection Report
                </button>
            </form>

            <script>
                document.getElementById('hasDamage').addEventListener('change', function() {
                    const damageDetails = document.getElementById('damageDetails');
                    if (this.value === '1') {
                        damageDetails.classList.remove('hidden');
                        damageDetails.querySelectorAll('input, textarea').forEach(el => el.required = true);
                    } else {
                        damageDetails.classList.add('hidden');
                        damageDetails.querySelectorAll('input, textarea').forEach(el => el.required = false);
                    }
                });
            </script>
        </div>
    @endif

    <!-- Caution Refund Logs -->
    @if($booking->cautionRefundLogs->count() > 0)
        <div class="mt-4 sm:mt-6 bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                <i class="fas fa-history text-primary mr-2 sm:mr-3"></i> Refund History
            </h2>
            <div class="space-y-2 sm:space-y-3">
                @foreach($booking->cautionRefundLogs as $log)
                    <div class="bg-light-bg border-l-4 border-primary p-3 sm:p-4 rounded-lg">
                        <p class="font-semibold text-secondary text-sm sm:text-base">{{ $log->actor->name }}</p>
                        <p class="text-xs sm:text-sm text-gray-700 mt-1">{{ $log->action }}</p>
                        <p class="text-xs text-gray-500 mt-2">
                            <i class="fas fa-clock mr-1"></i>{{ $log->created_at->format('M d, Y H:i') }}
                        </p>
                    </div>
                @endforeach
            </div>
        </div>
    @endif
</div>
@endsection