@extends('layouts.admin')

@section('title', 'Manage Reviews')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Manage Reviews</h1>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <form method="GET" class="grid md:grid-cols-3 gap-4">
            <input type="text" name="search" placeholder="Search by guest or property" 
                value="{{ request('search') }}" class="border rounded px-4 py-2">

            <select name="visible" class="border rounded px-4 py-2">
                <option value="">All Reviews</option>
                <option value="1" {{ request('visible') === '1' ? 'selected' : '' }}>Visible Only</option>
                <option value="0" {{ request('visible') === '0' ? 'selected' : '' }}>Hidden Only</option>
            </select>

            <button type="submit" class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                Filter
            </button>
        </form>
    </div>

    <!-- Reviews List -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="w-full">
            <thead class="bg-light-bg">
                <tr>
                    <th class="px-4 py-3 text-left">Guest</th>
                    <th class="px-4 py-3 text-left">Property</th>
                    <th class="px-4 py-3 text-left">Rating</th>
                    <th class="px-4 py-3 text-left">Comment</th>
                    <th class="px-4 py-3 text-left">Date</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($reviews as $review)
                    <tr class="border-b hover:bg-light-bg">
                        <td class="px-4 py-3">{{ $review->user->name }}</td>
                        <td class="px-4 py-3">{{ Str::limit($review->property->title, 30) }}</td>
                        <td class="px-4 py-3">
                            <span class="text-yellow-500">
                                @for($i = 0; $i < $review->rating; $i++)★@endfor
                            </span>
                        </td>
                        <td class="px-4 py-3 text-sm">{{ Str::limit($review->comment, 50) }}</td>
                        <td class="px-4 py-3 text-sm">{{ $review->created_at->format('M d, Y') }}</td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs
                                {{ $review->visible ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $review->visible ? 'Visible' : 'Hidden' }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <button onclick="document.getElementById('moderate-form-{{ $review->id }}').classList.toggle('hidden')"
                                class="text-primary hover:underline text-sm">
                                Moderate
                            </button>

                            <form id="moderate-form-{{ $review->id }}" 
                                method="POST" 
                                action="{{ route('admin.reviews.moderate', $review) }}" 
                                class="hidden mt-2">
                                @csrf
                                <select name="action" class="border rounded px-2 py-1 text-sm" required>
                                    <option value="">Select action</option>
                                    <option value="hide">Hide</option>
                                    <option value="show">Show</option>
                                    <option value="delete">Delete</option>
                                </select>
                                <input type="text" name="reason" placeholder="Reason (optional)" 
                                    class="border rounded px-2 py-1 text-sm mt-1">
                                <button type="submit" class="bg-primary text-white px-2 py-1 rounded text-sm hover:bg-primary-dark mt-1">
                                    Submit
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center py-8 text-gray-600">No reviews found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $reviews->links() }}
    </div>
</div>
@endsection