@extends('layouts.app')

@section('title', 'Leave a Review')

@section('content')
<div class="max-w-3xl mx-auto">
    <h1 class="text-3xl font-bold mb-6">Leave a Review</h1>

    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <h3 class="font-bold text-lg mb-2">{{ $booking->property->title }}</h3>
        <p class="text-gray-600 mb-4">Your stay: {{ $booking->start_date->format('M d') }} - {{ $booking->end_date->format('M d, Y') }}</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form method="POST" action="{{ route('reviews.store', $booking) }}">
            @csrf

            <!-- Overall Rating -->
            <div class="mb-6">
                <label class="block text-gray-700 font-bold mb-2">Overall Rating *</label>
                <div class="flex gap-2">
                    @for($i = 1; $i <= 5; $i++)
                        <label class="cursor-pointer">
                            <input type="radio" name="rating" value="{{ $i }}" required class="hidden peer">
                            <span class="text-4xl peer-checked:text-yellow-500 text-gray-300 hover:text-yellow-400">★</span>
                        </label>
                    @endfor
                </div>
                @error('rating')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Detailed Ratings -->
            <div class="mb-6">
                <h3 class="font-bold mb-3">Rate Your Experience</h3>
                
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-gray-700 mb-2">Cleanliness</label>
                        <select name="cleanliness_rating" class="w-full border rounded px-4 py-2">
                            <option value="">Not rated</option>
                            @for($i = 1; $i <= 5; $i++)
                                <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 mb-2">Accuracy</label>
                        <select name="accuracy_rating" class="w-full border rounded px-4 py-2">
                            <option value="">Not rated</option>
                            @for($i = 1; $i <= 5; $i++)
                                <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 mb-2">Check-in</label>
                        <select name="checkin_rating" class="w-full border rounded px-4 py-2">
                            <option value="">Not rated</option>
                            @for($i = 1; $i <= 5; $i++)
                                <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 mb-2">Communication</label>
                        <select name="communication_rating" class="w-full border rounded px-4 py-2">
                            <option value="">Not rated</option>
                            @for($i = 1; $i <= 5; $i++)
                                <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 mb-2">Location</label>
                        <select name="location_rating" class="w-full border rounded px-4 py-2">
                            <option value="">Not rated</option>
                            @for($i = 1; $i <= 5; $i++)
                                <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 mb-2">Value</label>
                        <select name="value_rating" class="w-full border rounded px-4 py-2">
                            <option value="">Not rated</option>
                            @for($i = 1; $i <= 5; $i++)
                                <option value="{{ $i }}">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>

            <!-- Comment -->
            <div class="mb-6">
                <label class="block text-gray-700 font-bold mb-2">Your Review</label>
                <textarea name="comment" rows="6" 
                    class="w-full border rounded px-4 py-2"
                    placeholder="Share your experience with other guests..."></textarea>
                <p class="text-sm text-gray-600 mt-1">Optional but recommended</p>
            </div>

            <div class="flex gap-4">
                <button type="submit" 
                    class="bg-primary text-white px-6 py-3 rounded hover:bg-primary-dark font-semibold">
                    Submit Review
                </button>
                <a href="{{ route('bookings.show', $booking) }}" 
                    class="bg-gray-300 text-gray-700 px-6 py-3 rounded hover:bg-gray-400">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection