@extends('layouts.app')

@section('title', 'My Favorites')

@section('content')
<div class="max-w-7xl mx-auto px-4 py-4 md:py-8">
    <!-- Header -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-4 md:p-6 mb-4 md:mb-6">
        <h1 class="text-2xl md:text-3xl font-bold mb-1 md:mb-2">
            <i class="fas fa-heart mr-2 md:mr-3"></i>My Favorites
        </h1>
        <p class="text-sm md:text-base text-primary-light">Properties you've saved for later</p>
    </div>

    @if($favorites->count() > 0)
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6">
            @foreach($favorites as $property)
                <div class="bg-white rounded-xl shadow-md overflow-hidden hover:shadow-xl transition">
                    <!-- Property Image -->
                    <div class="relative h-48 md:h-52">
                        @if($property->photos && count($property->photos) > 0)
                            <img src="{{ Storage::url($property->photos[0]) }}" 
                                alt="{{ $property->title }}"
                                class="w-full h-full object-cover">
                        @else
                            <div class="w-full h-full bg-gray-200 flex items-center justify-center">
                                <i class="fas fa-home text-gray-400 text-3xl md:text-4xl"></i>
                            </div>
                        @endif
                        
                        <!-- Favorite Button -->
                        <button onclick="toggleFavorite({{ $property->id }}, this)" 
                            class="absolute top-2 md:top-3 right-2 md:right-3 bg-white rounded-full p-2 shadow-lg hover:scale-110 transition">
                            <i class="fas fa-heart text-red-500 text-lg md:text-xl"></i>
                        </button>
                    </div>

                    <!-- Property Details -->
                    <div class="p-3 md:p-4">
                        <h3 class="font-bold text-base md:text-lg text-secondary mb-1 md:mb-2 line-clamp-2">
                            {{ $property->title }}
                        </h3>
                        <p class="text-xs md:text-sm text-gray-600 mb-2 md:mb-3">
                            <i class="fas fa-map-marker-alt text-primary mr-1"></i>
                            {{ $property->city }}
                        </p>

                        <div class="flex items-center justify-between mb-2 md:mb-3">
                            <div class="text-primary font-bold text-lg md:text-xl">
                                ₦{{ number_format($property->price_per_night) }}
                                <span class="text-xs md:text-sm text-gray-600 font-normal">/night</span>
                            </div>
                        </div>

                        <div class="flex flex-wrap gap-2 text-xs text-gray-600 mb-3 md:mb-4">
                            <span class="flex items-center">
                                <i class="fas fa-bed text-primary mr-1"></i>{{ $property->bedrooms }} Beds
                            </span>
                            <span class="flex items-center">
                                <i class="fas fa-bath text-primary mr-1"></i>{{ $property->bathrooms }} Baths
                            </span>
                            <span class="flex items-center">
                                <i class="fas fa-users text-primary mr-1"></i>{{ $property->max_guests }} Guests
                            </span>
                        </div>

                        <a href="{{ route('properties.show', $property) }}" 
                            class="block w-full bg-primary text-white text-center py-2 md:py-2.5 rounded-lg hover:bg-primary-dark transition font-semibold text-sm md:text-base">
                            <i class="fas fa-eye mr-1 md:mr-2"></i> View Details
                        </a>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-6 md:mt-8">
            {{ $favorites->links() }}
        </div>
    @else
        <!-- Empty State -->
        <div class="bg-white rounded-xl shadow-md p-8 md:p-12 text-center">
            <i class="fas fa-heart text-gray-300 text-4xl md:text-6xl mb-3 md:mb-4"></i>
            <h2 class="text-xl md:text-2xl font-bold text-secondary mb-2">No Favorites Yet</h2>
            <p class="text-sm md:text-base text-gray-600 mb-4 md:mb-6">Start exploring and save properties you love!</p>
            <a href="{{ route('properties.index') }}" 
                class="inline-block bg-primary text-white px-6 md:px-8 py-2.5 md:py-3 rounded-lg hover:bg-primary-dark font-semibold transition text-sm md:text-base">
                <i class="fas fa-search mr-2"></i> Browse Properties
            </a>
        </div>
    @endif
</div>

<script>
function toggleFavorite(propertyId, button) {
    fetch(`/favorites/toggle/${propertyId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Remove the card from the page
            button.closest('.bg-white').remove();
            
            // Check if there are no more favorites
            const grid = document.querySelector('.grid');
            if (grid && grid.children.length === 0) {
                location.reload();
            }
        }
    })
    .catch(error => console.error('Error:', error));
}
</script>
@endsection