@extends('layouts.app')

@section('title', 'Write a Review')

@section('content')
<div class="max-w-4xl mx-auto px-4 py-8">
    <!-- Header -->
    <div class="bg-gradient-to-r from-yellow-500 to-orange-500 text-white rounded-xl shadow-lg p-6 mb-6">
        <h1 class="text-3xl font-bold mb-2">
            <i class="fas fa-star mr-3"></i>Write a Review
        </h1>
        <p class="text-yellow-100">Share your experience at {{ $property->name }}</p>
    </div>

    <!-- Property Info -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <div class="flex items-start gap-4">
            @if($property->main_photo)
                <img src="{{ asset('storage/' . $property->main_photo) }}" 
                    alt="{{ $property->name }}"
                    class="w-32 h-32 object-cover rounded-lg">
            @endif
            <div class="flex-1">
                <h2 class="text-xl font-bold text-gray-800 mb-2">{{ $property->name }}</h2>
                <p class="text-gray-600 mb-2">
                    <i class="fas fa-map-marker-alt mr-1"></i>{{ $property->city }}, {{ $property->state }}
                </p>
                <p class="text-sm text-gray-500">
                    <i class="fas fa-calendar mr-1"></i>
                    Your stay: {{ \Carbon\Carbon::parse($booking->start_date)->format('M d') }} - {{ \Carbon\Carbon::parse($booking->end_date)->format('M d, Y') }}
                </p>
            </div>
        </div>
    </div>

    <!-- Review Form -->
    <form method="POST" action="{{ route('reviews.store') }}" class="bg-white rounded-xl shadow-md p-6">
        @csrf
        <input type="hidden" name="booking_id" value="{{ $booking->id }}">
        <input type="hidden" name="property_id" value="{{ $property->id }}">

        <!-- Overall Rating -->
        <div class="mb-6">
            <label class="block text-lg font-bold text-gray-800 mb-3">Overall Rating *</label>
            <div class="flex gap-2">
                @for($i = 1; $i <= 5; $i++)
                    <label class="cursor-pointer">
                        <input type="radio" name="rating" value="{{ $i }}" class="hidden peer" required>
                        <i class="fas fa-star text-4xl text-gray-300 peer-checked:text-yellow-500 hover:text-yellow-400 transition"></i>
                    </label>
                @endfor
            </div>
            @error('rating')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Category Ratings -->
        <div class="mb-6">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Rate Your Experience</h3>
            <div class="grid md:grid-cols-2 gap-6">
                <!-- Cleanliness -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-broom text-primary mr-1"></i>Cleanliness *
                    </label>
                    <div class="flex gap-1">
                        @for($i = 1; $i <= 5; $i++)
                            <label class="cursor-pointer">
                                <input type="radio" name="cleanliness_rating" value="{{ $i }}" class="hidden peer" required>
                                <i class="fas fa-star text-2xl text-gray-300 peer-checked:text-yellow-500 hover:text-yellow-400 transition"></i>
                            </label>
                        @endfor
                    </div>
                    @error('cleanliness_rating')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Accuracy -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-check-circle text-primary mr-1"></i>Accuracy *
                    </label>
                    <div class="flex gap-1">
                        @for($i = 1; $i <= 5; $i++)
                            <label class="cursor-pointer">
                                <input type="radio" name="accuracy_rating" value="{{ $i }}" class="hidden peer" required>
                                <i class="fas fa-star text-2xl text-gray-300 peer-checked:text-yellow-500 hover:text-yellow-400 transition"></i>
                            </label>
                        @endfor
                    </div>
                    @error('accuracy_rating')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Communication -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-comments text-primary mr-1"></i>Communication *
                    </label>
                    <div class="flex gap-1">
                        @for($i = 1; $i <= 5; $i++)
                            <label class="cursor-pointer">
                                <input type="radio" name="communication_rating" value="{{ $i }}" class="hidden peer" required>
                                <i class="fas fa-star text-2xl text-gray-300 peer-checked:text-yellow-500 hover:text-yellow-400 transition"></i>
                            </label>
                        @endfor
                    </div>
                    @error('communication_rating')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Location -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-map-marker-alt text-primary mr-1"></i>Location *
                    </label>
                    <div class="flex gap-1">
                        @for($i = 1; $i <= 5; $i++)
                            <label class="cursor-pointer">
                                <input type="radio" name="location_rating" value="{{ $i }}" class="hidden peer" required>
                                <i class="fas fa-star text-2xl text-gray-300 peer-checked:text-yellow-500 hover:text-yellow-400 transition"></i>
                            </label>
                        @endfor
                    </div>
                    @error('location_rating')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Value -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-dollar-sign text-primary mr-1"></i>Value for Money *
                    </label>
                    <div class="flex gap-1">
                        @for($i = 1; $i <= 5; $i++)
                            <label class="cursor-pointer">
                                <input type="radio" name="value_rating" value="{{ $i }}" class="hidden peer" required>
                                <i class="fas fa-star text-2xl text-gray-300 peer-checked:text-yellow-500 hover:text-yellow-400 transition"></i>
                            </label>
                        @endfor
                    </div>
                    @error('value_rating')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Comment -->
        <div class="mb-6">
            <label class="block text-lg font-bold text-gray-800 mb-2">Your Review *</label>
            <textarea name="comment" rows="6" required
                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none @error('comment') border-red-500 @enderror"
                placeholder="Share details of your experience. What did you like? What could be improved?">{{ old('comment') }}</textarea>
            <p class="text-xs text-gray-500 mt-1">Maximum 1000 characters</p>
            @error('comment')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <!-- Guidelines -->
        <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-500 rounded">
            <p class="text-sm text-blue-800 font-semibold mb-2">
                <i class="fas fa-info-circle mr-1"></i>Review Guidelines
            </p>
            <ul class="text-xs text-blue-700 space-y-1 ml-4">
                <li>• Be honest and constructive</li>
                <li>• Focus on your personal experience</li>
                <li>• Avoid offensive language</li>
                <li>• Don't include personal contact information</li>
            </ul>
        </div>

        <!-- Buttons -->
        <div class="flex gap-4">
            <button type="submit" 
                class="flex-1 bg-gradient-to-r from-yellow-500 to-orange-500 text-white py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                <i class="fas fa-paper-plane mr-2"></i>Submit Review
            </button>
            <a href="{{ route('bookings.show', $booking) }}" 
                class="px-8 py-4 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 font-semibold transition">
                Cancel
            </a>
        </div>
    </form>
</div>

<style>
/* Make star ratings more interactive */
input[type="radio"]:checked ~ i {
    color: #f59e0b !important;
}
</style>
@endsection
