@extends('layouts.app')

@section('title', 'Nearby Attractions - ' . $property->title)

@section('content')
<div class="max-w-6xl mx-auto">
    <div class="mb-6">
        <a href="{{ route('bookings.show', $booking) }}" class="text-primary hover:underline">← Back to Booking</a>
    </div>

    <h1 class="text-3xl font-bold mb-6">Location & Nearby Attractions</h1>

    <!-- Map -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="font-bold text-xl mb-4">Property Location</h2>
        <div id="map" class="w-full h-96 rounded mb-4"></div>
        <p class="text-gray-600">{{ $property->address }}, {{ $property->city }}, {{ $property->state }}</p>
    </div>

    <!-- Nearby Attractions -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="font-bold text-xl mb-6">Things to Do Nearby</h2>

        @if(count($attractions) > 0)
            <div class="grid md:grid-cols-2 gap-6">
                @foreach($attractions as $attraction)
                    <div class="border rounded-lg overflow-hidden hover:shadow-lg transition">
                        @if(isset($attraction['photo_url']) && $attraction['photo_url'])
                            <img src="{{ $attraction['photo_url'] }}" 
                                alt="{{ $attraction['name'] }}" 
                                class="w-full h-48 object-cover">
                        @endif
                        
                        <div class="p-4">
                            <h3 class="font-bold text-lg mb-2">{{ $attraction['name'] }}</h3>
                            
                            @if(isset($attraction['rating']) && $attraction['rating'])
                                <div class="flex items-center mb-2">
                                    <span class="text-yellow-500">★</span>
                                    <span class="ml-1 text-sm">{{ number_format($attraction['rating'], 1) }}</span>
                                </div>
                            @endif

                            @if(isset($attraction['vicinity']) && $attraction['vicinity'])
                                <p class="text-sm text-gray-600 mb-2">{{ $attraction['vicinity'] }}</p>
                            @endif

                            @if(isset($attraction['description']) && $attraction['description'])
                                <p class="text-sm text-gray-700 mb-3">{{ Str::limit($attraction['description'], 150) }}</p>
                            @endif

                            <div class="flex flex-wrap gap-2">
                                @foreach(array_slice($attraction['types'], 0, 3) as $type)
                                    <span class="px-2 py-1 bg-primary/10 text-blue-800 text-xs rounded">
                                        {{ str_replace('_', ' ', $type) }}
                                    </span>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-gray-600 text-center py-8">No nearby attractions found at this time.</p>
        @endif
    </div>
</div>

@push('scripts')
<script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}"></script>
<script>
    function initMap() {
        const location = { 
            lat: {{ $property->location_lat }}, 
            lng: {{ $property->location_lng }} 
        };
        
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: 15,
            center: location,
            styles: [
                {
                    featureType: "poi",
                    elementType: "labels",
                    stylers: [{ visibility: "on" }]
                }
            ]
        });
        
        // Property marker
        new google.maps.Marker({
            position: location,
            map: map,
            title: "{{ $property->title }}",
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/red-dot.png"
            }
        });

        // Attractions markers
        @foreach($attractions as $index => $attraction)
            new google.maps.Marker({
                position: { 
                    lat: {{ $attraction['geometry']['location']['lat'] ?? $property->location_lat }}, 
                    lng: {{ $attraction['geometry']['location']['lng'] ?? $property->location_lng }} 
                },
                map: map,
                title: "{{ $attraction['name'] }}",
                label: "{{ $index + 1 }}",
                icon: {
                    url: "http://maps.google.com/mapfiles/ms/icons/blue-dot.png"
                }
            });
        @endforeach
    }
    
    initMap();
</script>
@endpush
@endsection