@extends('layouts.app')

@section('title', 'Contact Us')

@section('content')
<div class="max-w-6xl mx-auto px-3 sm:px-4">
    <!-- Header -->
    <div class="text-center mb-6 sm:mb-8 md:mb-12">
        <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold mb-2 sm:mb-4">Get in Touch</h1>
        <p class="text-gray-600 text-sm sm:text-base md:text-lg px-4">We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
    </div>

    <div class="grid md:grid-cols-2 gap-4 sm:gap-6 md:gap-8">
        <!-- Contact Form -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8">
            <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6">Send us a Message</h2>
            
            <form method="POST" action="{{ route('contact.submit') }}">
                @csrf
                
                <div class="mb-3 sm:mb-4">
                    <label class="block text-gray-700 mb-2 text-sm sm:text-base font-semibold">Full Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('name') border-red-500 @enderror">
                    @error('name')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-3 sm:mb-4">
                    <label class="block text-gray-700 mb-2 text-sm sm:text-base font-semibold">Email Address *</label>
                    <input type="email" name="email" value="{{ old('email') }}" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('email') border-red-500 @enderror">
                    @error('email')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-3 sm:mb-4">
                    <label class="block text-gray-700 mb-2 text-sm sm:text-base font-semibold">Phone Number</label>
                    <input type="tel" name="phone" value="{{ old('phone') }}"
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('phone') border-red-500 @enderror">
                    @error('phone')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-3 sm:mb-4">
                    <label class="block text-gray-700 mb-2 text-sm sm:text-base font-semibold">Subject *</label>
                    <input type="text" name="subject" value="{{ old('subject') }}" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('subject') border-red-500 @enderror">
                    @error('subject')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-4 sm:mb-6">
                    <label class="block text-gray-700 mb-2 text-sm sm:text-base font-semibold">Message *</label>
                    <textarea name="message" rows="6" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('message') border-red-500 @enderror">{{ old('message') }}</textarea>
                    @error('message')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <button type="submit" 
                    class="w-full bg-primary text-white py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold transition text-sm sm:text-base">
                    <i class="fas fa-paper-plane mr-2"></i> Send Message
                </button>
            </form>
        </div>

        <!-- Contact Information -->
        <div>
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8 mb-4 sm:mb-6">
                <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6">Contact Information</h2>
                
                <div class="space-y-4 sm:space-y-6">
                    @if($contact_email = \App\Models\Setting::get('contact_email'))
                        <div class="flex items-start">
                            <div class="bg-primary/10 rounded-full p-2 sm:p-3 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fas fa-envelope text-primary text-lg sm:text-xl"></i>
                            </div>
                            <div class="min-w-0">
                                <p class="font-semibold text-secondary mb-1 text-sm sm:text-base">Email Address</p>
                                <a href="mailto:{{ $contact_email }}" class="text-primary hover:underline text-sm sm:text-base break-all">{{ $contact_email }}</a>
                            </div>
                        </div>
                    @endif

                    @if($contact_phone = \App\Models\Setting::get('contact_phone'))
                        <div class="flex items-start">
                            <div class="bg-primary/10 rounded-full p-2 sm:p-3 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fas fa-phone text-primary text-lg sm:text-xl"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-secondary mb-1 text-sm sm:text-base">Phone Number</p>
                                <a href="tel:{{ $contact_phone }}" class="text-primary hover:underline text-sm sm:text-base">{{ $contact_phone }}</a>
                            </div>
                        </div>
                    @endif

                    @if($whatsapp_number = \App\Models\Setting::get('whatsapp_number'))
                        <div class="flex items-start">
                            <div class="bg-green-100 rounded-full p-2 sm:p-3 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fab fa-whatsapp text-green-600 text-lg sm:text-xl"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-secondary mb-1 text-sm sm:text-base">WhatsApp</p>
                                <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $whatsapp_number) }}" 
                                   target="_blank" 
                                   class="text-green-600 hover:underline text-sm sm:text-base">{{ $whatsapp_number }}</a>
                            </div>
                        </div>
                    @endif

                    @if($contact_address = \App\Models\Setting::get('contact_address'))
                        <div class="flex items-start">
                            <div class="bg-primary/10 rounded-full p-2 sm:p-3 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fas fa-map-marker-alt text-primary text-lg sm:text-xl"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-secondary mb-1 text-sm sm:text-base">Office Address</p>
                                <p class="text-gray-600 text-sm sm:text-base">{{ $contact_address }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8">
                <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Follow Us</h2>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
                    @if($facebook = \App\Models\Setting::get('facebook_url'))
                        <a href="{{ $facebook }}" target="_blank" 
                            class="flex items-center border rounded-lg p-3 hover:bg-light-bg transition">
                            <i class="fab fa-facebook text-primary text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                            <span class="text-sm sm:text-base flex-1">Facebook</span>
                            <i class="fas fa-external-link-alt text-xs text-gray-400"></i>
                        </a>
                    @endif

                    @if($instagram = \App\Models\Setting::get('instagram_url'))
                        <a href="{{ $instagram }}" target="_blank" 
                            class="flex items-center border rounded-lg p-3 hover:bg-light-bg transition">
                            <i class="fab fa-instagram text-pink-600 text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                            <span class="text-sm sm:text-base flex-1">Instagram</span>
                            <i class="fas fa-external-link-alt text-xs text-gray-400"></i>
                        </a>
                    @endif

                    @if($linkedin = \App\Models\Setting::get('linkedin_url'))
                        <a href="{{ $linkedin }}" target="_blank" 
                            class="flex items-center border rounded-lg p-3 hover:bg-light-bg transition">
                            <i class="fab fa-linkedin text-primary-dark text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                            <span class="text-sm sm:text-base flex-1">LinkedIn</span>
                            <i class="fas fa-external-link-alt text-xs text-gray-400"></i>
                        </a>
                    @endif

                    @if($youtube = \App\Models\Setting::get('youtube_url'))
                        <a href="{{ $youtube }}" target="_blank" 
                            class="flex items-center border rounded-lg p-3 hover:bg-light-bg transition">
                            <i class="fab fa-youtube text-red-600 text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                            <span class="text-sm sm:text-base flex-1">YouTube</span>
                            <i class="fas fa-external-link-alt text-xs text-gray-400"></i>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection