<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @php
        $favicon = \App\Models\Setting::get('favicon');
        $logo = \App\Models\Setting::get('logo');
        $siteName = \App\Models\Setting::get('site_name', 'ShortStayNG');
        $siteDescription = \App\Models\Setting::get('site_description', 'Book Hotels & Shortlets in Nigeria');
        $pageTitle = View::yieldContent('title') ?: 'Vendor Dashboard';
        $ogImage = $logo ? asset('storage/' . $logo) : asset('images/og-default.jpg');
    @endphp
    
    <title>{{ $pageTitle }} - {{ $siteName }}</title>
    <meta name="description" content="{{ $siteDescription }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="{{ $pageTitle }} - {{ $siteName }}">
    <meta property="og:description" content="{{ $siteDescription }}">
    <meta property="og:image" content="{{ $ogImage }}">
    <meta property="og:site_name" content="{{ $siteName }}">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $pageTitle }} - {{ $siteName }}">
    <meta name="twitter:description" content="{{ $siteDescription }}">
    <meta name="twitter:image" content="{{ $ogImage }}">
    
    @if($favicon)
        <link rel="icon" type="image/x-icon" href="{{ asset('storage/' . $favicon) }}">
    @endif
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#136D73',
                        'primary-dark': '#0f5a5f',
                        'primary-light': '#1a8891',
                    }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    @stack('styles')
</head>
<body class="bg-gray-100">
    <!-- Mobile Menu Button -->
    <div class="lg:hidden fixed top-0 left-0 right-0 bg-primary z-50 p-4 flex items-center justify-between">
        <div class="flex items-center">
            @if($logo)
                <img src="{{ asset('storage/' . $logo) }}" alt="{{ $siteName }}" class="h-8 w-auto brightness-0 invert">
            @else
                <span class="text-xl font-bold text-white">{{ $siteName }}</span>
            @endif
        </div>
        <button onclick="toggleMobileMenu()" class="text-white">
            <i class="fas fa-bars text-2xl"></i>
        </button>
    </div>

    <div class="flex h-screen">
        <!-- Sidebar -->
        <div id="sidebar" class="w-64 bg-gray-800 text-white fixed lg:static inset-y-0 left-0 transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out z-40 overflow-y-auto">
            <div class="p-4 bg-primary">
                @if($logo)
                    <img src="{{ asset('storage/' . $logo) }}" alt="{{ $siteName }}" class="h-10 w-auto mb-2 brightness-0 invert">
                @else
                    <h2 class="text-2xl font-bold">🏨 {{ $siteName }}</h2>
                @endif
                <p class="text-sm text-gray-200">{{ auth()->user()->vendor->company_name ?? auth()->user()->name }}</p>
            </div>
            
            <nav class="mt-8">
                <a href="{{ route('vendor.dashboard') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.dashboard') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-home mr-3"></i> Dashboard
                </a>
                <a href="{{ route('vendor.kyc.show') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.kyc.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-id-card mr-3"></i> KYC Verification
                    @if(auth()->user()->vendor->kyc_status === 'pending' && auth()->user()->vendor->hasSubmittedKyc())
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs">Pending</span>
                    @elseif(auth()->user()->vendor->kyc_status === 'rejected')
                        <span class="ml-auto bg-red-400 text-white px-2 py-1 rounded-full text-xs">Rejected</span>
                    @elseif(!auth()->user()->vendor->hasSubmittedKyc())
                        <span class="ml-auto bg-red-400 text-white px-2 py-1 rounded-full text-xs">!</span>
                    @endif
                </a>
                
                @if(auth()->user()->vendor->offersProperties())
                    <a href="{{ route('vendor.properties.index') }}" 
                        class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.properties.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                        <i class="fas fa-building mr-3"></i> Properties
                    </a>
                @endif
                
                @if(auth()->user()->vendor->offersCarRentals())
                    <a href="{{ route('vendor.cars.index') }}" 
                        class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.cars.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                        <i class="fas fa-car mr-3"></i> My Cars
                        @if(!auth()->user()->vendor->isCarRentalKycApproved())
                            <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs">KYC Required</span>
                        @endif
                    </a>
                @endif
                
                <a href="{{ route('vendor.bookings.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.bookings.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-calendar-check mr-3"></i> Bookings
                </a>
                <a href="{{ route('vendor.transactions.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.transactions.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-receipt mr-3"></i> Transactions
                </a>
                <a href="{{ route('vendor.ads.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.ads.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-bullhorn mr-3"></i> Advertisements
                </a>
                <a href="{{ route('vendor.payouts.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.payouts.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-wallet mr-3"></i> Payouts
                </a>
                
                <div class="border-t border-gray-700 mt-4 pt-4">
                    <a href="{{ route('vendor.profile') }}" class="flex items-center px-6 py-3 hover:bg-primary transition {{ request()->routeIs('vendor.profile') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                        <i class="fas fa-user-circle mr-3"></i> My Profile
                    </a>
                    <a href="{{ route('home') }}" class="flex items-center px-6 py-3 hover:bg-primary transition">
                        <i class="fas fa-globe mr-3"></i> View Site
                    </a>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button class="flex items-center px-6 py-3 hover:bg-primary transition w-full text-left">
                            <i class="fas fa-sign-out-alt mr-3"></i> Logout
                        </button>
                    </form>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto pt-16 lg:pt-0">
            <!-- Top Bar -->
            <div class="bg-white shadow-md p-4">
                <div class="flex justify-between items-center">
                    <h1 class="text-xl font-bold">{{ auth()->user()->vendor->company_name }}</h1>
                    <div class="flex items-center space-x-4">
                        <span class="text-sm">{{ auth()->user()->name }}</span>
                        @if(auth()->user()->profile_photo)
                            <img src="{{ asset('storage/' . auth()->user()->profile_photo) }}" 
                                alt="{{ auth()->user()->name }}"
                                class="w-10 h-10 rounded-full object-cover border-2 border-primary"
                                onerror="this.src='https://ui-avatars.com/api/?name={{ urlencode(auth()->user()->name) }}&background=136D73&color=fff'">
                        @else
                            <div class="w-10 h-10 rounded-full bg-primary flex items-center justify-center text-white font-bold">
                                {{ substr(auth()->user()->name, 0, 1) }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            @if(session('success'))
                <div class="m-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error') || $errors->any())
                <div class="m-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                    {{ session('error') ?? $errors->first() }}
                </div>
            @endif

            <!-- Page Content -->
            <div class="p-6">
                @yield('content')
            </div>
        </div>
    </div>

    @stack('scripts')
    
    <script>
        function toggleMobileMenu() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('-translate-x-full');
        }
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const menuButton = event.target.closest('button[onclick="toggleMobileMenu()"]');
            
            if (!sidebar.contains(event.target) && !menuButton && window.innerWidth < 1024) {
                sidebar.classList.add('-translate-x-full');
            }
        });
    </script>
</body>
</html>