<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @php
        $favicon = \App\Models\Setting::get('favicon');
        $logo = \App\Models\Setting::get('logo');
        $siteName = \App\Models\Setting::get('site_name', 'ShortStayNG');
        $siteDescription = \App\Models\Setting::get('site_description', 'Book Hotels & Shortlets in Nigeria');
        $pageTitle = View::yieldContent('title') ?: 'Admin Dashboard';
        $ogImage = $logo ? asset('storage/' . $logo) : asset('images/og-default.jpg');
    @endphp
    
    <title>{{ $pageTitle }} - {{ $siteName }}</title>
    <meta name="description" content="{{ $siteDescription }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="{{ $pageTitle }} - {{ $siteName }}">
    <meta property="og:description" content="{{ $siteDescription }}">
    <meta property="og:image" content="{{ $ogImage }}">
    <meta property="og:site_name" content="{{ $siteName }}">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $pageTitle }} - {{ $siteName }}">
    <meta name="twitter:description" content="{{ $siteDescription }}">
    <meta name="twitter:image" content="{{ $ogImage }}">
    
    @if($favicon)
        <link rel="icon" type="image/x-icon" href="{{ asset('storage/' . $favicon) }}">
    @endif
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#136D73',
                        'primary-dark': '#0f5a5f',
                        'primary-light': '#1a8891',
                    }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    @stack('styles')
</head>
<body class="bg-gray-100">
    <!-- Mobile Menu Button -->
    <div class="lg:hidden fixed top-0 left-0 right-0 bg-primary z-50 p-4 flex items-center justify-between">
        <div class="flex items-center">
            @if($logo)
                <img src="{{ asset('storage/' . $logo) }}" alt="{{ $siteName }}" class="h-8 w-auto brightness-0 invert">
            @else
                <span class="text-xl font-bold text-white">{{ $siteName }}</span>
            @endif
        </div>
        <div class="flex items-center gap-3">
            <div class="scale-90">
                <x-language-selector />
            </div>
            <button onclick="toggleMobileMenu()" class="text-white">
                <i class="fas fa-bars text-2xl"></i>
            </button>
        </div>
    </div>

    <div class="flex h-screen">
        <!-- Sidebar -->
        <div id="sidebar" class="w-64 bg-primary-dark text-white fixed lg:static inset-y-0 left-0 transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out z-40 overflow-y-auto">
            <div class="p-4 bg-primary">
                @if($logo)
                    <img src="{{ asset('storage/' . $logo) }}" alt="{{ $siteName }}" class="h-10 w-auto mb-2 brightness-0 invert">
                @else
                    <h2 class="text-2xl font-bold">🏨 {{ $siteName }}</h2>
                @endif
                <p class="text-sm text-gray-200">Welcome, {{ auth()->user()->name }}</p>
            </div>
            
            <nav class="mt-8">
                <!-- Dashboard -->
                <a href="{{ route('admin.dashboard') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.dashboard') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-tachometer-alt mr-3"></i> Dashboard
                </a>

                <!-- Bookings & Payments -->
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Bookings & Payments</p>
                </div>
                <a href="{{ route('admin.bookings.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.bookings.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-calendar-check mr-3"></i> Bookings
                </a>
                <a href="{{ route('admin.payment-verification.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.payment-verification.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-money-check-alt mr-3"></i> Payment Verification
                    @if($pendingPayments = \App\Models\Booking::where('payment_method', 'bank_transfer')->where('payment_status', 'pending_verification')->count())
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $pendingPayments }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.transactions.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.transactions.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-receipt mr-3"></i> Transactions
                </a>
                @role('owner|manager')
                <a href="{{ route('admin.refund-payouts.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.refund-payouts.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-hand-holding-usd mr-3"></i> User Refund Payouts
                    @php
                        $refundRequests = \App\Models\Booking::where('refund_payout_status', 'requested')->count();
                    @endphp
                    @if($refundRequests > 0)
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $refundRequests }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.payouts.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.payouts.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-money-bill-wave mr-3"></i> Vendor Payouts
                    @if($pendingPayouts = \App\Models\Payout::where('status', 'pending')->count())
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $pendingPayouts }}</span>
                    @endif
                </a>
                @endrole

                <!-- Users & Vendors -->
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Users & Vendors</p>
                </div>
                @role('owner|manager')
                <a href="{{ route('admin.all-users.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.all-users.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-users mr-3"></i> All Users
                </a>
                @endrole
                <a href="{{ route('admin.vendors.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.vendors.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-store mr-3"></i> Vendors
                </a>
                @can('manage-ads')
                <a href="{{ route('admin.kyc.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.kyc.index') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-id-card mr-3"></i> KYC Approvals
                    @if($kycPendingCount = \App\Models\Vendor::where('kyc_status', 'pending')->whereNotNull('kyc_submitted_at')->count())
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $kycPendingCount }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.kyc-form.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.kyc-form.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-edit mr-3"></i> KYC Form Builder
                </a>
                @endcan

                <!-- Properties -->
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Properties</p>
                </div>
                <a href="{{ route('admin.properties.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.properties.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-home mr-3"></i> All Properties
                    @if($pendingCount = \App\Models\Property::where('status', 'pending')->count())
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $pendingCount }}</span>
                    @endif
                </a>

                <!-- Car Rentals -->
                @if(\App\Models\Setting::get('car_rental_enabled', false))
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Car Rentals</p>
                </div>
                <a href="{{ route('admin.cars.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.cars.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-car mr-3"></i> All Cars
                    @if($pendingCars = \App\Models\Car::where('status', 'pending')->count())
                        <span class="ml-auto bg-yellow-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $pendingCars }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.car-bookings.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.car-bookings.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-calendar-check mr-3"></i> Car Bookings
                </a>
                @endif

                <!-- Advertisements -->
                @can('manage-ads')
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Advertisements</p>
                </div>
                <a href="{{ route('admin.ads.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.ads.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-ad mr-3"></i> Ad Approvals
                </a>
                @endcan
                @role('owner|manager')
                <a href="{{ route('admin.ad-plans.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.ad-plans.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-tags mr-3"></i> Ad Plans
                </a>
                @endrole

                <!-- Promotions & Discounts -->
                @role('owner|manager')
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Promotions & Discounts</p>
                </div>
                <a href="{{ route('admin.promo-codes.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.promo-codes.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-ticket-alt mr-3"></i> Promo Codes
                    @if($activePromos = \App\Models\PromoCode::where('is_active', true)->count())
                        <span class="ml-auto bg-green-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $activePromos }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.discount-deals.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.discount-deals.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-percent mr-3"></i> Discount Deals
                    @if($activeDeals = \App\Models\DiscountDeal::where('is_active', true)->count())
                        <span class="ml-auto bg-green-400 text-black px-2 py-1 rounded-full text-xs font-bold">{{ $activeDeals }}</span>
                    @endif
                </a>
                @endrole

                <!-- Homepage Content -->
                @role('owner|manager')
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Homepage Content</p>
                </div>
                <a href="{{ route('admin.destinations.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.destinations.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-map-marked-alt mr-3"></i> Popular Destinations
                    @if($activeDestinations = \App\Models\PopularDestination::where('active', true)->count())
                        <span class="ml-auto bg-purple-400 text-white px-2 py-1 rounded-full text-xs font-bold">{{ $activeDestinations }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.house-types.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.house-types.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-home mr-3"></i> House Type Images
                    @if($activeHouseTypes = \App\Models\HouseTypeImage::where('active', true)->count())
                        <span class="ml-auto bg-indigo-400 text-white px-2 py-1 rounded-full text-xs font-bold">{{ $activeHouseTypes }}</span>
                    @endif
                </a>
                <a href="{{ route('admin.faqs.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.faqs.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-question-circle mr-3"></i> FAQs
                    @if($activeFaqs = \App\Models\Faq::where('is_active', true)->count())
                        <span class="ml-auto bg-blue-400 text-white px-2 py-1 rounded-full text-xs font-bold">{{ $activeFaqs }}</span>
                    @endif
                </a>
                @endrole

                <!-- System Settings (Owner Only) -->
                @role('owner')
                <div class="px-4 py-2 mt-4">
                    <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">System Settings</p>
                </div>
                <a href="{{ route('admin.users.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.users.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-users-cog mr-3"></i> Admin Users
                </a>
                <a href="{{ route('admin.payment-methods.index') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.payment-methods.*') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-credit-card mr-3"></i> Payment Methods
                </a>
                <a href="{{ route('admin.settings') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.settings') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-cog mr-3"></i> Settings
                </a>
                <a href="{{ route('admin.audit-logs') }}" 
                    class="flex items-center px-6 py-3 hover:bg-primary {{ request()->routeIs('admin.audit-logs') ? 'bg-primary border-l-4 border-primary-light' : '' }}">
                    <i class="fas fa-history mr-3"></i> Audit Logs
                </a>
                @endrole
                
                <div class="border-t border-blue-800 mt-4 pt-4">
                    <a href="{{ route('home') }}" class="flex items-center px-6 py-3 hover:bg-primary">
                        <i class="fas fa-globe mr-3"></i> View Site
                    </a>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button class="flex items-center px-6 py-3 hover:bg-primary w-full text-left">
                            <i class="fas fa-sign-out-alt mr-3"></i> Logout
                        </button>
                    </form>
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto pt-16 lg:pt-0">
            <!-- Top Bar -->
            <div class="bg-white shadow-md p-4 hidden lg:block">
                <div class="flex justify-between items-center">
                    <h1 class="text-xl font-bold">Welcome, {{ auth()->user()->name }}</h1>
                    <div class="flex items-center space-x-4">
                        <span class="px-3 py-1 bg-primary/10 text-blue-800 rounded-full text-sm font-semibold">
                            {{ ucfirst(auth()->user()->getRoleNames()->first()) }}
                        </span>
                        <span class="text-sm">{{ auth()->user()->name }}</span>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            @if(session('success'))
                <div class="m-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error') || $errors->any())
                <div class="m-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                    {{ session('error') ?? $errors->first() }}
                </div>
            @endif

            <!-- Page Content -->
            <div class="p-6">
                @yield('content')
            </div>
        </div>
    </div>

    @stack('scripts')
    
    <script>
        function toggleMobileMenu() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('-translate-x-full');
        }
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const menuButton = event.target.closest('button[onclick="toggleMobileMenu()"]');
            
            if (!sidebar.contains(event.target) && !menuButton && window.innerWidth < 1024) {
                sidebar.classList.add('-translate-x-full');
            }
        });
    </script>
</body>
</html>
