<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Email Address</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(135deg, #136D73 0%, #0f5a5f 100%);
            color: #ffffff;
            padding: 40px 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: bold;
        }
        .header p {
            margin: 10px 0 0;
            font-size: 16px;
            opacity: 0.9;
        }
        .icon-circle {
            width: 80px;
            height: 80px;
            background-color: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }
        .icon-circle svg {
            width: 40px;
            height: 40px;
            fill: #ffffff;
        }
        .content {
            padding: 40px 30px;
        }
        .greeting {
            font-size: 18px;
            color: #136D73;
            font-weight: 600;
            margin-bottom: 20px;
        }
        .message {
            font-size: 16px;
            color: #555;
            margin-bottom: 30px;
            line-height: 1.8;
        }
        .button-container {
            text-align: center;
            margin: 40px 0;
        }
        .verify-button {
            display: inline-block;
            padding: 16px 40px;
            background: linear-gradient(135deg, #136D73 0%, #0f5a5f 100%);
            color: #ffffff;
            text-decoration: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            box-shadow: 0 4px 6px rgba(19, 109, 115, 0.3);
            transition: all 0.3s ease;
        }
        .verify-button:hover {
            box-shadow: 0 6px 8px rgba(19, 109, 115, 0.4);
            transform: translateY(-2px);
        }
        .alternative-link {
            background-color: #f8f9fa;
            border: 2px dashed #dee2e6;
            border-radius: 8px;
            padding: 20px;
            margin: 30px 0;
        }
        .alternative-link p {
            margin: 0 0 10px;
            font-size: 14px;
            color: #666;
        }
        .alternative-link a {
            color: #136D73;
            word-break: break-all;
            font-size: 13px;
        }
        .info-box {
            background-color: #e7f3f4;
            border-left: 4px solid #136D73;
            padding: 15px 20px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-box p {
            margin: 0;
            font-size: 14px;
            color: #136D73;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #dee2e6;
        }
        .footer p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        .footer a {
            color: #136D73;
            text-decoration: none;
        }
        .footer a:hover {
            text-decoration: underline;
        }
        .social-links {
            margin: 20px 0;
        }
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            color: #136D73;
            font-size: 20px;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                margin: 0;
                border-radius: 0;
            }
            .content {
                padding: 30px 20px;
            }
            .header {
                padding: 30px 20px;
            }
            .verify-button {
                padding: 14px 30px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="header">
            <div class="icon-circle">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                </svg>
            </div>
            <h1>Verify Your Email Address</h1>
            <p>Welcome to {{ config('app.name') }}!</p>
        </div>

        <!-- Content -->
        <div class="content">
            <p class="greeting">Hello {{ $user->name ?? 'there' }}!</p>
            
            <p class="message">
                Thank you for registering with <strong>{{ config('app.name') }}</strong>! 
                We're excited to have you on board. To complete your registration and start booking amazing properties, 
                please verify your email address by clicking the button below.
            </p>

            <!-- Verify Button -->
<div class="button-container">
    <a href="{!! $verificationUrl !!}" class="verify-button">
        Verify Email Address
    </a>
</div>

            <!-- Info Box -->
            <div class="info-box">
                <p>
                    <strong>⏰ This verification link will expire in 60 minutes.</strong>
                </p>
            </div>

            <!-- Alternative Link -->
<div class="alternative-link">
    <p><strong>Having trouble clicking the button?</strong></p>
    <p>Copy and paste this URL into your browser:</p>
    <a href="{!! $verificationUrl !!}">{!! $verificationUrl !!}</a>
</div>



        <!-- Footer -->
        <div class="footer">
            <p><strong>{{ config('app.name') }}</strong></p>
            <p>Your trusted platform for short stays across Nigeria</p>
            
            @php
                $facebookUrl = \App\Models\Setting::get('facebook_url');
                $instagramUrl = \App\Models\Setting::get('instagram_url');
                $twitterUrl = \App\Models\Setting::get('twitter_url');
            @endphp

            @if($facebookUrl || $instagramUrl || $twitterUrl)
                <div class="social-links">
                    @if($facebookUrl)
                        <a href="{{ $facebookUrl }}" target="_blank" title="Facebook">📘</a>
                    @endif
                    @if($instagramUrl)
                        <a href="{{ $instagramUrl }}" target="_blank" title="Instagram">📷</a>
                    @endif
                    @if($twitterUrl)
                        <a href="{{ $twitterUrl }}" target="_blank" title="Twitter">🐦</a>
                    @endif
                </div>
            @endif

            <p>
                <a href="{{ config('app.url') }}">Visit Website</a> | 
                <a href="{{ route('contact') }}">Contact Support</a>
                @if(Route::has('terms'))
                    | <a href="{{ route('terms') }}">Terms of Service</a>
                @endif
            </p>
            
            <p style="font-size: 12px; color: #999; margin-top: 20px;">
                © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
            </p>
            
            <p style="font-size: 11px; color: #999; margin-top: 10px;">
                This is an automated email. Please do not reply to this message.
            </p>
        </div>
    </div>
</body>
</html>