@extends('layouts.app')

@section('title', 'Booking Details')

@section('content')
<div class="max-w-6xl mx-auto px-4 py-8">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="{{ route('bookings.index') }}" class="text-primary hover:text-primary-dark font-semibold">
            <i class="fas fa-arrow-left mr-2"></i> Back to My Bookings
        </a>
    </div>

    <!-- Header -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6 mb-6">
        <div class="flex justify-between items-start">
            <div>
                <h1 class="text-3xl font-bold mb-2">
                    <i class="fas fa-receipt mr-3"></i>Booking #{{ $booking->id }}
                </h1>
                <p class="text-primary-light">Reference: {{ $booking->payment_reference }}</p>
            </div>
            <span class="px-4 py-2 rounded-full text-sm font-bold
                @if($booking->booking_status === 'confirmed') bg-green-500 text-white
                @elseif($booking->booking_status === 'pending') bg-yellow-400 text-gray-900
                @elseif($booking->booking_status === 'cancelled') bg-red-500 text-white
                @elseif($booking->booking_status === 'completed') bg-blue-500 text-white
                @else bg-white text-primary
                @endif">
                {{ ucfirst($booking->booking_status) }}
            </span>
        </div>
    </div>

    <div class="grid lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Status Timeline -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-6 flex items-center">
                    <i class="fas fa-tasks text-primary mr-3"></i> Booking Progress
                </h2>
                
                <div class="relative">
                    <div class="absolute top-5 left-0 right-0 h-1 bg-gray-200 rounded"></div>
                    <div class="absolute top-5 left-0 h-1 bg-primary rounded transition-all duration-500"
                        style="width: {{ 
                            $booking->booking_status === 'completed' ? '100%' : 
                            ($booking->admin_verified ? '80%' : 
                            ($booking->payment_status === 'paid' ? '60%' : 
                            ($booking->vendor_approval_status === 'approved' ? '40%' : '20%'))) 
                        }}"></div>
                    
                    <div class="relative flex justify-between">
                        <!-- Booking Created -->
                        <div class="text-center">
                            <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center text-white mx-auto mb-2 shadow-lg">
                                <i class="fas fa-check text-lg"></i>
                            </div>
                            <p class="text-xs font-semibold text-gray-700">Created</p>
                        </div>

                        <!-- Vendor Approval -->
                        @if($booking->requires_vendor_approval)
                            <div class="text-center">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center text-white mx-auto mb-2 shadow-lg
                                    {{ $booking->vendor_approval_status === 'approved' ? 'bg-green-500' : 
                                       ($booking->vendor_approval_status === 'rejected' ? 'bg-red-500' : 'bg-gray-400') }}">
                                    <i class="fas {{ $booking->vendor_approval_status === 'approved' ? 'fa-check' : 
                                                     ($booking->vendor_approval_status === 'rejected' ? 'fa-times' : 'fa-clock') }} text-lg"></i>
                                </div>
                                <p class="text-xs font-semibold text-gray-700">Vendor</p>
                            </div>
                        @endif

                        <!-- Payment -->
                        <div class="text-center">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center text-white mx-auto mb-2 shadow-lg
                                {{ $booking->payment_status === 'paid' ? 'bg-green-500' : 'bg-gray-400' }}">
                                <i class="fas {{ $booking->payment_status === 'paid' ? 'fa-check' : 'fa-credit-card' }} text-lg"></i>
                            </div>
                            <p class="text-xs font-semibold text-gray-700">Payment</p>
                        </div>

                        <!-- Admin Verification -->
                        <div class="text-center">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center text-white mx-auto mb-2 shadow-lg
                                {{ $booking->admin_verified ? 'bg-green-500' : 'bg-gray-400' }}">
                                <i class="fas {{ $booking->admin_verified ? 'fa-check' : 'fa-user-shield' }} text-lg"></i>
                            </div>
                            <p class="text-xs font-semibold text-gray-700">Verified</p>
                        </div>

                        <!-- Completed -->
                        <div class="text-center">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center text-white mx-auto mb-2 shadow-lg
                                {{ $booking->booking_status === 'completed' ? 'bg-green-500' : 'bg-gray-400' }}">
                                <i class="fas {{ $booking->booking_status === 'completed' ? 'fa-flag-checkered' : 'fa-flag' }} text-lg"></i>
                            </div>
                            <p class="text-xs font-semibold text-gray-700">Stay</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Property & Stay Details -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-6 flex items-center">
                    <i class="fas fa-info-circle text-primary mr-3"></i> Booking Details
                </h2>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="bg-primary/5 rounded-lg p-4">
                        <h3 class="font-bold text-secondary mb-3 flex items-center">
                            <i class="fas fa-home text-primary mr-2"></i> Property
                        </h3>
                        <div class="space-y-2 text-sm">
                            <p><span class="text-gray-600">Name:</span> <span class="font-semibold">{{ $booking->property->title }}</span></p>
                            <p><span class="text-gray-600">Location:</span> <span class="font-semibold">{{ $booking->property->city }}, {{ $booking->property->state }}</span></p>
                            <p><span class="text-gray-600">Type:</span> <span class="font-semibold">{{ $booking->property->house_type }}</span></p>
                        </div>
                    </div>

                    <div class="bg-blue-50 rounded-lg p-4">
                        <h3 class="font-bold text-secondary mb-3 flex items-center">
                            <i class="fas fa-calendar-alt text-primary mr-2"></i> Stay Period
                        </h3>
                        <div class="space-y-2 text-sm">
                            <p><span class="text-gray-600">Check-in:</span> <span class="font-semibold">{{ $booking->start_date->format('M d, Y') }}</span></p>
                            <p><span class="text-gray-600">Check-out:</span> <span class="font-semibold">{{ $booking->end_date->format('M d, Y') }}</span></p>
                            <p><span class="text-gray-600">Duration:</span> <span class="font-semibold">{{ $booking->nights_count }} night{{ $booking->nights_count > 1 ? 's' : '' }}</span></p>
                        </div>
                    </div>

                    <div class="bg-green-50 rounded-lg p-4">
                        <h3 class="font-bold text-secondary mb-3 flex items-center">
                            <i class="fas fa-users text-primary mr-2"></i> Guests
                        </h3>
                        <div class="space-y-2 text-sm">
                            <p><span class="text-gray-600">Adults:</span> <span class="font-semibold">{{ $booking->adults_count }}</span></p>
                            <p><span class="text-gray-600">Children:</span> <span class="font-semibold">{{ $booking->children_count }}</span></p>
                            <p><span class="text-gray-600">Trip Type:</span> <span class="font-semibold">{{ ucfirst($booking->trip_type) }}</span></p>
                        </div>
                    </div>

                    <div class="bg-yellow-50 rounded-lg p-4">
                        <h3 class="font-bold text-secondary mb-3 flex items-center">
                            <i class="fas fa-money-bill-wave text-primary mr-2"></i> Payment
                        </h3>
                        <div class="space-y-2 text-sm">
                            <p><span class="text-gray-600">Status:</span> 
                                <span class="font-semibold {{ $booking->payment_status === 'paid' ? 'text-green-600' : 'text-yellow-600' }}">
                                    {{ ucfirst($booking->payment_status) }}
                                </span>
                            </p>
                            <p><span class="text-gray-600">Total:</span> <span class="font-bold text-lg text-primary">₦{{ number_format($booking->total_amount) }}</span></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Summary -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-6 flex items-center">
                    <i class="fas fa-file-invoice-dollar text-primary mr-3"></i> Payment Breakdown
                </h2>
                
                <div class="space-y-3">
                    <div class="flex justify-between items-center py-3 border-b">
                        <span class="text-gray-700">Accommodation ({{ $booking->nights_count }} nights × ₦{{ number_format($booking->property_price_per_night) }})</span>
                        <span class="font-semibold text-gray-900">₦{{ number_format($booking->subtotal) }}</span>
                    </div>
                    <div class="flex justify-between items-center py-3 border-b">
                        <span class="text-gray-700">Caution Fee <span class="text-xs text-gray-500">(Refundable)</span></span>
                        <span class="font-semibold text-yellow-600">₦{{ number_format($booking->caution_fee_amount) }}</span>
                    </div>
                    @if($booking->discount_amount > 0)
                        <div class="flex justify-between items-center py-3 border-b bg-green-50 -mx-4 px-4">
                            <span class="text-green-700 flex items-center">
                                <i class="fas fa-tag mr-2"></i>
                                Discount <span class="text-xs ml-1">({{ $booking->discount_code }})</span>
                            </span>
                            <span class="font-semibold text-green-700">-₦{{ number_format($booking->discount_amount) }}</span>
                        </div>
                    @endif
                    <div class="flex justify-between items-center py-4 bg-primary/5 rounded-lg px-4">
                        <span class="font-bold text-lg text-secondary">Total Amount</span>
                        <span class="font-bold text-2xl text-primary">₦{{ number_format($booking->total_amount) }}</span>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            @if($booking->payment_status === 'pending' && $booking->vendor_approval_status === 'approved')
                <div class="bg-gradient-to-r from-green-50 to-blue-50 rounded-xl shadow-md p-6 border-2 border-green-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="font-bold text-xl text-secondary mb-2">
                                <i class="fas fa-credit-card text-green-600 mr-2"></i> Payment Required
                            </h3>
                            <p class="text-gray-700">Complete your payment to confirm this booking</p>
                        </div>
                        <a href="{{ route('bookings.payment', $booking) }}" 
                            class="bg-gradient-to-r from-primary to-primary-dark text-white px-8 py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                            <i class="fas fa-arrow-right mr-2"></i> Pay Now
                        </a>
                    </div>
                </div>
            @endif

            @if($booking->requires_vendor_approval && $booking->vendor_approval_status === 'pending')
                <div class="bg-yellow-50 rounded-xl shadow-md p-6 border-l-4 border-yellow-400">
                    <p class="text-yellow-800 font-semibold">
                        <i class="fas fa-clock mr-2"></i> Waiting for vendor approval...
                    </p>
                    <p class="text-sm text-gray-700 mt-2">The property owner is reviewing your booking request. You'll be notified once they respond.</p>
                </div>
            @endif

            <!-- Check-In Button -->
            @if($booking->booking_status === 'confirmed' && $booking->payment_status === 'paid' && !$booking->checked_in_at && $booking->start_date && now()->gte(\Carbon\Carbon::parse($booking->start_date)))
                <form method="POST" action="{{ route('bookings.confirm-checkin', $booking) }}">
                    @csrf
                    <div class="bg-gradient-to-r from-green-50 to-teal-50 rounded-xl shadow-md p-6 border-2 border-green-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="font-bold text-xl text-secondary mb-2">
                                    <i class="fas fa-door-open text-green-600 mr-2"></i> Ready to Check In?
                                </h3>
                                <p class="text-gray-700">Confirm your arrival at the property</p>
                            </div>
                            <button type="submit" 
                                class="bg-gradient-to-r from-green-500 to-green-600 text-white px-8 py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                                <i class="fas fa-sign-in-alt mr-2"></i> Confirm Check-In
                            </button>
                        </div>
                    </div>
                </form>
            @endif

            <!-- Check-Out Button -->
            @if(($booking->checked_in_at || $booking->booking_status === 'checked_in') && !$booking->checked_out_at)
                <form method="POST" action="{{ route('bookings.confirm-checkout', $booking) }}">
                    @csrf
                    <div class="bg-gradient-to-r from-blue-50 to-purple-50 rounded-xl shadow-md p-6 border-2 border-blue-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="font-bold text-xl text-secondary mb-2">
                                    <i class="fas fa-door-closed text-blue-600 mr-2"></i> Ready to Check Out?
                                </h3>
                                <p class="text-gray-700">Confirm your departure from the property</p>
                                <p class="text-sm text-gray-600 mt-1">Your caution fee will be processed after check-out</p>
                                @if($booking->end_date && now()->lt(\Carbon\Carbon::parse($booking->end_date)))
                                    <p class="text-xs text-yellow-600 mt-2">
                                        <i class="fas fa-info-circle mr-1"></i>Note: You're checking out before the scheduled date ({{ \Carbon\Carbon::parse($booking->end_date)->format('M d, Y') }})
                                    </p>
                                @endif
                            </div>
                            <button type="submit" 
                                class="bg-gradient-to-r from-blue-500 to-blue-600 text-white px-8 py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                                <i class="fas fa-sign-out-alt mr-2"></i> Confirm Check-Out
                            </button>
                        </div>
                    </div>
                </form>
            @endif

            <!-- Check-In/Out Status Display -->
            @if($booking->checked_in_at || $booking->checked_out_at || $booking->booking_status === 'checked_in')
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="font-bold text-lg text-secondary mb-4">
                        <i class="fas fa-clipboard-check text-primary mr-2"></i> Check-In/Out Status
                    </h3>
                    <div class="grid md:grid-cols-2 gap-4">
                        @if($booking->checked_in_at || $booking->booking_status === 'checked_in')
                            <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded">
                                <p class="font-semibold text-green-800 mb-1">
                                    <i class="fas fa-check-circle mr-2"></i>Checked In
                                </p>
                                <p class="text-sm text-green-700">
                                    {{ $booking->checked_in_at ? $booking->checked_in_at->format('M d, Y h:i A') : 'Confirmed' }}
                                </p>
                            </div>
                        @endif
                        @if($booking->checked_out_at)
                            <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded">
                                <p class="font-semibold text-blue-800 mb-1">
                                    <i class="fas fa-check-circle mr-2"></i>Checked Out
                                </p>
                                <p class="text-sm text-blue-700">
                                    {{ $booking->checked_out_at->format('M d, Y h:i A') }}
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            @endif

            <!-- Vendor & Location Info -->
            @if($booking->user_visible_vendor_info && $booking->map_visible)
                <div class="bg-gradient-to-r from-green-50 to-teal-50 rounded-xl shadow-md p-6 border-2 border-green-200">
                    <h3 class="font-bold text-xl text-secondary mb-4">
                        <i class="fas fa-unlock text-green-600 mr-2"></i> 🎉 Booking Confirmed - Details Unlocked!
                    </h3>
                    
                    <div class="grid md:grid-cols-2 gap-6">
                        <div class="bg-white rounded-lg p-4">
                            <h4 class="font-semibold text-secondary mb-3 flex items-center">
                                <i class="fas fa-user-tie text-primary mr-2"></i> Vendor Contact
                            </h4>
                            <div class="space-y-2 text-sm">
                                <p><span class="text-gray-600">Company:</span> <span class="font-semibold">{{ $booking->vendor->company_name }}</span></p>
                                <p><span class="text-gray-600">Name:</span> <span class="font-semibold">{{ $booking->vendor->user->name }}</span></p>
                                <p><span class="text-gray-600">Phone:</span> <a href="tel:{{ $booking->vendor->user->phone }}" class="font-semibold text-primary hover:underline">{{ $booking->vendor->user->phone }}</a></p>
                                <p><span class="text-gray-600">Email:</span> <a href="mailto:{{ $booking->vendor->user->email }}" class="font-semibold text-primary hover:underline">{{ $booking->vendor->user->email }}</a></p>
                            </div>
                        </div>

                        <div class="bg-white rounded-lg p-4">
                            <h4 class="font-semibold text-secondary mb-3 flex items-center">
                                <i class="fas fa-map-marker-alt text-primary mr-2"></i> Property Location
                            </h4>
                            <p class="text-sm mb-3 text-gray-700">{{ $booking->property->address }}</p>
                            <a href="{{ route('properties.nearby-attractions', $booking->property) }}" 
                                class="text-primary hover:text-primary-dark font-semibold text-sm">
                                <i class="fas fa-map mr-1"></i> View Location & Nearby Attractions →
                            </a>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Write Review Section -->
            @if($booking->booking_status === 'completed' || $booking->end_date->isPast())
                @php
                    $userReview = $booking->property->reviews()->where('user_id', auth()->id())->first();
                @endphp
                
                @if(!$userReview)
                    <div class="bg-gradient-to-r from-yellow-50 to-orange-50 rounded-xl shadow-md p-6 border-2 border-yellow-300">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="font-bold text-xl text-secondary mb-2">
                                    <i class="fas fa-star text-yellow-500 mr-2"></i> How was your stay?
                                </h3>
                                <p class="text-gray-700">Share your experience and help other travelers</p>
                            </div>
                            <a href="{{ route('reviews.create', ['property' => $booking->property->id, 'booking' => $booking->id]) }}" 
                                class="bg-gradient-to-r from-yellow-500 to-orange-500 text-white px-8 py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105 whitespace-nowrap">
                                <i class="fas fa-pen mr-2"></i> Write Review
                            </a>
                        </div>
                    </div>
                @else
                    <div class="bg-green-50 rounded-xl shadow-md p-6 border-2 border-green-200">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-600 text-3xl mr-4"></i>
                            <div>
                                <h3 class="font-bold text-lg text-green-800">Thank you for your review!</h3>
                                <p class="text-gray-700">You rated this property {{ $userReview->rating }} stars on {{ $userReview->created_at->format('M d, Y') }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <!-- Property Card -->
            <div class="bg-white rounded-xl shadow-lg p-6 sticky top-4 space-y-6">
                <div>
                    <h3 class="font-bold text-secondary mb-4 flex items-center">
                        <i class="fas fa-home text-primary mr-2"></i> Property
                    </h3>
                    
                    @if(isset($booking->property->photos[0]))
                        <img src="{{ asset('storage/' . $booking->property->photos[0]) }}" 
                            alt="{{ $booking->property->title }}"
                            class="w-full h-48 object-cover rounded-lg mb-4">
                    @endif
                    
                    <h4 class="font-bold text-lg text-secondary mb-2">{{ $booking->property->title }}</h4>
                    <p class="text-sm text-gray-600 mb-4 flex items-center">
                        <i class="fas fa-map-marker-alt text-primary mr-2"></i>
                        {{ $booking->property->city }}, {{ $booking->property->state }}
                    </p>
                    
                    <a href="{{ route('properties.show', $booking->property) }}" 
                        class="block w-full text-center bg-gray-100 text-primary py-3 rounded-lg hover:bg-gray-200 font-semibold transition">
                        <i class="fas fa-eye mr-2"></i> View Property
                    </a>

                    @if($booking->payment_status === 'paid')
                        <!-- View/Download Receipt -->
                        <a href="{{ route('bookings.receipt', $booking) }}" 
                           target="_blank"
                           class="block w-full text-center bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition mt-4">
                            <i class="fas fa-file-invoice mr-2"></i> View Receipt
                        </a>
                    @endif

                    @if($booking->payment_status === 'paid')
                        <!-- Contact Vendor Section -->
                        <div class="mt-4 space-y-2">
                            @if($booking->property->vendor->user->phone)
                                <a href="tel:{{ $booking->property->vendor->user->phone }}" 
                                    class="block w-full text-center bg-blue-500 text-white py-3 rounded-lg hover:bg-blue-600 font-semibold transition">
                                    <i class="fas fa-phone mr-2"></i> Call Vendor
                                </a>
                            @endif

                            @if($booking->property->vendor->whatsapp_number)
                                @php
                                    $whatsappNumber = preg_replace('/[^0-9]/', '', $booking->property->vendor->whatsapp_number);
                                    $message = "Hello, I have a confirmed booking for *{$booking->property->title}*\n\n";
                                    $message .= "📋 Booking Reference: {$booking->payment_reference}\n";
                                    $message .= "📅 Check-in: " . $booking->start_date->format('M d, Y') . "\n";
                                    $message .= "📅 Check-out: " . $booking->end_date->format('M d, Y') . "\n";
                                    $message .= "👥 Guests: {$booking->adults_count} adults, {$booking->children_count} children\n\n";
                                    $message .= "I would like to discuss the booking details.";
                                    $whatsappUrl = "https://wa.me/{$whatsappNumber}?text=" . urlencode($message);
                                @endphp
                                <a href="{{ $whatsappUrl }}" 
                                    target="_blank"
                                    class="block w-full text-center bg-green-500 text-white py-3 rounded-lg hover:bg-green-600 font-semibold transition">
                                    <i class="fab fa-whatsapp mr-2"></i> WhatsApp Vendor
                                </a>
                            @endif
                        </div>
                    @endif
                </div>

                <!-- Quick Stats -->
                <div class="border-t pt-6">
                    <h4 class="font-bold text-sm text-gray-700 mb-3">Quick Info</h4>
                    <div class="space-y-3 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Booking Date</span>
                            <span class="font-semibold">{{ $booking->created_at->format('M d, Y') }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Status</span>
                            <span class="font-semibold text-primary">{{ ucfirst($booking->booking_status) }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Payment</span>
                            <span class="font-semibold {{ $booking->payment_status === 'paid' ? 'text-green-600' : 'text-yellow-600' }}">
                                {{ ucfirst($booking->payment_status) }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Help Section -->
                <div class="border-t pt-6">
                    <h4 class="font-bold text-sm text-gray-700 mb-3">Need Help?</h4>
                    <p class="text-xs text-gray-600 mb-3">Contact our support team on WhatsApp</p>
                    @php
                        $whatsappNumber = \App\Models\Setting::where('key', 'whatsapp_number')->value('value') ?? '+2348173562180';
                        $cleanNumber = preg_replace('/[^0-9]/', '', $whatsappNumber);
                        $message = urlencode("Hello, I need help with my booking #" . $booking->id);
                    @endphp
                    <a href="https://wa.me/{{ $cleanNumber }}?text={{ $message }}" 
                       target="_blank"
                       class="block w-full text-center border-2 border-green-500 text-green-600 py-3 rounded-lg hover:bg-green-500 hover:text-white font-semibold transition">
                        <i class="fab fa-whatsapp mr-2"></i> Contact Us on WhatsApp
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Caution Fee Refund Section -->
    @if($booking->booking_status === 'completed')
        <div class="bg-white rounded-xl shadow-md p-6 mt-6">
            <h2 class="text-xl font-bold text-secondary mb-6 flex items-center">
                <i class="fas fa-money-check-alt text-primary mr-3"></i> Caution Fee Refund
            </h2>
            
            <div class="bg-gradient-to-r from-blue-50 to-purple-50 border-2 border-blue-200 rounded-lg p-6 mb-6">
                <div class="flex justify-between items-center">
                    <div>
                        <p class="font-bold text-2xl text-primary">₦{{ number_format($booking->caution_fee_amount) }}</p>
                        <p class="text-sm text-gray-600">Refundable Deposit</p>
                    </div>
                    <span class="px-6 py-3 rounded-full font-bold text-sm
                        @if($booking->caution_refund_status === 'approved') bg-green-500 text-white
                        @elseif($booking->caution_refund_status === 'rejected') bg-red-500 text-white
                        @elseif($booking->caution_refund_status === 'refunded') bg-blue-500 text-white
                        @else bg-yellow-400 text-gray-900
                        @endif">
                        {{ ucfirst(str_replace('_', ' ', $booking->caution_refund_status)) }}
                    </span>
                </div>
            </div>

            @if($booking->caution_refund_status === 'pending')
                <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4">
                    <p class="text-yellow-800 font-semibold mb-2">
                        <i class="fas fa-clock mr-2"></i> Waiting for Vendor Decision
                    </p>
                    <p class="text-sm text-gray-700">
                        The vendor will review the property condition and decide on your caution fee refund. 
                        This typically takes 1-3 business days after checkout.
                    </p>
                </div>
            @elseif($booking->caution_refund_status === 'pending_vendor')
                <div class="bg-orange-50 border-l-4 border-orange-400 rounded-lg p-4">
                    <p class="text-orange-800 font-semibold mb-2">
                        <i class="fas fa-exclamation-triangle mr-2"></i> Damage Claim Under Review
                    </p>
                    <p class="text-sm text-gray-700 mb-3">
                        The vendor has reported property damage. Admin is reviewing the claim.
                    </p>
                    @if($booking->caution_deduction_amount)
                        <div class="bg-white rounded p-3 mt-2">
                            <p class="text-sm"><strong>Requested Deduction:</strong> ₦{{ number_format($booking->caution_deduction_amount) }}</p>
                            @if($booking->caution_deduction_reason)
                                <p class="text-sm mt-1"><strong>Reason:</strong> {{ $booking->caution_deduction_reason }}</p>
                            @endif
                        </div>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'deducted' || $booking->caution_refund_status === 'partially_deducted')
                <div class="bg-orange-50 border-l-4 border-orange-500 rounded-lg p-4">
                    <p class="text-orange-800 font-semibold mb-2">
                        <i class="fas fa-info-circle mr-2"></i> Partial Refund - Deduction Applied
                    </p>
                    <div class="grid md:grid-cols-3 gap-4 mt-3">
                        <div class="bg-white rounded p-3">
                            <p class="text-xs text-gray-600">Original Deposit</p>
                            <p class="font-bold text-lg">₦{{ number_format($booking->caution_fee_amount) }}</p>
                        </div>
                        <div class="bg-white rounded p-3">
                            <p class="text-xs text-gray-600">Deduction</p>
                            <p class="font-bold text-lg text-red-600">-₦{{ number_format($booking->caution_deduction_amount ?? 0) }}</p>
                        </div>
                        <div class="bg-white rounded p-3">
                            <p class="text-xs text-gray-600">Your Refund</p>
                            <p class="font-bold text-lg text-green-600">₦{{ number_format($booking->caution_refund_amount ?? 0) }}</p>
                        </div>
                    </div>
                    @if($booking->admin_notes)
                        <div class="mt-3 p-3 bg-white rounded">
                            <p class="text-sm"><strong>Admin Decision:</strong> {{ $booking->admin_notes }}</p>
                        </div>
                    @endif
                    
                    @if($booking->refund_payout_status === 'pending' && $booking->caution_refund_amount > 0)
                        <form method="POST" action="{{ route('bookings.request-refund', $booking) }}" class="mt-4">
                            @csrf
                            <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                <i class="fas fa-hand-holding-usd mr-2"></i> Request Refund Payout (₦{{ number_format($booking->caution_refund_amount) }})
                            </button>
                        </form>
                    @elseif($booking->refund_payout_status === 'requested')
                        <div class="mt-4 bg-blue-50 border border-blue-200 rounded-lg p-3">
                            <p class="text-blue-800 text-sm">
                                <i class="fas fa-clock mr-2"></i> Refund request submitted on {{ $booking->refund_requested_at->format('M d, Y') }}. Admin is processing your payout.
                            </p>
                        </div>
                    @elseif($booking->refund_payout_status === 'processing')
                        <div class="mt-4 bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                            <p class="text-yellow-800 text-sm">
                                <i class="fas fa-spinner fa-spin mr-2"></i> Your refund is being processed. You'll receive it soon.
                            </p>
                        </div>
                    @elseif($booking->refund_payout_status === 'paid')
                        <div class="mt-4 bg-green-50 border border-green-200 rounded-lg p-3">
                            <p class="text-green-800 text-sm">
                                <i class="fas fa-check-circle mr-2"></i> Refund paid on {{ $booking->refund_paid_at->format('M d, Y') }}
                            </p>
                        </div>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'refunded')
                <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                    <p class="text-green-800 font-semibold mb-2">
                        <i class="fas fa-check-circle mr-2"></i> Full Refund Approved!
                    </p>
                    <p class="text-sm text-gray-700 mb-3">
                        Your full caution fee of ₦{{ number_format($booking->caution_refund_amount ?? $booking->caution_fee_amount) }} is ready for payout.
                    </p>
                    @if($booking->caution_refunded_at)
                        <p class="text-xs text-gray-500 mb-3">
                            Approved on {{ $booking->caution_refunded_at->format('M d, Y H:i') }}
                        </p>
                    @endif
                    
                    @if($booking->refund_payout_status === 'pending' && ($booking->caution_refund_amount ?? 0) > 0)
                        <form method="POST" action="{{ route('bookings.request-refund', $booking) }}" class="mt-3">
                            @csrf
                            <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                <i class="fas fa-hand-holding-usd mr-2"></i> Request Refund Payout (₦{{ number_format($booking->caution_refund_amount ?? $booking->caution_fee_amount) }})
                            </button>
                        </form>
                    @elseif($booking->refund_payout_status === 'requested')
                        <div class="mt-3 bg-blue-50 border border-blue-200 rounded-lg p-3">
                            <p class="text-blue-800 text-sm">
                                <i class="fas fa-clock mr-2"></i> Refund request submitted on {{ $booking->refund_requested_at->format('M d, Y') }}. Admin is processing your payout.
                            </p>
                        </div>
                    @elseif($booking->refund_payout_status === 'processing')
                        <div class="mt-3 bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                            <p class="text-yellow-800 text-sm">
                                <i class="fas fa-spinner fa-spin mr-2"></i> Your refund is being processed. You'll receive it soon.
                            </p>
                        </div>
                    @elseif($booking->refund_payout_status === 'paid')
                        <div class="mt-3 bg-green-50 border border-green-200 rounded-lg p-3">
                            <p class="text-green-800 text-sm">
                                <i class="fas fa-check-circle mr-2"></i> Refund paid on {{ $booking->refund_paid_at->format('M d, Y') }}
                            </p>
                        </div>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'approved')
                <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                    <p class="text-green-800 font-semibold mb-2">
                        <i class="fas fa-check-circle mr-2"></i> Refund Approved!
                    </p>
                    <p class="text-sm text-gray-700 mb-3">
                        Your caution fee has been approved for refund. The amount will be processed to your bank account within 3-5 business days.
                    </p>
                    @if($booking->caution_refund_reason)
                        <p class="text-sm text-gray-600">
                            <strong>Note:</strong> {{ $booking->caution_refund_reason }}
                        </p>
                    @endif
                    @if($booking->caution_refund_decided_at)
                        <p class="text-xs text-gray-500 mt-2">
                            Approved on {{ $booking->caution_refund_decided_at->format('M d, Y H:i') }}
                        </p>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'rejected')
                <div class="bg-red-50 border-l-4 border-red-500 rounded-lg p-4">
                    <p class="text-red-800 font-semibold mb-2">
                        <i class="fas fa-times-circle mr-2"></i> Refund Denied
                    </p>
                    <p class="text-sm text-gray-700 mb-2">
                        The vendor has decided to forfeit your caution fee due to property damage or policy violation.
                    </p>
                    @if($booking->caution_refund_reason)
                        <p class="text-sm text-gray-700 mb-2">
                            <strong>Reason:</strong> {{ $booking->caution_refund_reason }}
                        </p>
                    @endif
                    @if($booking->caution_refund_decided_at)
                        <p class="text-xs text-gray-500">
                            Decided on {{ $booking->caution_refund_decided_at->format('M d, Y H:i') }}
                        </p>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'refunded')
                <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-4">
                    <p class="text-blue-800 font-semibold mb-2">
                        <i class="fas fa-money-bill-wave mr-2"></i> Refund Completed
                    </p>
                    <p class="text-sm text-gray-700">
                        Your caution fee of ₦{{ number_format($booking->caution_fee_amount) }} has been refunded to your bank account.
                    </p>
                </div>
            @endif

            <!-- Caution Fee Logs -->
            @if($booking->cautionRefundLogs && $booking->cautionRefundLogs->count() > 0)
                <div class="border-t pt-6 mt-6">
                    <h4 class="font-semibold mb-4 text-secondary">Refund History</h4>
                    <div class="space-y-3">
                        @foreach($booking->cautionRefundLogs as $log)
                            <div class="bg-gray-50 rounded-lg p-4">
                                <div class="flex items-start justify-between">
                                    <div>
                                        <p class="font-semibold text-secondary">{{ ucfirst($log->new_status) }}</p>
                                        <p class="text-gray-600 text-sm mt-1">
                                            by {{ $log->actor->name }} on {{ $log->created_at->format('M d, Y H:i') }}
                                        </p>
                                        @if($log->reason)
                                            <p class="text-gray-700 text-sm mt-2 bg-white rounded p-2">{{ $log->reason }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    @endif
</div>
@endsection
