@extends('layouts.app')

@section('title', 'Reset Password')

@section('content')
<div class="max-w-md mx-auto py-12">
    <div class="bg-white rounded-xl shadow-lg p-8">
        <!-- Header -->
        <div class="text-center mb-6">
            <div class="bg-primary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-key text-primary text-2xl"></i>
            </div>
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Reset Password</h1>
            <p class="text-gray-600">Enter your new password below</p>
        </div>

        <!-- Form -->
        <form method="POST" action="{{ route('password.update') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $token }}">

            <!-- Email -->
            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-envelope text-primary mr-2"></i>Email Address
                </label>
                <input type="email" 
                    name="email" 
                    value="{{ old('email', $email ?? '') }}" 
                    required 
                    autofocus
                    readonly
                    class="w-full border-2 rounded-lg px-4 py-3 bg-gray-50 cursor-not-allowed @error('email') border-red-500 @enderror">
                @error('email')
                    <p class="text-red-500 text-sm mt-2 flex items-center">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        {{ $message }}
                    </p>
                @enderror
            </div>

            <!-- New Password -->
            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-lock text-primary mr-2"></i>New Password
                </label>
                <div class="relative">
                    <input type="password" 
                        id="password" 
                        name="password" 
                        required
                        placeholder="Enter new password"
                        class="w-full border-2 rounded-lg px-4 py-3 pr-10 focus:border-primary focus:outline-none transition @error('password') border-red-500 @enderror">
                    <button type="button" 
                        onclick="togglePassword('password', 'toggleIcon1')" 
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700">
                        <i id="toggleIcon1" class="fas fa-eye"></i>
                    </button>
                </div>
                @error('password')
                    <p class="text-red-500 text-sm mt-2 flex items-center">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        {{ $message }}
                    </p>
                @enderror
                <p class="text-xs text-gray-500 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>
                    Password must be at least 8 characters
                </p>
            </div>

            <!-- Confirm Password -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-lock text-primary mr-2"></i>Confirm Password
                </label>
                <div class="relative">
                    <input type="password" 
                        id="password_confirmation" 
                        name="password_confirmation" 
                        required
                        placeholder="Confirm new password"
                        class="w-full border-2 rounded-lg px-4 py-3 pr-10 focus:border-primary focus:outline-none transition">
                    <button type="button" 
                        onclick="togglePassword('password_confirmation', 'toggleIcon2')" 
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700">
                        <i id="toggleIcon2" class="fas fa-eye"></i>
                    </button>
                </div>
            </div>

            <!-- Submit Button -->
            <button type="submit" 
                class="w-full bg-gradient-to-r from-primary to-primary-dark text-white py-3 rounded-lg hover:shadow-lg font-semibold transition transform hover:scale-105">
                <i class="fas fa-check-circle mr-2"></i>Reset Password
            </button>
        </form>

        <!-- Back to Login -->
        <div class="mt-6 text-center">
            <a href="{{ route('login') }}" class="text-primary hover:text-primary-dark font-semibold inline-flex items-center">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Login
            </a>
        </div>
    </div>

    <!-- Password Requirements -->
    <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
        <h3 class="font-semibold text-blue-900 mb-2">
            <i class="fas fa-shield-alt mr-2"></i>Password Requirements
        </h3>
        <ul class="text-sm text-blue-800 space-y-1">
            <li><i class="fas fa-check text-green-600 mr-2"></i>At least 8 characters long</li>
            <li><i class="fas fa-check text-green-600 mr-2"></i>Mix of uppercase and lowercase letters</li>
            <li><i class="fas fa-check text-green-600 mr-2"></i>Include numbers and special characters</li>
        </ul>
    </div>
</div>

<script>
function togglePassword(inputId, iconId) {
    const input = document.getElementById(inputId);
    const icon = document.getElementById(iconId);
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>
@endsection
