@extends('layouts.admin')

@section('title', 'Manage Vendors')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Manage Vendors</h1>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <form method="GET" class="grid md:grid-cols-3 gap-4">
            <input type="text" 
                name="search" 
                placeholder="Search by name/email" 
                value="{{ request('search') }}"
                class="border rounded px-4 py-2">

            <select name="verified" class="border rounded px-4 py-2">
                <option value="">All Vendors</option>
                <option value="1" {{ request('verified') === '1' ? 'selected' : '' }}>Verified Only</option>
                <option value="0" {{ request('verified') === '0' ? 'selected' : '' }}>Unverified Only</option>
            </select>

            <button type="submit" class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                Filter
            </button>
        </form>
    </div>

    <!-- Vendors Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="w-full">
            <thead class="bg-light-bg">
                <tr>
                    <th class="px-4 py-3 text-left">ID</th>
                    <th class="px-4 py-3 text-left">Company</th>
                    <th class="px-4 py-3 text-left">Contact</th>
                    <th class="px-4 py-3 text-left">Properties</th>
                    <th class="px-4 py-3 text-left">Commission</th>
                    <th class="px-4 py-3 text-left">Balance</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($vendors as $vendor)
                    <tr class="border-b hover:bg-light-bg">
                        <td class="px-4 py-3">#{{ $vendor->id }}</td>
                        <td class="px-4 py-3">
                            <p class="font-semibold">{{ $vendor->company_name }}</p>
                        </td>
                        <td class="px-4 py-3">
                            <p>{{ $vendor->user->name }}</p>
                            <p class="text-xs text-gray-600">{{ $vendor->user->email }}</p>
                        </td>
                        <td class="px-4 py-3">{{ $vendor->properties_count ?? 0 }}</td>
                        <td class="px-4 py-3">{{ $vendor->commission_rate_at_signup }}%</td>
                        <td class="px-4 py-3">₦{{ number_format($vendor->pending_balance) }}</td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs
                                {{ $vendor->verified ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                {{ $vendor->verified ? 'Verified' : 'Pending' }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <a href="{{ route('admin.vendors.show', $vendor) }}" 
                                class="text-primary hover:underline">View</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center py-8 text-gray-600">No vendors found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $vendors->links() }}
    </div>
</div>
@endsection