@extends('layouts.admin')

@section('title', 'Property Approvals')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Property Management</h1>

    <!-- Status Filter -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <div class="flex gap-2">
            <a href="{{ route('admin.properties.index', ['status' => 'pending']) }}" 
                class="px-4 py-2 rounded {{ $status === 'pending' ? 'bg-yellow-600 text-white' : 'bg-gray-200' }}">
                Pending ({{ \App\Models\Property::where('status', 'pending')->count() }})
            </a>
            <a href="{{ route('admin.properties.index', ['status' => 'active']) }}" 
                class="px-4 py-2 rounded {{ $status === 'active' ? 'bg-green-600 text-white' : 'bg-gray-200' }}">
                Active
            </a>
            <a href="{{ route('admin.properties.index', ['status' => 'inactive']) }}" 
                class="px-4 py-2 rounded {{ $status === 'inactive' ? 'bg-gray-600 text-white' : 'bg-gray-200' }}">
                Inactive
            </a>
            <a href="{{ route('admin.properties.index', ['status' => 'rejected']) }}" 
                class="px-4 py-2 rounded {{ $status === 'rejected' ? 'bg-red-600 text-white' : 'bg-gray-200' }}">
                Rejected
            </a>
        </div>
    </div>

    <!-- Properties List -->
    <div class="grid md:grid-cols-2 gap-6">
        @forelse($properties as $property)
            <div class="bg-white rounded-lg shadow-md overflow-hidden">
                <img src="{{ isset($property->photos[0]) ? asset('storage/' . $property->photos[0]) : '/images/placeholder.jpg' }}" 
                    alt="{{ $property->title }}" 
                    class="w-full h-48 object-cover">
                
                <div class="p-4">
                    <div class="flex justify-between items-start mb-2">
                        <h3 class="font-bold text-lg">{{ $property->title }}</h3>
                        <span class="px-2 py-1 rounded text-xs font-semibold
                            {{ $property->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 
                               ($property->status === 'active' ? 'bg-green-100 text-green-800' : 
                               ($property->status === 'rejected' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-secondary')) }}">
                            {{ ucfirst($property->status) }}
                        </span>
                    </div>

                    <p class="text-gray-600 text-sm mb-2">{{ $property->city }}, {{ $property->state }}</p>
                    <p class="text-gray-600 text-sm mb-2">
                        <strong>Vendor:</strong> {{ $property->vendor->company_name }}
                    </p>
                    <p class="text-primary font-bold mb-3">₦{{ number_format($property->price_per_night) }}/night</p>

                    @if($property->rejection_reason)
                        <div class="bg-red-50 border border-red-200 rounded p-2 mb-3">
                            <p class="text-xs text-red-800"><strong>Rejection Reason:</strong></p>
                            <p class="text-xs text-red-600">{{ $property->rejection_reason }}</p>
                        </div>
                    @endif

                    <div class="flex gap-2">
                        <a href="{{ route('admin.properties.show', $property) }}" 
                            class="flex-1 bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark text-center text-sm">
                            View Details
                        </a>

                        @if($property->status === 'pending')
                            <form method="POST" action="{{ route('admin.properties.approve', $property) }}" class="flex-1">
                                @csrf
                                <button type="submit" 
                                    class="w-full bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                    Approve
                                </button>
                            </form>
                            
                            <button onclick="openRejectModal({{ $property->id }})" 
                                class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm">
                                Reject
                            </button>
                        @elseif($property->status === 'active' || $property->status === 'inactive')
                            <form method="POST" action="{{ route('admin.properties.toggle', $property) }}">
                                @csrf
                                <button type="submit" 
                                    class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 text-sm">
                                    {{ $property->status === 'active' ? 'Deactivate' : 'Activate' }}
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
        @empty
            <div class="col-span-2 bg-white rounded-lg shadow-md p-12 text-center">
                <p class="text-gray-600">No properties found with status: {{ $status }}</p>
            </div>
        @endforelse
    </div>

    <div class="mt-6">
        {{ $properties->links() }}
    </div>
</div>

<!-- Reject Modal -->
<div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-8 max-w-md w-full mx-4">
        <h2 class="text-2xl font-bold mb-4">Reject Property</h2>
        
        <form id="reject-form" method="POST">
            @csrf
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Reason for Rejection *</label>
                <textarea name="rejection_reason" rows="4" required
                    placeholder="Please provide a detailed reason..."
                    class="w-full border rounded px-4 py-2"></textarea>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-4 py-3 rounded hover:bg-gray-300 font-semibold">
                    Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-red-600 text-white px-4 py-3 rounded hover:bg-red-700 font-semibold">
                    Reject Property
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openRejectModal(propertyId) {
    document.getElementById('reject-form').action = `/admin/properties/${propertyId}/reject`;
    document.getElementById('reject-modal').classList.remove('hidden');
}
</script>
@endsection
