@extends('layouts.admin')

@section('title', 'Promo Codes')

@section('content')
<div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-3xl font-bold text-secondary">Promo Codes</h1>
            <p class="text-gray-600 mt-1">Manage vendor ad discount codes</p>
        </div>
        <a href="{{ route('admin.promo-codes.create') }}" 
            class="bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark transition flex items-center">
            <i class="fas fa-plus mr-2"></i> Create Promo Code
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        </div>
    @endif

    <!-- Promo Codes Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Code</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Discount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Usage</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Valid Until</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($promoCodes as $promo)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="font-mono font-bold text-primary">{{ $promo->code }}</span>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900">{{ $promo->name }}</div>
                            @if($promo->description)
                                <div class="text-xs text-gray-500">{{ Str::limit($promo->description, 50) }}</div>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($promo->discount_type === 'percentage')
                                <span class="text-green-600 font-semibold">{{ $promo->discount_value }}% OFF</span>
                                @if($promo->max_discount_amount)
                                    <div class="text-xs text-gray-500">Max: ₦{{ number_format($promo->max_discount_amount) }}</div>
                                @endif
                            @else
                                <span class="text-green-600 font-semibold">₦{{ number_format($promo->discount_value) }} OFF</span>
                            @endif
                            @if($promo->min_ad_amount > 0)
                                <div class="text-xs text-gray-500">Min: ₦{{ number_format($promo->min_ad_amount) }}</div>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                {{ $promo->usage_count }} / {{ $promo->usage_limit ?? '∞' }}
                            </div>
                            <div class="text-xs text-gray-500">
                                {{ $promo->usage_per_vendor }}x per vendor
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            @if($promo->valid_until)
                                {{ $promo->valid_until->format('M d, Y') }}
                                @if($promo->valid_until->isPast())
                                    <span class="text-red-500">(Expired)</span>
                                @endif
                            @else
                                <span class="text-gray-400">No expiry</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($promo->is_active && $promo->isValid())
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                    Active
                                </span>
                            @elseif($promo->is_active)
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                    Scheduled
                                </span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                                    Inactive
                                </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-2">
                                <a href="{{ route('admin.promo-codes.edit', $promo) }}" 
                                    class="text-blue-600 hover:text-blue-900" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <form action="{{ route('admin.promo-codes.toggle', $promo) }}" method="POST" class="inline">
                                    @csrf
                                    <button type="submit" 
                                        class="{{ $promo->is_active ? 'text-yellow-600 hover:text-yellow-900' : 'text-green-600 hover:text-green-900' }}"
                                        title="{{ $promo->is_active ? 'Deactivate' : 'Activate' }}">
                                        <i class="fas fa-{{ $promo->is_active ? 'pause' : 'play' }}-circle"></i>
                                    </button>
                                </form>
                                
                                @if($promo->usage_count == 0)
                                    <form action="{{ route('admin.promo-codes.destroy', $promo) }}" method="POST" 
                                        class="inline" onsubmit="return confirm('Are you sure you want to delete this promo code?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-900" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-ticket-alt text-4xl mb-4 text-gray-300"></i>
                            <p class="text-lg">No promo codes found</p>
                            <a href="{{ route('admin.promo-codes.create') }}" class="text-primary hover:underline mt-2 inline-block">
                                Create your first promo code
                            </a>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    @if($promoCodes->hasPages())
        <div class="mt-6">
            {{ $promoCodes->links() }}
        </div>
    @endif
</div>
@endsection
