@extends('layouts.admin')

@section('title', 'Edit Promo Code')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <!-- Header -->
    <div class="mb-6">
        <a href="{{ route('admin.promo-codes.index') }}" class="text-primary hover:underline mb-2 inline-block">
            <i class="fas fa-arrow-left mr-2"></i>Back to Promo Codes
        </a>
        <h1 class="text-3xl font-bold text-secondary">Edit Promo Code</h1>
        <p class="text-gray-600 mt-1">Update promo code: <span class="font-mono font-bold">{{ $promoCode->code }}</span></p>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded">
            <p class="font-bold mb-2">Please fix the following errors:</p>
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Usage Stats -->
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6 rounded">
        <div class="flex items-center">
            <i class="fas fa-info-circle text-blue-500 mr-3"></i>
            <div>
                <p class="font-semibold text-blue-900">Usage Statistics</p>
                <p class="text-sm text-blue-700">
                    This code has been used <strong>{{ $promoCode->usage_count }}</strong> time(s)
                    @if($promoCode->usage_limit)
                        out of {{ $promoCode->usage_limit }} allowed
                    @endif
                </p>
            </div>
        </div>
    </div>

    <form action="{{ route('admin.promo-codes.update', $promoCode) }}" method="POST" class="bg-white rounded-lg shadow-md p-6">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Name -->
            <div class="md:col-span-2">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                    Promo Name <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" id="name" value="{{ old('name', $promoCode->name) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="e.g., New Vendor Welcome Offer">
            </div>

            <!-- Code -->
            <div>
                <label for="code" class="block text-sm font-medium text-gray-700 mb-2">
                    Promo Code <span class="text-red-500">*</span>
                </label>
                <input type="text" name="code" id="code" value="{{ old('code', $promoCode->code) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent uppercase"
                    placeholder="e.g., WELCOME50" style="text-transform: uppercase;">
                <p class="text-xs text-gray-500 mt-1">Letters, numbers, dashes and underscores only</p>
            </div>

            <!-- Discount Type -->
            <div>
                <label for="discount_type" class="block text-sm font-medium text-gray-700 mb-2">
                    Discount Type <span class="text-red-500">*</span>
                </label>
                <select name="discount_type" id="discount_type" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                    <option value="percentage" {{ old('discount_type', $promoCode->discount_type) == 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                    <option value="fixed" {{ old('discount_type', $promoCode->discount_type) == 'fixed' ? 'selected' : '' }}>Fixed Amount (₦)</option>
                </select>
            </div>

            <!-- Discount Value -->
            <div>
                <label for="discount_value" class="block text-sm font-medium text-gray-700 mb-2">
                    Discount Value <span class="text-red-500">*</span>
                </label>
                <input type="number" name="discount_value" id="discount_value" value="{{ old('discount_value', $promoCode->discount_value) }}" 
                    step="0.01" min="0" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="e.g., 50 or 5000">
                <p class="text-xs text-gray-500 mt-1" id="discount_hint">
                    {{ $promoCode->discount_type === 'percentage' ? 'Enter percentage value (0-100)' : 'Enter fixed amount in Naira' }}
                </p>
            </div>

            <!-- Max Discount Amount -->
            <div>
                <label for="max_discount_amount" class="block text-sm font-medium text-gray-700 mb-2">
                    Max Discount Amount (₦)
                </label>
                <input type="number" name="max_discount_amount" id="max_discount_amount" value="{{ old('max_discount_amount', $promoCode->max_discount_amount) }}" 
                    step="0.01" min="0"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="Optional - for percentage discounts">
                <p class="text-xs text-gray-500 mt-1">Cap the maximum discount for percentage type</p>
            </div>

            <!-- Min Ad Amount -->
            <div>
                <label for="min_ad_amount" class="block text-sm font-medium text-gray-700 mb-2">
                    Minimum Ad Amount (₦) <span class="text-red-500">*</span>
                </label>
                <input type="number" name="min_ad_amount" id="min_ad_amount" value="{{ old('min_ad_amount', $promoCode->min_ad_amount) }}" 
                    step="0.01" min="0" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="0">
                <p class="text-xs text-gray-500 mt-1">Minimum ad amount required to use this code</p>
            </div>

            <!-- Usage Limit -->
            <div>
                <label for="usage_limit" class="block text-sm font-medium text-gray-700 mb-2">
                    Total Usage Limit
                </label>
                <input type="number" name="usage_limit" id="usage_limit" value="{{ old('usage_limit', $promoCode->usage_limit) }}" 
                    min="1"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="Leave empty for unlimited">
                <p class="text-xs text-gray-500 mt-1">Total number of times this code can be used</p>
            </div>

            <!-- Usage Per Vendor -->
            <div>
                <label for="usage_per_vendor" class="block text-sm font-medium text-gray-700 mb-2">
                    Usage Per Vendor <span class="text-red-500">*</span>
                </label>
                <input type="number" name="usage_per_vendor" id="usage_per_vendor" value="{{ old('usage_per_vendor', $promoCode->usage_per_vendor) }}" 
                    min="1" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="1">
                <p class="text-xs text-gray-500 mt-1">How many times each vendor can use this code</p>
            </div>

            <!-- Valid From -->
            <div>
                <label for="valid_from" class="block text-sm font-medium text-gray-700 mb-2">
                    Valid From
                </label>
                <input type="datetime-local" name="valid_from" id="valid_from" 
                    value="{{ old('valid_from', $promoCode->valid_from ? $promoCode->valid_from->format('Y-m-d\TH:i') : '') }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                <p class="text-xs text-gray-500 mt-1">Leave empty to start immediately</p>
            </div>

            <!-- Valid Until -->
            <div>
                <label for="valid_until" class="block text-sm font-medium text-gray-700 mb-2">
                    Valid Until
                </label>
                <input type="datetime-local" name="valid_until" id="valid_until" 
                    value="{{ old('valid_until', $promoCode->valid_until ? $promoCode->valid_until->format('Y-m-d\TH:i') : '') }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                <p class="text-xs text-gray-500 mt-1">Leave empty for no expiry</p>
            </div>

            <!-- Description -->
            <div class="md:col-span-2">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
                    Description
                </label>
                <textarea name="description" id="description" rows="3"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="Optional description for internal reference">{{ old('description', $promoCode->description) }}</textarea>
            </div>

            <!-- Is Active -->
            <div class="md:col-span-2">
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', $promoCode->is_active) ? 'checked' : '' }}
                        class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                    <span class="ml-2 text-sm text-gray-700">Active (code can be used immediately)</span>
                </label>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="flex justify-end space-x-4 mt-8 pt-6 border-t">
            <a href="{{ route('admin.promo-codes.index') }}" 
                class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">
                Cancel
            </a>
            <button type="submit" 
                class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark transition">
                <i class="fas fa-save mr-2"></i>Update Promo Code
            </button>
        </div>
    </form>
</div>

<script>
document.getElementById('discount_type').addEventListener('change', function() {
    const hint = document.getElementById('discount_hint');
    if (this.value === 'percentage') {
        hint.textContent = 'Enter percentage value (0-100)';
    } else {
        hint.textContent = 'Enter fixed amount in Naira';
    }
});
</script>
@endsection
